/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.resolve.FirTypeResolver;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformer;
import org.jetbrains.kotlin.fir.scopes.FirPosition;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.fir.types.FirImplicitTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirResolvedFunctionTypeRefImpl;
import org.jetbrains.kotlin.fir.types.impl.FirResolvedTypeRefImpl;
import org.jetbrains.kotlin.fir.visitors.CompositeTransformResult;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0017\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSpecificTypeResolverTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformer;", "towerScope", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "position", "Lorg/jetbrains/kotlin/fir/scopes/FirPosition;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/scopes/FirScope;Lorg/jetbrains/kotlin/fir/scopes/FirPosition;Lorg/jetbrains/kotlin/fir/FirSession;)V", "transformFunctionTypeRef", "Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "functionTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirFunctionTypeRef;", "data", "", "transformImplicitTypeRef", "implicitTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirImplicitTypeRef;", "transformResolvedTypeRef", "resolvedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "transformType", "typeRef", "resolvedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "transformTypeRef", "resolve"})
public final class FirSpecificTypeResolverTransformer
extends FirAbstractTreeTransformer {
    private final FirScope towerScope;
    private final FirPosition position;
    private final FirSession session;

    @NotNull
    public CompositeTransformResult<FirTypeRef> transformTypeRef(@NotNull FirTypeRef typeRef, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(typeRef, "typeRef");
        FirTypeResolver typeResolver = FirTypeResolver.Companion.getInstance(this.session);
        typeRef.transformChildren(new FirSpecificTypeResolverTransformer(this.towerScope, FirPosition.OTHER, this.session), null);
        return this.transformType(typeRef, typeResolver.resolveType(typeRef, this.towerScope, this.position));
    }

    @NotNull
    public CompositeTransformResult<FirTypeRef> transformFunctionTypeRef(@NotNull FirFunctionTypeRef functionTypeRef, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(functionTypeRef, "functionTypeRef");
        FirTypeResolver typeResolver = FirTypeResolver.Companion.getInstance(this.session);
        functionTypeRef.transformChildren(this, data2);
        List<FirAnnotationCall> list2 = functionTypeRef.getAnnotations();
        if (list2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableList<org.jetbrains.kotlin.fir.expressions.FirAnnotationCall>");
        }
        List<FirValueParameter> list3 = functionTypeRef.getValueParameters();
        if (list3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableList<org.jetbrains.kotlin.fir.declarations.FirValueParameter>");
        }
        FirElement $this$compose$iv = new FirResolvedFunctionTypeRefImpl(functionTypeRef.getPsi(), this.session, functionTypeRef.isMarkedNullable(), TypeIntrinsics.asMutableList(list2), functionTypeRef.getReceiverTypeRef(), TypeIntrinsics.asMutableList(list3), functionTypeRef.getReturnTypeRef(), typeResolver.resolveType(functionTypeRef, this.towerScope, this.position));
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    private final CompositeTransformResult<FirTypeRef> transformType(FirTypeRef typeRef, ConeKotlinType resolvedType) {
        FirElement $this$compose$iv = new FirResolvedTypeRefImpl(this.session, typeRef.getPsi(), resolvedType, typeRef.getAnnotations());
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    @NotNull
    public CompositeTransformResult<FirTypeRef> transformResolvedTypeRef(@NotNull FirResolvedTypeRef resolvedTypeRef, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(resolvedTypeRef, "resolvedTypeRef");
        FirElement $this$compose$iv = resolvedTypeRef;
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    @NotNull
    public CompositeTransformResult<FirTypeRef> transformImplicitTypeRef(@NotNull FirImplicitTypeRef implicitTypeRef, @Nullable Void data2) {
        Intrinsics.checkParameterIsNotNull(implicitTypeRef, "implicitTypeRef");
        FirElement $this$compose$iv = implicitTypeRef;
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    public FirSpecificTypeResolverTransformer(@NotNull FirScope towerScope, @NotNull FirPosition position, @NotNull FirSession session) {
        Intrinsics.checkParameterIsNotNull(towerScope, "towerScope");
        Intrinsics.checkParameterIsNotNull((Object)position, "position");
        Intrinsics.checkParameterIsNotNull(session, "session");
        this.towerScope = towerScope;
        this.position = position;
        this.session = session;
    }
}

