/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.lang;

import java.io.IOException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.lang.ClasspathCache;
import org.jetbrains.kotlin.com.intellij.util.lang.Resource;

abstract class Loader {
    private final URL myURL;
    private final int myIndex;
    private ClasspathCache.NameFilter myLoadingFilter;

    Loader(URL url, int index2) {
        this.myURL = url;
        this.myIndex = index2;
    }

    URL getBaseURL() {
        return this.myURL;
    }

    @Nullable
    abstract Resource getResource(String var1);

    @NotNull
    abstract ClasspathCache.LoaderData buildData() throws IOException;

    boolean containsName(String name2, String shortName) {
        if (name2 == null || name2.isEmpty()) {
            return true;
        }
        ClasspathCache.NameFilter filter2 = this.myLoadingFilter;
        return filter2 == null || filter2.maybeContains(shortName);
    }

    void applyData(ClasspathCache.LoaderData loaderData) {
        this.myLoadingFilter = loaderData.getNameFilter();
    }
}

