/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import gnu.trove.TLongArrayList;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.LowMemoryWatcher;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.CompressionUtil;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.containers.SLRUMap;
import org.jetbrains.kotlin.com.intellij.util.io.DataInputOutputUtil;
import org.jetbrains.kotlin.com.intellij.util.io.DataOutputStream;
import org.jetbrains.kotlin.com.intellij.util.io.FileChunkKey;
import org.jetbrains.kotlin.com.intellij.util.io.KeyDescriptor;
import org.jetbrains.kotlin.com.intellij.util.io.LimitedInputStream;

public class CompressedAppendableFile {
    private final File myBaseFile;
    private final LowMemoryWatcher myLowMemoryWatcher;
    private byte[] myNextChunkBuffer;
    private int myBufferPosition;
    private boolean myDirty;
    private short[] myChunkLengthTable;
    private int myChunkTableLength;
    private long[] myChunkOffsetTable;
    private static final boolean doDebug = SystemProperties.getBooleanProperty("idea.compressed.file.self.check", false);
    private final TLongArrayList myCompressedChunksFileOffsets = doDebug ? new TLongArrayList() : null;
    public static final int PAGE_LENGTH = SystemProperties.getIntProperty("idea.compressed.file.page.length", 32768);
    private long myFileLength;
    private long myUncompressedFileLength = -1L;
    private final int myAppendBufferLength;
    private static int ourFilesCount;
    private final int myCount = ourFilesCount++;
    private static final FileChunkReadCache ourDecompressedCache;

    public CompressedAppendableFile(File file2) {
        this(file2, 32768);
    }

    private CompressedAppendableFile(File file2, int bufferSize) {
        this.myBaseFile = file2;
        this.myAppendBufferLength = bufferSize;
        assert (bufferSize <= 65535);
        file2.getParentFile().mkdirs();
        this.myLowMemoryWatcher = LowMemoryWatcher.register(() -> {
            this.dropCaches();
            FileChunkReadCache fileChunkReadCache = ourDecompressedCache;
            synchronized (fileChunkReadCache) {
                ourDecompressedCache.clear();
            }
        });
    }

    public synchronized <Data> Data read(long addr, KeyDescriptor<Data> descriptor2) throws IOException {
        try (DataInputStream stream = this.getStream(addr);){
            Object t = descriptor2.read(stream);
            return (Data)t;
        }
    }

    @NotNull
    public synchronized DataInputStream getStream(long addr) throws IOException {
        this.initChunkLengthTable();
        this.loadAppendBuffer();
        DataInputStream dataInputStream = new DataInputStream(new SegmentedChunkInputStream(addr, this.myChunkTableLength, this.myNextChunkBuffer, this.myBufferPosition));
        if (dataInputStream == null) {
            CompressedAppendableFile.$$$reportNull$$$0(0);
        }
        return dataInputStream;
    }

    protected File getChunkLengthFile() {
        return new File(this.myBaseFile.getPath() + ".s");
    }

    private synchronized void initChunkLengthTable() throws IOException {
        if (this.myChunkLengthTable != null) {
            return;
        }
        File chunkLengthFile = this.getChunkLengthFile();
        if (chunkLengthFile.exists()) {
            try (DataInputStream chunkLengthStream = new DataInputStream(new BufferedInputStream(new LimitedInputStream(new FileInputStream(chunkLengthFile), (int)chunkLengthFile.length()){

                @Override
                public int available() {
                    return this.remainingLimit();
                }
            }, 32768));){
                short[] chunkLengthTable = new short[(int)(chunkLengthFile.length() / 2L)];
                int chunkLengthTableLength = 0;
                long o = 0L;
                while (chunkLengthStream.available() != 0) {
                    int chunkLength = DataInputOutputUtil.readINT(chunkLengthStream);
                    o += (long)chunkLength;
                    if (chunkLengthTableLength == chunkLengthTable.length) {
                        chunkLengthTable = CompressedAppendableFile.reallocShortTable(chunkLengthTable);
                    }
                    chunkLengthTable[chunkLengthTableLength++] = (short)chunkLength;
                    if (!doDebug) continue;
                    this.myCompressedChunksFileOffsets.add(o);
                }
                this.myChunkLengthTable = chunkLengthTable;
                this.myChunkTableLength = chunkLengthTableLength;
                if (this.myChunkTableLength >= 32) {
                    int i;
                    long[] chunkOffsetTable = new long[this.myChunkTableLength / 32];
                    long offset2 = 0L;
                    for (i = 0; i < chunkOffsetTable.length; ++i) {
                        int start = i * 32;
                        for (int j = 0; j < 32; ++j) {
                            offset2 += (long)(chunkLengthTable[start + j] & 0xFFFF);
                        }
                        chunkOffsetTable[i] = offset2;
                    }
                    this.myChunkOffsetTable = chunkOffsetTable;
                    if (doDebug) {
                        for (i = 0; i < chunkLengthTableLength; ++i) {
                            this.calcOffsetOfPage(i);
                        }
                    }
                } else {
                    this.myChunkOffsetTable = ArrayUtil.EMPTY_LONG_ARRAY;
                }
                this.myFileLength = this.calcOffsetOfPage(this.myChunkTableLength - 1);
            }
        } else {
            this.myChunkLengthTable = ArrayUtil.EMPTY_SHORT_ARRAY;
            this.myChunkTableLength = 0;
            this.myChunkOffsetTable = ArrayUtil.EMPTY_LONG_ARRAY;
            this.myFileLength = 0L;
        }
        if (this.myUncompressedFileLength == -1L) {
            long tempFileLength = this.getIncompleteChunkFile().length();
            this.myUncompressedFileLength = (long)this.myChunkTableLength * (long)this.myAppendBufferLength + tempFileLength;
            if (this.myUncompressedFileLength != this.myFileLength + tempFileLength && CompressionUtil.DUMP_COMPRESSION_STATS) {
                System.out.println(this.myUncompressedFileLength + "->" + (this.myFileLength + tempFileLength) + " for " + this.myBaseFile);
            }
        }
    }

    /*
     * Loose catch block
     */
    @NotNull
    private synchronized byte[] loadChunk(int chunkNumber) throws IOException {
        block27: {
            Throwable throwable;
            DataInputStream keysStream;
            block23: {
                byte[] byArray;
                block26: {
                    block24: {
                        block25: {
                            if (this.myChunkLengthTable == null) {
                                this.initChunkLengthTable();
                            }
                            assert (chunkNumber < this.myChunkTableLength);
                            keysStream = this.getChunkStream(this.getChunksFile(), chunkNumber);
                            throwable = null;
                            if (keysStream.available() <= 0) break block23;
                            byte[] decompressedBytes = this.decompress(keysStream);
                            if (decompressedBytes.length != this.myAppendBufferLength) assert (false);
                            byArray = decompressedBytes;
                            if (keysStream == null) break block24;
                            if (throwable == null) break block25;
                            try {
                                keysStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block24;
                        }
                        keysStream.close();
                    }
                    if (byArray != null) break block26;
                    CompressedAppendableFile.$$$reportNull$$$0(1);
                }
                return byArray;
            }
            try {
                block28: {
                    if (keysStream != null) {
                        if (throwable != null) {
                            try {
                                keysStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            keysStream.close();
                        }
                    }
                    break block28;
                    {
                        catch (Throwable throwable4) {
                            try {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (keysStream != null) {
                                    if (throwable != null) {
                                        try {
                                            keysStream.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable.addSuppressed(throwable6);
                                        }
                                    } else {
                                        keysStream.close();
                                    }
                                }
                                throw throwable5;
                            }
                        }
                    }
                }
                assert (false) : "data corruption detected:" + chunkNumber + "," + this.myChunkTableLength;
                if (ArrayUtil.EMPTY_BYTE_ARRAY != null) break block27;
            }
            catch (AssertionError | RuntimeException e) {
                throw new IOException((Throwable)e);
            }
            CompressedAppendableFile.$$$reportNull$$$0(2);
        }
        return ArrayUtil.EMPTY_BYTE_ARRAY;
    }

    @NotNull
    private DataInputStream getChunkStream(File appendFile, int pageNumber) throws IOException {
        int limit;
        long pageStartOffset;
        long pageEndOffset;
        assert (this.myFileLength != 0L);
        long l = pageEndOffset = pageNumber < this.myChunkTableLength ? this.calcOffsetOfPage(pageNumber) : this.myFileLength;
        if (pageNumber > 0) {
            pageStartOffset = this.calcOffsetOfPage(pageNumber - 1);
            limit = (int)(pageEndOffset - pageStartOffset);
        } else {
            pageStartOffset = 0L;
            limit = (int)pageEndOffset;
        }
        DataInputStream dataInputStream = new DataInputStream(this.getChunkInputStream(appendFile, pageStartOffset, limit));
        if (dataInputStream == null) {
            CompressedAppendableFile.$$$reportNull$$$0(3);
        }
        return dataInputStream;
    }

    private long calcOffsetOfPage(int pageNumber) {
        int calculatedOffset = (pageNumber + 1) / 32;
        long offset2 = calculatedOffset > 0 ? this.myChunkOffsetTable[calculatedOffset - 1] : 0L;
        int baseOffset = calculatedOffset * 32;
        int len = (pageNumber + 1) % 32;
        for (int index2 = 0; index2 < len; ++index2) {
            offset2 += (long)(this.myChunkLengthTable[baseOffset + index2] & 0xFFFF);
        }
        if (doDebug) assert (this.myCompressedChunksFileOffsets.get(pageNumber) == offset2);
        return offset2;
    }

    @NotNull
    protected InputStream getChunkInputStream(File appendFile, long offset2, int pageSize) throws IOException {
        FileInputStream in = new FileInputStream(appendFile);
        if (offset2 > 0L) {
            in.skip(offset2);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new LimitedInputStream(in, pageSize){

            @Override
            public int available() {
                return this.remainingLimit();
            }
        }, pageSize);
        if (bufferedInputStream == null) {
            CompressedAppendableFile.$$$reportNull$$$0(4);
        }
        return bufferedInputStream;
    }

    public void append(byte[] buffer, int size) throws IOException {
        this.append(buffer, 0, size);
    }

    public synchronized void append(byte[] buffer, int offset2, int size) throws IOException {
        int bytesToWriteInTheBuffer;
        int newBufferSize;
        if (size == 0) {
            return;
        }
        if (this.myNextChunkBuffer == null) {
            this.loadAppendBuffer();
        }
        if (this.myNextChunkBuffer.length != this.myAppendBufferLength && this.myBufferPosition + size >= this.myNextChunkBuffer.length && (newBufferSize = this.calcBufferSize(this.myBufferPosition + size)) != this.myNextChunkBuffer.length) {
            this.myNextChunkBuffer = Arrays.copyOf(this.myNextChunkBuffer, newBufferSize);
        }
        int bufferPosition = offset2;
        for (int sizeToWrite = size; sizeToWrite > 0; sizeToWrite -= bytesToWriteInTheBuffer) {
            bytesToWriteInTheBuffer = Math.min(this.myNextChunkBuffer.length - this.myBufferPosition, sizeToWrite);
            System.arraycopy(buffer, bufferPosition, this.myNextChunkBuffer, this.myBufferPosition, bytesToWriteInTheBuffer);
            this.myBufferPosition += bytesToWriteInTheBuffer;
            bufferPosition += bytesToWriteInTheBuffer;
            this.saveNextChunkIfNeeded();
        }
        if (this.myUncompressedFileLength == -1L) {
            this.length();
        }
        this.myUncompressedFileLength += (long)size;
        this.myDirty = true;
    }

    private synchronized void loadAppendBuffer() throws IOException {
        if (this.myNextChunkBuffer != null) {
            return;
        }
        File tempAppendFile = this.getIncompleteChunkFile();
        if (tempAppendFile.exists()) {
            this.myBufferPosition = (int)tempAppendFile.length();
            this.myNextChunkBuffer = new byte[this.calcBufferSize(this.myBufferPosition)];
            try (FileInputStream stream = new FileInputStream(tempAppendFile);){
                stream.read(this.myNextChunkBuffer, 0, this.myBufferPosition);
            }
        } else {
            this.myBufferPosition = 0;
            this.myNextChunkBuffer = new byte[1024];
        }
    }

    private int calcBufferSize(int position) {
        return Math.min(this.myAppendBufferLength, Integer.highestOneBit(Math.max(1023, position)) << 1);
    }

    private void saveNextChunkIfNeeded() throws IOException {
        if (this.myBufferPosition == this.myNextChunkBuffer.length) {
            BufferExposingByteArrayOutputStream compressedOut = new BufferExposingByteArrayOutputStream();
            DataOutputStream compressedDataOut = new DataOutputStream(compressedOut);
            this.compress(compressedDataOut, this.myNextChunkBuffer);
            compressedDataOut.close();
            assert (compressedDataOut.size() <= 65535);
            this.saveChunk(compressedOut, this.myFileLength);
            this.myBufferPosition = 0;
            this.initChunkLengthTable();
            this.myFileLength += (long)compressedOut.size();
            if (doDebug) {
                this.myCompressedChunksFileOffsets.add(this.myFileLength);
            }
            if (this.myChunkLengthTable.length == this.myChunkTableLength) {
                this.myChunkLengthTable = CompressedAppendableFile.reallocShortTable(this.myChunkLengthTable);
            }
            this.myChunkLengthTable[this.myChunkTableLength++] = (short)compressedOut.size();
            if (this.myChunkTableLength / 32 > this.myChunkOffsetTable.length) {
                long[] newChunkOffsetTable = new long[this.myChunkOffsetTable.length + 1];
                System.arraycopy(this.myChunkOffsetTable, 0, newChunkOffsetTable, 0, this.myChunkOffsetTable.length);
                newChunkOffsetTable[this.myChunkOffsetTable.length] = this.myFileLength;
                this.myChunkOffsetTable = newChunkOffsetTable;
            }
            byte[] bytes2 = new byte[this.myAppendBufferLength];
            System.arraycopy(this.myNextChunkBuffer, 0, bytes2, 0, this.myAppendBufferLength);
            ourDecompressedCache.put(this, this.myChunkTableLength - 1, bytes2);
        }
    }

    @NotNull
    private static short[] reallocShortTable(short[] table) {
        short[] newTable = new short[Math.max(table.length * 8 / 5, table.length + 1)];
        System.arraycopy(table, 0, newTable, 0, table.length);
        if (newTable == null) {
            CompressedAppendableFile.$$$reportNull$$$0(5);
        }
        return newTable;
    }

    protected int compress(DataOutputStream compressedDataOut, byte[] buffer) throws IOException {
        return CompressionUtil.writeCompressedWithoutOriginalBufferLength(compressedDataOut, buffer, this.myAppendBufferLength);
    }

    @NotNull
    protected byte[] decompress(DataInputStream keysStream) throws IOException {
        byte[] byArray = CompressionUtil.readCompressedWithoutOriginalBufferLength(keysStream, this.myAppendBufferLength);
        if (byArray == null) {
            CompressedAppendableFile.$$$reportNull$$$0(6);
        }
        return byArray;
    }

    protected void saveChunk(BufferExposingByteArrayOutputStream compressedChunk, long endOfFileOffset) throws IOException {
        try (DataOutputStream stream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.getChunksFile(), true)));){
            stream.write(compressedChunk.getInternalBuffer(), 0, compressedChunk.size());
        }
        var5_4 = null;
        try (DataOutputStream chunkLengthStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.getChunkLengthFile(), true)));){
            DataInputOutputUtil.writeINT(chunkLengthStream, compressedChunk.size());
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
    }

    @NotNull
    protected File getChunksFile() {
        File file2 = new File(this.myBaseFile.getPath() + ".a");
        if (file2 == null) {
            CompressedAppendableFile.$$$reportNull$$$0(7);
        }
        return file2;
    }

    private void saveIncompleteChunk() {
        if (this.myNextChunkBuffer != null && this.myDirty) {
            block19: {
                File incompleteChunkFile = this.getIncompleteChunkFile();
                try {
                    this.saveNextChunkIfNeeded();
                    if (this.myBufferPosition != 0) {
                        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(incompleteChunkFile));){
                            stream.write(this.myNextChunkBuffer, 0, this.myBufferPosition);
                            break block19;
                        }
                    }
                    incompleteChunkFile.delete();
                }
                catch (FileNotFoundException ex) {
                    File parentFile = incompleteChunkFile.getParentFile();
                    if (!parentFile.exists()) {
                        if (parentFile.mkdirs()) {
                            this.saveIncompleteChunk();
                            return;
                        }
                        throw new RuntimeException("Failed to write:" + incompleteChunkFile, ex);
                    }
                    throw new RuntimeException(ex);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            this.myDirty = false;
        }
    }

    @NotNull
    private File getIncompleteChunkFile() {
        File file2 = new File(this.myBaseFile.getPath() + ".at");
        if (file2 == null) {
            CompressedAppendableFile.$$$reportNull$$$0(8);
        }
        return file2;
    }

    public synchronized void dropCaches() {
    }

    public synchronized void force() {
        this.saveIncompleteChunk();
    }

    public synchronized void dispose() {
        this.force();
        this.myLowMemoryWatcher.stop();
    }

    public synchronized long length() {
        if (this.myUncompressedFileLength == -1L && this.myChunkLengthTable == null) {
            try {
                this.initChunkLengthTable();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.myUncompressedFileLength;
    }

    public int hashCode() {
        return this.myCount;
    }

    static {
        ourDecompressedCache = new FileChunkReadCache();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/kotlin/com/intellij/util/io/CompressedAppendableFile";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStream";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadChunk";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChunkStream";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChunkInputStream";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "reallocShortTable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "decompress";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChunksFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncompleteChunkFile";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class SegmentedChunkInputStream
    extends InputStream {
        private final long myAddr;
        private final int myChunkLengthTableSnapshotLength;
        private final byte[] myNextChunkBufferSnapshot;
        private final int myBufferPositionSnapshot;
        private InputStream bytesFromCompressedBlock;
        private InputStream bytesFromTempAppendBlock;
        private int myCurrentPageNumber;
        private int myPageOffset;

        SegmentedChunkInputStream(long addr, int chunkLengthTableSnapshotLength, byte[] tableRef, int position) {
            this.myAddr = addr;
            this.myChunkLengthTableSnapshotLength = chunkLengthTableSnapshotLength;
            this.myNextChunkBufferSnapshot = tableRef;
            this.myBufferPositionSnapshot = position;
            this.myCurrentPageNumber = (int)(this.myAddr / (long)CompressedAppendableFile.this.myAppendBufferLength);
            this.myPageOffset = (int)(this.myAddr % (long)CompressedAppendableFile.this.myAppendBufferLength);
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) throws IOException {
            if (b == null) {
                SegmentedChunkInputStream.$$$reportNull$$$0(0);
            }
            if (this.bytesFromCompressedBlock == null) {
                byte[] decompressedBytes = this.myCurrentPageNumber < this.myChunkLengthTableSnapshotLength ? ourDecompressedCache.get(CompressedAppendableFile.this, this.myCurrentPageNumber) : ArrayUtil.EMPTY_BYTE_ARRAY;
                this.bytesFromCompressedBlock = new ByteArrayInputStream(decompressedBytes, this.myPageOffset, decompressedBytes.length);
            }
            int readBytesCount = 0;
            if (this.bytesFromCompressedBlock.available() > 0) {
                readBytesCount = this.bytesFromCompressedBlock.read(b, off, len);
                this.myPageOffset += readBytesCount;
                if (this.myPageOffset == CompressedAppendableFile.this.myAppendBufferLength) {
                    ++this.myCurrentPageNumber;
                    this.myPageOffset = 0;
                }
                if (readBytesCount == len) {
                    return readBytesCount;
                }
            }
            while (this.myCurrentPageNumber < this.myChunkLengthTableSnapshotLength) {
                byte[] decompressedBytes = ourDecompressedCache.get(CompressedAppendableFile.this, this.myCurrentPageNumber);
                this.bytesFromCompressedBlock = new ByteArrayInputStream(decompressedBytes, 0, decompressedBytes.length);
                int read2 = this.bytesFromCompressedBlock.read(b, off + readBytesCount, len - readBytesCount);
                this.myPageOffset += read2;
                if (this.myPageOffset == CompressedAppendableFile.this.myAppendBufferLength) {
                    ++this.myCurrentPageNumber;
                    this.myPageOffset = 0;
                }
                if ((readBytesCount += read2) != len) continue;
                return readBytesCount;
            }
            if (this.bytesFromTempAppendBlock == null) {
                this.bytesFromTempAppendBlock = new ByteArrayInputStream(this.myNextChunkBufferSnapshot, this.myPageOffset, this.myBufferPositionSnapshot);
            }
            return readBytesCount + this.bytesFromTempAppendBlock.read(b, off + readBytesCount, len - readBytesCount);
        }

        @Override
        public int read() throws IOException {
            byte[] buf = new byte[]{0};
            int read2 = this.read(buf);
            if (read2 == -1) {
                return -1;
            }
            return buf[0] & 0xFF;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/kotlin/com/intellij/util/io/CompressedAppendableFile$SegmentedChunkInputStream", "read"));
        }
    }

    private static class FileChunkReadCache
    extends SLRUMap<FileChunkKey<CompressedAppendableFile>, byte[]> {
        private final FileChunkKey<CompressedAppendableFile> myKey = new FileChunkKey<Object>(null, 0L);

        FileChunkReadCache() {
            super(64, 64);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @NotNull
        public byte[] get(CompressedAppendableFile file2, int page) throws IOException {
            FileChunkReadCache fileChunkReadCache = this;
            // MONITORENTER : fileChunkReadCache
            this.myKey.setup(file2, page);
            byte[] bytes2 = (byte[])this.get(this.myKey);
            if (bytes2 != null) {
                // MONITOREXIT : fileChunkReadCache
                if (bytes2 != null) return bytes2;
                FileChunkReadCache.$$$reportNull$$$0(0);
                return bytes2;
            }
            // MONITOREXIT : fileChunkReadCache
            bytes2 = file2.loadChunk(page);
            fileChunkReadCache = this;
            // MONITORENTER : fileChunkReadCache
            this.put(file2, page, bytes2);
            // MONITOREXIT : fileChunkReadCache
            if (bytes2 != null) return bytes2;
            FileChunkReadCache.$$$reportNull$$$0(1);
            return bytes2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(CompressedAppendableFile file2, long page, byte[] bytes2) {
            FileChunkReadCache fileChunkReadCache = this;
            synchronized (fileChunkReadCache) {
                this.myKey.setup(file2, page);
                this.put(this.myKey, bytes2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/io/CompressedAppendableFile$FileChunkReadCache", "get"));
        }
    }
}

