/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import gnu.trove.TLongArrayList;
import java.lang.ref.Reference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Computable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Getter;
import org.jetbrains.kotlin.com.intellij.openapi.util.ModificationTracker;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProfiler;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.ProfilingInfo;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.containers.NotNullList;

public abstract class CachedValueBase<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.CachedValueImpl");
    private static final RecursionGuard ourGuard = RecursionManager.createGuard("cachedValue");
    private volatile SoftReference<Data<T>> myData;

    private Data<T> computeData(@Nullable CachedValueProvider.Result<T> result2) {
        ProfilingInfo profilingInfo;
        long[] inferredTimeStamps;
        Object[] inferredDependencies;
        Object value = result2 == null ? null : (Object)result2.getValue();
        Object[] dependencies2 = this.getDependencies(result2);
        if (dependencies2 == null) {
            inferredDependencies = null;
            inferredTimeStamps = null;
        } else {
            TLongArrayList timeStamps = new TLongArrayList(dependencies2.length);
            NotNullList<Object> deps = new NotNullList<Object>(dependencies2.length);
            this.collectDependencies(timeStamps, deps, dependencies2);
            inferredDependencies = ArrayUtil.toObjectArray(deps);
            inferredTimeStamps = timeStamps.toNativeArray();
        }
        if (result2 != null && CachedValueProfiler.canProfile() && (profilingInfo = CachedValueProfiler.getInstance().getTemporaryInfo(result2)) != null) {
            return new ProfilingData(value, inferredDependencies, inferredTimeStamps, profilingInfo);
        }
        return new Data<Object>(value, inferredDependencies, inferredTimeStamps);
    }

    @Nullable
    private synchronized Data<T> cacheOrGetData(@Nullable Data<T> expected, @Nullable Data<T> updatedValue) {
        if (expected != this.getRawData()) {
            return null;
        }
        if (updatedValue != null) {
            this.myData = new SoftReference<Data<Data<T>>>(updatedValue);
            return updatedValue;
        }
        return expected;
    }

    private synchronized void setData(@Nullable Data<T> data2) {
        this.myData = new SoftReference<Data<Data<T>>>(data2);
    }

    @Nullable
    protected Object[] getDependencies(CachedValueProvider.Result<T> result2) {
        return result2 == null ? null : result2.getDependencyItems();
    }

    @Nullable
    protected Object[] getDependenciesPlusValue(CachedValueProvider.Result<? extends T> result2) {
        if (result2 == null) {
            return null;
        }
        Object[] items = result2.getDependencyItems();
        T value = result2.getValue();
        return value == null ? items : ArrayUtil.append(items, value);
    }

    public void clear() {
        this.setData(null);
    }

    public boolean hasUpToDateValue() {
        return this.getUpToDateOrNull() != null;
    }

    @Nullable
    public final Data<T> getUpToDateOrNull() {
        Data<T> data2 = this.getRawData();
        if (data2 != null) {
            if (this.isUpToDate(data2)) {
                return data2;
            }
            if (data2 instanceof ProfilingData) {
                ((ProfilingData)data2).myProfilingInfo.valueDisposed();
            }
        }
        return null;
    }

    @Nullable
    final Data<T> getRawData() {
        return SoftReference.dereference(this.myData);
    }

    protected boolean isUpToDate(@NotNull Data data2) {
        if (data2 == null) {
            CachedValueBase.$$$reportNull$$$0(0);
        }
        if (data2.myTimeStamps == null) {
            return true;
        }
        for (int i = 0; i < data2.myDependencies.length; ++i) {
            Object dependency = data2.myDependencies[i];
            if (dependency == null || !this.isDependencyOutOfDate(dependency, data2.myTimeStamps[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean isDependencyOutOfDate(Object dependency, long oldTimeStamp) {
        if (dependency instanceof CachedValueBase) {
            return !((CachedValueBase)dependency).hasUpToDateValue();
        }
        long timeStamp = this.getTimeStamp(dependency);
        return timeStamp < 0L || timeStamp != oldTimeStamp;
    }

    private void collectDependencies(TLongArrayList timeStamps, List<Object> resultingDeps, Object[] dependencies2) {
        for (Object dependency : dependencies2) {
            if (dependency == null || dependency == ObjectUtils.NULL) continue;
            if (dependency instanceof Object[]) {
                this.collectDependencies(timeStamps, resultingDeps, (Object[])dependency);
                continue;
            }
            resultingDeps.add(dependency);
            timeStamps.add(this.getTimeStamp(dependency));
        }
    }

    protected long getTimeStamp(Object dependency) {
        if (dependency instanceof ModificationTracker) {
            return ((ModificationTracker)dependency).getModificationCount();
        }
        if (dependency instanceof Reference) {
            Object original = ((Reference)dependency).get();
            if (original == null) {
                return -1L;
            }
            return this.getTimeStamp(original);
        }
        if (dependency instanceof Ref) {
            Object original = ((Ref)dependency).get();
            if (original == null) {
                return -1L;
            }
            return this.getTimeStamp(original);
        }
        if (dependency instanceof Document) {
            return ((Document)dependency).getModificationStamp();
        }
        if (dependency instanceof CachedValueBase) {
            return 0L;
        }
        LOG.error("Wrong dependency type: " + dependency.getClass());
        return -1L;
    }

    public T setValue(CachedValueProvider.Result<T> result2) {
        Data<T> data2 = this.computeData(result2);
        this.setData(data2);
        this.valueUpdated(result2.getDependencyItems());
        return data2.getValue();
    }

    protected void valueUpdated(@Nullable Object[] dependencies2) {
    }

    public abstract boolean isFromMyProject(Project var1);

    @Nullable
    protected <P> T getValueWithLock(P param) {
        Data data2 = this.getUpToDateOrNull();
        if (data2 != null) {
            return data2.getValue();
        }
        RecursionGuard.StackStamp stamp = ourGuard.markStack();
        Computable<Data> calcData = () -> this.computeData(this.doCompute(param));
        data2 = ourGuard.doPreventingRecursion(this, true, calcData);
        if (data2 == null) {
            data2 = calcData.compute();
        } else if (stamp.mayCacheNow()) {
            boolean reuse;
            Data<T> alreadyComputed;
            Data<T> toReturn;
            while ((toReturn = this.cacheOrGetData(alreadyComputed, (reuse = (alreadyComputed = this.getRawData()) != null && this.isUpToDate(alreadyComputed)) ? null : data2)) == null) {
            }
            this.valueUpdated(((Data)toReturn).myDependencies);
            return toReturn.getValue();
        }
        return data2.getValue();
    }

    protected abstract <P> CachedValueProvider.Result<T> doCompute(P var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/kotlin/com/intellij/util/CachedValueBase", "isUpToDate"));
    }

    private static class ProfilingData<T>
    extends Data<T> {
        @NotNull
        private final ProfilingInfo myProfilingInfo;

        private ProfilingData(T value, Object[] dependencies2, long[] timeStamps, @NotNull ProfilingInfo profilingInfo) {
            if (profilingInfo == null) {
                ProfilingData.$$$reportNull$$$0(0);
            }
            super(value, dependencies2, timeStamps);
            this.myProfilingInfo = profilingInfo;
        }

        @Override
        public T getValue() {
            this.myProfilingInfo.valueUsed();
            return super.getValue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profilingInfo", "org/jetbrains/kotlin/com/intellij/util/CachedValueBase$ProfilingData", "<init>"));
        }
    }

    protected static class Data<T>
    implements Getter<T> {
        private final T myValue;
        private final Object[] myDependencies;
        private final long[] myTimeStamps;

        Data(T value, Object[] dependencies2, long[] timeStamps) {
            this.myValue = value;
            this.myDependencies = dependencies2;
            this.myTimeStamps = timeStamps;
        }

        @Override
        public final T get() {
            return this.getValue();
        }

        public T getValue() {
            return this.myValue;
        }
    }
}

