/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.Function;

public class PsiCacheKey<T, H extends PsiElement>
extends Key<SoftReference<Pair<Long, T>>> {
    private final Function<? super H, ? extends T> myFunction;
    @NotNull
    private final Key<?> myModifyCause;

    private PsiCacheKey(@NonNls @NotNull String name2, @NotNull Function<? super H, ? extends T> function2, @NotNull Key<?> modifyCause) {
        if (name2 == null) {
            PsiCacheKey.$$$reportNull$$$0(0);
        }
        if (function2 == null) {
            PsiCacheKey.$$$reportNull$$$0(1);
        }
        if (modifyCause == null) {
            PsiCacheKey.$$$reportNull$$$0(2);
        }
        super(name2);
        this.myFunction = function2;
        this.myModifyCause = modifyCause;
    }

    public final T getValue(@NotNull H h) {
        T result2;
        if (h == null) {
            PsiCacheKey.$$$reportNull$$$0(3);
        }
        if ((result2 = this.getCachedValueOrNull(h)) != null) {
            return result2;
        }
        result2 = this.myFunction.fun(h);
        long count2 = this.getModificationCount((PsiElement)h);
        h.putUserData(this, new SoftReference<Pair<Long, T>>(new Pair<Long, T>(count2, result2)));
        return result2;
    }

    @Nullable
    public final T getCachedValueOrNull(@NotNull H h) {
        SoftReference ref;
        Pair data2;
        if (h == null) {
            PsiCacheKey.$$$reportNull$$$0(4);
        }
        if ((data2 = (Pair)SoftReference.dereference(ref = (SoftReference)h.getUserData(this))) == null || ((Long)data2.getFirst()).longValue() != this.getModificationCount((PsiElement)h)) {
            return null;
        }
        return (T)data2.getSecond();
    }

    private long getModificationCount(@NotNull PsiElement element) {
        PsiModificationTracker tracker;
        PsiFile file2;
        if (element == null) {
            PsiCacheKey.$$$reportNull$$$0(5);
        }
        long fileStamp = (file2 = element.getContainingFile()) == null || file2.isPhysical() ? 0L : file2.getModificationStamp();
        PsiModificationTracker psiModificationTracker = tracker = file2 == null ? element.getManager().getModificationTracker() : file2.getManager().getModificationTracker();
        if (this.myModifyCause.equals(PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT)) {
            return fileStamp + tracker.getJavaStructureModificationCount();
        }
        if (this.myModifyCause.equals(PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT)) {
            return fileStamp + tracker.getOutOfCodeBlockModificationCount();
        }
        if (this.myModifyCause.equals(PsiModificationTracker.MODIFICATION_COUNT)) {
            return fileStamp + tracker.getModificationCount();
        }
        throw new AssertionError((Object)("No modification tracker found for key " + this.myModifyCause));
    }

    public static <T, H extends PsiElement> PsiCacheKey<T, H> create(@NonNls @NotNull String name2, @NotNull Function<? super H, ? extends T> function2, @NotNull Key<?> modifyCause) {
        if (name2 == null) {
            PsiCacheKey.$$$reportNull$$$0(6);
        }
        if (function2 == null) {
            PsiCacheKey.$$$reportNull$$$0(7);
        }
        if (modifyCause == null) {
            PsiCacheKey.$$$reportNull$$$0(8);
        }
        return new PsiCacheKey<T, H>(name2, function2, modifyCause);
    }

    public static <T, H extends PsiElement> PsiCacheKey<T, H> create(@NonNls @NotNull String name2, @NotNull Function<? super H, ? extends T> function2) {
        if (name2 == null) {
            PsiCacheKey.$$$reportNull$$$0(9);
        }
        if (function2 == null) {
            PsiCacheKey.$$$reportNull$$$0(10);
        }
        return PsiCacheKey.create(name2, function2, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifyCause";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "h";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiCacheKey";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getValue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCachedValueOrNull";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getModificationCount";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

