/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.light;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentationProviders;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.AtomicNotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaDirectoryService;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModule;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModuleReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModuleReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackageAccessibilityStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiProvidesStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiRequiresStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiUsesStatement;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightElement;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class LightJavaModule
extends LightElement
implements PsiJavaModule {
    private final LightJavaModuleReferenceElement myRefElement;
    private final VirtualFile myJarRoot;
    private final NotNullLazyValue<List<PsiPackageAccessibilityStatement>> myExports;

    private LightJavaModule(@NotNull PsiManager manager, @NotNull VirtualFile jarRoot) {
        if (manager == null) {
            LightJavaModule.$$$reportNull$$$0(0);
        }
        if (jarRoot == null) {
            LightJavaModule.$$$reportNull$$$0(1);
        }
        super(manager, JavaLanguage.INSTANCE);
        this.myExports = AtomicNotNullLazyValue.createValue(() -> this.findExports());
        this.myJarRoot = jarRoot;
        this.myRefElement = new LightJavaModuleReferenceElement(manager, LightJavaModule.moduleName(jarRoot));
    }

    @NotNull
    public VirtualFile getRootVirtualFile() {
        VirtualFile virtualFile2 = this.myJarRoot;
        if (virtualFile2 == null) {
            LightJavaModule.$$$reportNull$$$0(2);
        }
        return virtualFile2;
    }

    @Override
    @Nullable
    public PsiDocComment getDocComment() {
        return null;
    }

    @Override
    @NotNull
    public Iterable<PsiRequiresStatement> getRequires() {
        List<PsiRequiresStatement> list2 = Collections.emptyList();
        if (list2 == null) {
            LightJavaModule.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    @NotNull
    public Iterable<PsiPackageAccessibilityStatement> getExports() {
        Iterable iterable = this.myExports.getValue();
        if (iterable == null) {
            LightJavaModule.$$$reportNull$$$0(4);
        }
        return iterable;
    }

    private List<PsiPackageAccessibilityStatement> findExports() {
        final ArrayList<PsiPackageAccessibilityStatement> exports = ContainerUtil.newArrayList();
        VfsUtilCore.visitChildrenRecursively(this.myJarRoot, new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){
            private final JavaDirectoryService service;
            {
                super(arg0);
                this.service = JavaDirectoryService.getInstance();
            }

            @Override
            public boolean visitFile(@NotNull VirtualFile file2) {
                String packageName;
                PsiPackage pkg;
                PsiDirectory directory;
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2.isDirectory() && !LightJavaModule.this.myJarRoot.equals(file2) && (directory = LightJavaModule.this.myManager.findDirectory(file2)) != null && (pkg = this.service.getPackage(directory)) != null && !(packageName = pkg.getQualifiedName()).isEmpty() && !PsiUtil.isPackageEmpty(new PsiDirectory[]{directory}, packageName)) {
                    exports.add(new LightPackageAccessibilityStatement(LightJavaModule.this.myManager, packageName));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightJavaModule$1", "visitFile"));
            }
        });
        return exports;
    }

    @Override
    @NotNull
    public Iterable<PsiPackageAccessibilityStatement> getOpens() {
        List<PsiPackageAccessibilityStatement> list2 = Collections.emptyList();
        if (list2 == null) {
            LightJavaModule.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @Override
    @NotNull
    public Iterable<PsiUsesStatement> getUses() {
        List<PsiUsesStatement> list2 = Collections.emptyList();
        if (list2 == null) {
            LightJavaModule.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    @NotNull
    public Iterable<PsiProvidesStatement> getProvides() {
        List<PsiProvidesStatement> list2 = Collections.emptyList();
        if (list2 == null) {
            LightJavaModule.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Override
    @NotNull
    public PsiJavaModuleReferenceElement getNameIdentifier() {
        LightJavaModuleReferenceElement lightJavaModuleReferenceElement = this.myRefElement;
        if (lightJavaModuleReferenceElement == null) {
            LightJavaModule.$$$reportNull$$$0(8);
        }
        return lightJavaModuleReferenceElement;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myRefElement.getReferenceText();
        if (string == null) {
            LightJavaModule.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            LightJavaModule.$$$reportNull$$$0(10);
        }
        throw new IncorrectOperationException("Cannot modify automatic module '" + this.getName() + "'");
    }

    @Override
    public PsiModifierList getModifierList() {
        return null;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name2) {
        if (name2 == null) {
            LightJavaModule.$$$reportNull$$$0(11);
        }
        return false;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = ObjectUtils.notNull(this.myManager.findDirectory(this.myJarRoot), super.getNavigationElement());
        if (psiElement == null) {
            LightJavaModule.$$$reportNull$$$0(12);
        }
        return psiElement;
    }

    public boolean equals(Object obj) {
        return obj instanceof LightJavaModule && this.myJarRoot.equals(((LightJavaModule)obj).myJarRoot) && this.getManager() == ((LightJavaModule)obj).getManager();
    }

    public int hashCode() {
        return this.getName().hashCode() * 31 + this.getManager().hashCode();
    }

    @Override
    public String toString() {
        return "PsiJavaModule:" + this.getName();
    }

    @NotNull
    public static LightJavaModule getModule(@NotNull PsiManager manager, @NotNull VirtualFile jarRoot) {
        if (manager == null) {
            LightJavaModule.$$$reportNull$$$0(13);
        }
        if (jarRoot == null) {
            LightJavaModule.$$$reportNull$$$0(14);
        }
        PsiDirectory directory = manager.findDirectory(jarRoot);
        assert (directory != null) : jarRoot;
        LightJavaModule lightJavaModule = (LightJavaModule)CachedValuesManager.getCachedValue(directory, () -> {
            LightJavaModule module2 = new LightJavaModule(manager, jarRoot);
            return CachedValueProvider.Result.create(module2, directory);
        });
        if (lightJavaModule == null) {
            LightJavaModule.$$$reportNull$$$0(15);
        }
        return lightJavaModule;
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static String moduleName(@NotNull VirtualFile jarRoot) {
        block25: {
            Throwable throwable;
            InputStream stream;
            block22: {
                String string;
                block23: {
                    block24: {
                        VirtualFile manifest2;
                        if (jarRoot == null) {
                            LightJavaModule.$$$reportNull$$$0(16);
                        }
                        if ((manifest2 = jarRoot.findFileByRelativePath("META-INF/MANIFEST.MF")) == null) break block25;
                        stream = manifest2.getInputStream();
                        throwable = null;
                        String claimed = new Manifest(stream).getMainAttributes().getValue("Automatic-Module-Name");
                        if (claimed == null) break block22;
                        string = claimed;
                        if (stream == null) break block23;
                        if (throwable == null) break block24;
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block23;
                    }
                    stream.close();
                }
                String string2 = string;
                if (string2 == null) {
                    LightJavaModule.$$$reportNull$$$0(17);
                }
                return string2;
            }
            try {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stream.close();
                    }
                }
                break block25;
                {
                    catch (Throwable throwable4) {
                        try {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (stream != null) {
                                if (throwable != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    stream.close();
                                }
                            }
                            throw throwable5;
                        }
                    }
                }
            }
            catch (IOException e) {
                Logger.getInstance(LightJavaModule.class).warn(e);
            }
        }
        String string = LightJavaModule.moduleName(jarRoot.getNameWithoutExtension());
        if (string == null) {
            LightJavaModule.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public static String moduleName(@NotNull String name2) {
        Matcher m;
        if (name2 == null) {
            LightJavaModule.$$$reportNull$$$0(19);
        }
        if ((m = Patterns.VERSION.matcher(name2)).find()) {
            name2 = name2.substring(0, m.start());
        }
        name2 = Patterns.NON_NAME.matcher(name2).replaceAll(".");
        name2 = Patterns.DOT_SEQUENCE.matcher(name2).replaceAll(".");
        String string = name2 = StringUtil.trimLeading(StringUtil.trimTrailing(name2, '.'), '.');
        if (string == null) {
            LightJavaModule.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarRoot";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightJavaModule";
                break;
            }
            case 10: 
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightJavaModule";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootVirtualFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequires";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExports";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpens";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUses";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvides";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameIdentifier";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 17: 
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 20: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getModule";
                break;
            }
            case 16: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "moduleName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Patterns {
        private static final Pattern VERSION = Pattern.compile("-(\\d+(\\.|$))");
        private static final Pattern NON_NAME = Pattern.compile("[^A-Za-z0-9]");
        private static final Pattern DOT_SEQUENCE = Pattern.compile("\\.{2,}");

        private Patterns() {
        }
    }

    private static class LightPackageAccessibilityStatement
    extends LightElement
    implements PsiPackageAccessibilityStatement {
        private final String myPackageName;

        private LightPackageAccessibilityStatement(@NotNull PsiManager manager, @NotNull String packageName) {
            if (manager == null) {
                LightPackageAccessibilityStatement.$$$reportNull$$$0(0);
            }
            if (packageName == null) {
                LightPackageAccessibilityStatement.$$$reportNull$$$0(1);
            }
            super(manager, JavaLanguage.INSTANCE);
            this.myPackageName = packageName;
        }

        @Override
        @NotNull
        public PsiPackageAccessibilityStatement.Role getRole() {
            PsiPackageAccessibilityStatement.Role role = PsiPackageAccessibilityStatement.Role.EXPORTS;
            if (role == null) {
                LightPackageAccessibilityStatement.$$$reportNull$$$0(2);
            }
            return role;
        }

        @Override
        @Nullable
        public PsiJavaCodeReferenceElement getPackageReference() {
            return null;
        }

        @Override
        @Nullable
        public String getPackageName() {
            return this.myPackageName;
        }

        @Override
        @NotNull
        public Iterable<PsiJavaModuleReferenceElement> getModuleReferences() {
            List<PsiJavaModuleReferenceElement> list2 = Collections.emptyList();
            if (list2 == null) {
                LightPackageAccessibilityStatement.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @Override
        @NotNull
        public List<String> getModuleNames() {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                LightPackageAccessibilityStatement.$$$reportNull$$$0(4);
            }
            return list2;
        }

        @Override
        public String toString() {
            return "PsiPackageAccessibilityStatement";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightJavaModule$LightPackageAccessibilityStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightJavaModule$LightPackageAccessibilityStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRole";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleReferences";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class LightJavaModuleReferenceElement
    extends LightElement
    implements PsiJavaModuleReferenceElement {
        private final String myText;

        private LightJavaModuleReferenceElement(@NotNull PsiManager manager, @NotNull String text2) {
            if (manager == null) {
                LightJavaModuleReferenceElement.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                LightJavaModuleReferenceElement.$$$reportNull$$$0(1);
            }
            super(manager, JavaLanguage.INSTANCE);
            this.myText = text2;
        }

        @Override
        @NotNull
        public String getReferenceText() {
            String string = this.myText;
            if (string == null) {
                LightJavaModuleReferenceElement.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public PsiJavaModuleReference getReference() {
            return null;
        }

        @Override
        public String toString() {
            return "PsiJavaModuleReference";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightJavaModule$LightJavaModuleReferenceElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightJavaModule$LightJavaModuleReferenceElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferenceText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

