/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.file;

import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileTypeRegistry;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.UnknownFileType;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerImpl;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class PsiFileImplUtil {
    private PsiFileImplUtil() {
    }

    public static PsiFile setName(@NotNull PsiFile file2, @NotNull String newName2) throws IncorrectOperationException {
        if (file2 == null) {
            PsiFileImplUtil.$$$reportNull$$$0(0);
        }
        if (newName2 == null) {
            PsiFileImplUtil.$$$reportNull$$$0(1);
        }
        VirtualFile vFile = file2.getViewProvider().getVirtualFile();
        PsiManagerImpl manager = (PsiManagerImpl)file2.getManager();
        try {
            FileDocumentManager fdm;
            Document doc;
            FileType newFileType = FileTypeRegistry.getInstance().getFileTypeByFileName(newName2);
            if ((UnknownFileType.INSTANCE.equals(newFileType) || newFileType.isBinary()) && (doc = (fdm = FileDocumentManager.getInstance()).getCachedDocument(vFile)) != null) {
                fdm.saveDocumentAsIs(doc);
            }
            vFile.rename(manager, newName2);
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e);
        }
        return file2.getViewProvider().isPhysical() ? manager.findFile(vFile) : file2;
    }

    public static void checkSetName(@NotNull PsiFile file2, @NotNull String name2) throws IncorrectOperationException {
        VirtualFile vFile;
        VirtualFile parentFile;
        if (file2 == null) {
            PsiFileImplUtil.$$$reportNull$$$0(2);
        }
        if (name2 == null) {
            PsiFileImplUtil.$$$reportNull$$$0(3);
        }
        if ((parentFile = (vFile = file2.getVirtualFile()).getParent()) == null) {
            return;
        }
        VirtualFile child = parentFile.findChild(name2);
        if (child != null && !child.equals(vFile)) {
            throw new IncorrectOperationException("File " + child.getPresentableUrl() + " already exists.");
        }
    }

    public static void doDelete(@NotNull PsiFile file2) throws IncorrectOperationException {
        if (file2 == null) {
            PsiFileImplUtil.$$$reportNull$$$0(4);
        }
        PsiManagerImpl manager = (PsiManagerImpl)file2.getManager();
        VirtualFile vFile = file2.getVirtualFile();
        try {
            vFile.delete(manager);
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiFileImplUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSetName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doDelete";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

