/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;

public class ShutDownTracker
implements Runnable {
    private final List<Thread> myThreads = new ArrayList<Thread>();
    private final LinkedList<Runnable> myShutdownTasks = new LinkedList();
    private final Thread myThread = new Thread((Runnable)this, "Shutdown tracker");

    private ShutDownTracker() {
        Runtime.getRuntime().addShutdownHook(this.myThread);
    }

    @NotNull
    public static ShutDownTracker getInstance() {
        ShutDownTracker shutDownTracker = ShutDownTrackerHolder.ourInstance;
        if (shutDownTracker == null) {
            ShutDownTracker.$$$reportNull$$$0(0);
        }
        return shutDownTracker;
    }

    public static boolean isShutdownHookRunning() {
        return ShutDownTracker.getInstance().myThread.isAlive();
    }

    @Override
    public void run() {
        Runnable task;
        this.ensureStopperThreadsFinished();
        while ((task = this.removeLast(this.myShutdownTasks)) != null) {
            try {
                task.run();
            }
            catch (Throwable e) {
                Logger.getInstance(ShutDownTracker.class).error(e);
            }
        }
    }

    public final void ensureStopperThreadsFinished() {
        Thread[] threads = this.getStopperThreads();
        long started = System.currentTimeMillis();
        while (threads.length > 0) {
            Thread thread2 = threads[0];
            if (!thread2.isAlive()) {
                if (this.isRegistered(thread2)) {
                    Logger.getInstance(ShutDownTracker.class).error("Thread '" + thread2.getName() + "' did not unregister itself from ShutDownTracker");
                    this.unregisterStopperThread(thread2);
                }
            } else {
                long totalTimeWaited = System.currentTimeMillis() - started;
                if (totalTimeWaited > 3000L) {
                    thread2.interrupt();
                }
                try {
                    thread2.join(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            threads = this.getStopperThreads();
        }
    }

    private synchronized boolean isRegistered(@NotNull Thread thread2) {
        if (thread2 == null) {
            ShutDownTracker.$$$reportNull$$$0(2);
        }
        return this.myThreads.contains(thread2);
    }

    @NotNull
    private synchronized Thread[] getStopperThreads() {
        Thread[] threadArray = this.myThreads.toArray(new Thread[0]);
        if (threadArray == null) {
            ShutDownTracker.$$$reportNull$$$0(3);
        }
        return threadArray;
    }

    public synchronized void unregisterStopperThread(@NotNull Thread thread2) {
        if (thread2 == null) {
            ShutDownTracker.$$$reportNull$$$0(5);
        }
        this.myThreads.remove(thread2);
    }

    private synchronized <T> T removeLast(@NotNull LinkedList<T> list2) {
        if (list2 == null) {
            ShutDownTracker.$$$reportNull$$$0(8);
        }
        return list2.isEmpty() ? null : (T)list2.removeLast();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/ShutDownTracker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/ShutDownTracker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStopperThreads";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "waitFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isRegistered";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerStopperThread";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unregisterStopperThread";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerShutdownTask";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "unregisterShutdownTask";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeLast";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ShutDownTrackerHolder {
        private static final ShutDownTracker ourInstance = new ShutDownTracker();
    }
}

