/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ide.plugins.cl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.diagnostic.PluginException;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginManagerCore;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtilRt;
import org.jetbrains.kotlin.com.intellij.util.lang.UrlClassLoader;

public class PluginClassLoader
extends UrlClassLoader {
    private final ClassLoader[] myParents;
    private final PluginId myPluginId;
    private final String myPluginVersion;
    private final List<String> myLibDirectories;
    private static final ActionWithPluginClassLoader<Class, Void> loadClassInPluginCL;
    private static final ActionWithClassloader<Class, Void> loadClassInCl;
    private static final Set<String> KOTLIN_STDLIB_CLASSES_USED_IN_SIGNATURES;
    private static final ActionWithPluginClassLoader<URL, Void> findResourceInPluginCL;
    private static final ActionWithClassloader<URL, Void> findResourceInCl;
    private static final ActionWithPluginClassLoader<InputStream, Void> getResourceAsStreamInPluginCL;
    private static final ActionWithClassloader<InputStream, Void> getResourceAsStreamInCl;
    private static final ActionWithPluginClassLoader<Void, List<Enumeration<URL>>> findResourcesInPluginCL;
    private static final ActionWithClassloader<Void, List<Enumeration<URL>>> findResourcesInCl;

    public PluginClassLoader(@NotNull List<URL> urls, @NotNull ClassLoader[] parents2, PluginId pluginId, String version, File pluginRoot2) {
        if (urls == null) {
            PluginClassLoader.$$$reportNull$$$0(0);
        }
        if (parents2 == null) {
            PluginClassLoader.$$$reportNull$$$0(1);
        }
        super(PluginClassLoader.build().urls(urls).allowLock().useCache());
        this.myParents = parents2;
        this.myPluginId = pluginId;
        this.myPluginVersion = version;
        this.myLibDirectories = ContainerUtil.newSmartList();
        File libDir = new File(pluginRoot2, "lib");
        if (libDir.exists()) {
            this.myLibDirectories.add(libDir.getAbsolutePath());
        }
    }

    public Class loadClass(@NotNull String name2, boolean resolve2) throws ClassNotFoundException {
        Class c;
        if (name2 == null) {
            PluginClassLoader.$$$reportNull$$$0(2);
        }
        if ((c = this.tryLoadingClass(name2, resolve2, null)) == null) {
            throw new ClassNotFoundException(name2 + " " + this);
        }
        return c;
    }

    @Nullable
    private <Result, ParameterType> Result processResourcesInParents(String name2, ActionWithPluginClassLoader<Result, ParameterType> actionWithPluginClassLoader, ActionWithClassloader<Result, ParameterType> actionWithClassloader, Set<ClassLoader> visited2, ParameterType parameter) {
        for (ClassLoader parent2 : this.myParents) {
            Result resource;
            if (visited2 == null) {
                visited2 = ContainerUtilRt.newHashSet(this);
            }
            if (!visited2.add(parent2) || !(parent2 instanceof PluginClassLoader ? (resource = actionWithPluginClassLoader.execute(name2, (PluginClassLoader)parent2, visited2, actionWithPluginClassLoader, actionWithClassloader, parameter)) != null : (resource = actionWithClassloader.execute(name2, parent2, parameter)) != null)) continue;
            return resource;
        }
        return null;
    }

    @Nullable
    private Class tryLoadingClass(@NotNull String name2, boolean resolve2, @Nullable Set<ClassLoader> visited2) {
        if (name2 == null) {
            PluginClassLoader.$$$reportNull$$$0(3);
        }
        Class c = null;
        if (!PluginClassLoader.mustBeLoadedByPlatform(name2)) {
            c = this.loadClassInsideSelf(name2);
        }
        if (c == null) {
            c = this.processResourcesInParents(name2, loadClassInPluginCL, loadClassInCl, visited2, null);
        }
        if (c != null) {
            if (resolve2) {
                this.resolveClass(c);
            }
            return c;
        }
        return null;
    }

    private static boolean mustBeLoadedByPlatform(String className2) {
        if (className2.startsWith("java.")) {
            return true;
        }
        return className2.startsWith("kotlin.") && (className2.startsWith("kotlin.jvm.functions.") || className2.startsWith("kotlin.reflect.") && className2.indexOf(46, 15) < 0 || KOTLIN_STDLIB_CLASSES_USED_IN_SIGNATURES.contains(className2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Class loadClassInsideSelf(@NotNull String name2) {
        if (name2 == null) {
            PluginClassLoader.$$$reportNull$$$0(4);
        }
        Object object = this.getClassLoadingLock(name2);
        synchronized (object) {
            Class c = this.findLoadedClass(name2);
            if (c != null) {
                return c;
            }
            try {
                c = this._findClass(name2);
            }
            catch (IncompatibleClassChangeError | UnsupportedClassVersionError e) {
                throw new PluginException("While loading class " + name2 + ": " + e.getMessage(), e, this.myPluginId);
            }
            if (c != null) {
                PluginManagerCore.addPluginClass(this.myPluginId);
            }
            return c;
        }
    }

    @Override
    public URL findResource(String name2) {
        URL resource = this.findOwnResource(name2);
        if (resource != null) {
            return resource;
        }
        return this.processResourcesInParents(name2, findResourceInPluginCL, findResourceInCl, null, null);
    }

    @Nullable
    private URL findOwnResource(String name2) {
        URL resource = super.findResource(name2);
        if (resource != null) {
            return resource;
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name2) {
        InputStream stream = this.getOwnResourceAsStream(name2);
        if (stream != null) {
            return stream;
        }
        return this.processResourcesInParents(name2, getResourceAsStreamInPluginCL, getResourceAsStreamInCl, null, null);
    }

    @Nullable
    private InputStream getOwnResourceAsStream(String name2) {
        InputStream stream = super.getResourceAsStream(name2);
        if (stream != null) {
            return stream;
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name2) throws IOException {
        ArrayList<Enumeration<URL>> resources = new ArrayList<Enumeration<URL>>();
        resources.add(this.findOwnResources(name2));
        this.processResourcesInParents(name2, findResourcesInPluginCL, findResourcesInCl, null, resources);
        return new DeepEnumeration(resources.toArray(new Enumeration[resources.size()]));
    }

    private Enumeration<URL> findOwnResources(String name2) throws IOException {
        return super.findResources(name2);
    }

    @Override
    protected String findLibrary(String libName) {
        if (!this.myLibDirectories.isEmpty()) {
            String libFileName = System.mapLibraryName(libName);
            ListIterator<String> i = this.myLibDirectories.listIterator(this.myLibDirectories.size());
            while (i.hasPrevious()) {
                File libFile = new File(i.previous(), libFileName);
                if (!libFile.exists()) continue;
                return libFile.getAbsolutePath();
            }
        }
        return null;
    }

    public String toString() {
        return "PluginClassLoader[" + this.myPluginId + ", " + this.myPluginVersion + "] " + super.toString();
    }

    static {
        if (PluginClassLoader.registerAsParallelCapable()) {
            PluginClassLoader.markParallelCapable(PluginClassLoader.class);
        }
        loadClassInPluginCL = new ActionWithPluginClassLoader<Class, Void>(){

            @Override
            Class execute(String name2, PluginClassLoader classloader, Set<ClassLoader> visited2, ActionWithPluginClassLoader<Class, Void> actionWithPluginClassLoader, ActionWithClassloader<Class, Void> actionWithClassloader, Void parameter) {
                return classloader.tryLoadingClass(name2, false, visited2);
            }

            @Override
            protected Class doExecute(String name2, PluginClassLoader classloader, Void parameter) {
                return null;
            }
        };
        loadClassInCl = new ActionWithClassloader<Class, Void>(){

            @Override
            public Class execute(String name2, ClassLoader classloader, Void parameter) {
                try {
                    return classloader.loadClass(name2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }
        };
        KOTLIN_STDLIB_CLASSES_USED_IN_SIGNATURES = ContainerUtil.set("kotlin.sequences.Sequence", "kotlin.Unit", "kotlin.Pair", "kotlin.Triple", "kotlin.jvm.internal.DefaultConstructorMarker", "kotlin.properties.ReadWriteProperty", "kotlin.properties.ReadOnlyProperty");
        findResourceInPluginCL = new ActionWithPluginClassLoader<URL, Void>(){

            @Override
            protected URL doExecute(String name2, PluginClassLoader classloader, Void parameter) {
                return classloader.findOwnResource(name2);
            }
        };
        findResourceInCl = new ActionWithClassloader<URL, Void>(){

            @Override
            public URL execute(String name2, ClassLoader classloader, Void parameter) {
                return classloader.getResource(name2);
            }
        };
        getResourceAsStreamInPluginCL = new ActionWithPluginClassLoader<InputStream, Void>(){

            @Override
            protected InputStream doExecute(String name2, PluginClassLoader classloader, Void parameter) {
                return classloader.getOwnResourceAsStream(name2);
            }
        };
        getResourceAsStreamInCl = new ActionWithClassloader<InputStream, Void>(){

            @Override
            public InputStream execute(String name2, ClassLoader classloader, Void parameter) {
                return classloader.getResourceAsStream(name2);
            }
        };
        findResourcesInPluginCL = new ActionWithPluginClassLoader<Void, List<Enumeration<URL>>>(){

            @Override
            protected Void doExecute(String name2, PluginClassLoader classloader, List<Enumeration<URL>> enumerations) {
                try {
                    enumerations.add(classloader.findOwnResources(name2));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        };
        findResourcesInCl = new ActionWithClassloader<Void, List<Enumeration<URL>>>(){

            @Override
            public Void execute(String name2, ClassLoader classloader, List<Enumeration<URL>> enumerations) {
                try {
                    enumerations.add(classloader.getResources(name2));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parents";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libDirectories";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/ide/plugins/cl/PluginClassLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "tryLoadingClass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "loadClassInsideSelf";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addLibDirectories";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DeepEnumeration
    implements Enumeration<URL> {
        private final Enumeration<URL>[] myEnumerations;
        private int myIndex;

        DeepEnumeration(Enumeration<URL>[] enumerations) {
            this.myEnumerations = enumerations;
        }

        @Override
        public boolean hasMoreElements() {
            while (this.myIndex < this.myEnumerations.length) {
                Enumeration<URL> e = this.myEnumerations[this.myIndex];
                if (e != null && e.hasMoreElements()) {
                    return true;
                }
                ++this.myIndex;
            }
            return false;
        }

        @Override
        public URL nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            return this.myEnumerations[this.myIndex].nextElement();
        }
    }

    private static abstract class ActionWithPluginClassLoader<Result, ParameterType> {
        private ActionWithPluginClassLoader() {
        }

        Result execute(String name2, PluginClassLoader classloader, Set<ClassLoader> visited2, ActionWithPluginClassLoader<Result, ParameterType> actionWithPluginClassLoader, ActionWithClassloader<Result, ParameterType> actionWithClassloader, ParameterType parameter) {
            Result resource = this.doExecute(name2, classloader, parameter);
            if (resource != null) {
                return resource;
            }
            return (Result)classloader.processResourcesInParents(name2, actionWithPluginClassLoader, actionWithClassloader, visited2, parameter);
        }

        protected abstract Result doExecute(String var1, PluginClassLoader var2, ParameterType var3);
    }

    private static interface ActionWithClassloader<Result, ParameterType> {
        public Result execute(String var1, ClassLoader var2, ParameterType var3);
    }
}

