/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ide.plugins;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginLoadProgressManager;
import org.jetbrains.kotlin.com.intellij.openapi.util.SafeJdomFactory;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.concurrency.AppExecutorUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.Interner;
import org.jetbrains.kotlin.org.jdom.Attribute;
import org.jetbrains.kotlin.org.jdom.AttributeType;
import org.jetbrains.kotlin.org.jdom.Element;
import org.jetbrains.kotlin.org.jdom.Namespace;
import org.jetbrains.kotlin.org.jdom.Text;

final class LoadDescriptorsContext
implements AutoCloseable {
    @NotNull
    private final ExecutorService myExecutorService;
    private final PluginLoadProgressManager myPluginLoadProgressManager;
    private final Collection<Interner<String>> myInterners;
    private final ThreadLocal<SafeJdomFactory> myThreadLocalXmlFactory;

    LoadDescriptorsContext(@Nullable PluginLoadProgressManager pluginLoadProgressManager, boolean isParallel) {
        int maxThreads;
        this.myPluginLoadProgressManager = pluginLoadProgressManager;
        int n = maxThreads = isParallel ? Runtime.getRuntime().availableProcessors() - 1 : 1;
        if (maxThreads > 1) {
            this.myExecutorService = AppExecutorUtil.createBoundedApplicationPoolExecutor("PluginManager Loader", maxThreads);
            this.myInterners = Collections.newSetFromMap(ContainerUtil.newConcurrentMap(maxThreads));
        } else {
            this.myExecutorService = new SameThreadExecutorService();
            this.myInterners = new SmartList<Interner<String>>();
        }
        this.myThreadLocalXmlFactory = ThreadLocal.withInitial(() -> {
            PluginXmlFactory factory2 = new PluginXmlFactory();
            this.myInterners.add(factory2.stringInterner);
            return factory2;
        });
    }

    @NotNull
    ExecutorService getExecutorService() {
        ExecutorService executorService = this.myExecutorService;
        if (executorService == null) {
            LoadDescriptorsContext.$$$reportNull$$$0(0);
        }
        return executorService;
    }

    @Nullable
    PluginLoadProgressManager getPluginLoadProgressManager() {
        return this.myPluginLoadProgressManager;
    }

    @Nullable
    public SafeJdomFactory getXmlFactory() {
        return this.myThreadLocalXmlFactory.get();
    }

    @Override
    public void close() {
        if (this.myExecutorService instanceof SameThreadExecutorService) {
            this.myThreadLocalXmlFactory.remove();
            return;
        }
        this.myExecutorService.submit(() -> {
            for (Interner<String> interner : this.myInterners) {
                interner.clear();
            }
        });
        this.myExecutorService.shutdown();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/ide/plugins/LoadDescriptorsContext", "getExecutorService"));
    }

    private static final class SameThreadExecutorService
    extends AbstractExecutorService {
        private volatile boolean isTerminated;

        private SameThreadExecutorService() {
        }

        @Override
        public void shutdown() {
            this.isTerminated = true;
        }

        @Override
        public boolean isShutdown() {
            return this.isTerminated;
        }

        @Override
        public boolean isTerminated() {
            return this.isTerminated;
        }

        @Override
        public boolean awaitTermination(long theTimeout, @NotNull TimeUnit timeUnit) {
            if (timeUnit == null) {
                SameThreadExecutorService.$$$reportNull$$$0(0);
            }
            this.shutdown();
            return true;
        }

        @Override
        @NotNull
        @Contract(pure=true)
        public List<Runnable> shutdownNow() {
            List<Runnable> list2 = Collections.emptyList();
            if (list2 == null) {
                SameThreadExecutorService.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @Override
        public void execute(@NotNull Runnable command) {
            if (command == null) {
                SameThreadExecutorService.$$$reportNull$$$0(2);
            }
            command.run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "theUnit";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/ide/plugins/LoadDescriptorsContext$SameThreadExecutorService";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/ide/plugins/LoadDescriptorsContext$SameThreadExecutorService";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "shutdownNow";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "awaitTermination";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class PluginXmlFactory
    extends SafeJdomFactory.BaseSafeJdomFactory {
        private static final Set<String> CLASS_NAMES = ContainerUtil.newIdentityTroveSet(Arrays.asList("implementation-class", "implementation", "serviceImplementation", "class", "className", "beanClass", "serviceInterface", "interface", "interfaceClass", "instance", "qualifiedName"));
        private final Interner<String> stringInterner = new Interner<String>(CLASS_NAMES){

            @Override
            @NotNull
            public String intern(@NotNull String name2) {
                if (name2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                String string = name2.length() < 64 ? super.intern(name2) : name2;
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/com/intellij/ide/plugins/LoadDescriptorsContext$PluginXmlFactory$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/ide/plugins/LoadDescriptorsContext$PluginXmlFactory$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "intern";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "intern";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };

        private PluginXmlFactory() {
        }

        @Override
        @NotNull
        public Element element(@NotNull String name2, @Nullable Namespace namespace) {
            if (name2 == null) {
                PluginXmlFactory.$$$reportNull$$$0(0);
            }
            Element element = super.element(this.stringInterner.intern(name2), namespace);
            if (element == null) {
                PluginXmlFactory.$$$reportNull$$$0(1);
            }
            return element;
        }

        @Override
        @NotNull
        public Attribute attribute(@NotNull String name2, @NotNull String value, @Nullable AttributeType type2, @Nullable Namespace namespace) {
            String internedName;
            if (name2 == null) {
                PluginXmlFactory.$$$reportNull$$$0(2);
            }
            if (value == null) {
                PluginXmlFactory.$$$reportNull$$$0(3);
            }
            if (CLASS_NAMES.contains(internedName = this.stringInterner.intern(name2))) {
                Attribute attribute = super.attribute(internedName, value, type2, namespace);
                if (attribute == null) {
                    PluginXmlFactory.$$$reportNull$$$0(4);
                }
                return attribute;
            }
            Attribute attribute = super.attribute(internedName, this.stringInterner.intern(value), type2, namespace);
            if (attribute == null) {
                PluginXmlFactory.$$$reportNull$$$0(5);
            }
            return attribute;
        }

        @Override
        @NotNull
        public Text text(@NotNull String text2, @NotNull Element parentElement) {
            if (text2 == null) {
                PluginXmlFactory.$$$reportNull$$$0(6);
            }
            if (parentElement == null) {
                PluginXmlFactory.$$$reportNull$$$0(7);
            }
            if (CLASS_NAMES.contains(parentElement.getName())) {
                Text text3 = super.text(text2, parentElement);
                if (text3 == null) {
                    PluginXmlFactory.$$$reportNull$$$0(8);
                }
                return text3;
            }
            Text text4 = super.text(this.stringInterner.intern(text2), parentElement);
            if (text4 == null) {
                PluginXmlFactory.$$$reportNull$$$0(9);
            }
            return text4;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/ide/plugins/LoadDescriptorsContext$PluginXmlFactory";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/ide/plugins/LoadDescriptorsContext$PluginXmlFactory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "element";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "attribute";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "element";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 8: 
                case 9: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "attribute";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "text";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

