/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.kotlin.repl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import kotlin.jvm.functions.Function0;
import kotlin.script.experimental.jvmhost.repl.JvmReplCompiler;
import kotlin.script.experimental.jvmhost.repl.JvmReplEvaluator;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.kotlin.reflect.ContextUpdater;
import org.apache.zeppelin.kotlin.reflect.KotlinFunctionInfo;
import org.apache.zeppelin.kotlin.reflect.KotlinReflectUtil;
import org.apache.zeppelin.kotlin.reflect.KotlinVariableInfo;
import org.apache.zeppelin.kotlin.repl.ClassWriter;
import org.apache.zeppelin.kotlin.repl.building.KotlinReplProperties;
import org.apache.zeppelin.kotlin.repl.building.ReplBuilding;
import org.jetbrains.kotlin.cli.common.repl.AggregatedReplStageState;
import org.jetbrains.kotlin.cli.common.repl.InvokeWrapper;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.cli.common.repl.ReplCompileResult;
import org.jetbrains.kotlin.cli.common.repl.ReplEvalResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KotlinRepl {
    private static Logger logger = LoggerFactory.getLogger(KotlinRepl.class);
    private JvmReplCompiler compiler;
    private JvmReplEvaluator evaluator;
    private AggregatedReplStageState<?, ?> state;
    private AtomicInteger counter;
    private ClassWriter writer;
    private KotlinContext ctx;
    private InvokeWrapper wrapper;
    private int maxResult;
    private ContextUpdater contextUpdater;
    boolean shortenTypes;

    private KotlinRepl() {
    }

    public KotlinRepl(KotlinReplProperties properties2) {
        this.compiler = ReplBuilding.buildCompiler(properties2);
        this.evaluator = ReplBuilding.buildEvaluator(properties2);
        ReentrantReadWriteLock stateLock = new ReentrantReadWriteLock();
        this.state = new AggregatedReplStageState(this.compiler.createState(stateLock), this.evaluator.createState(stateLock), stateLock);
        this.counter = new AtomicInteger(0);
        this.writer = new ClassWriter(properties2.getOutputDir());
        this.maxResult = properties2.getMaxResult();
        this.shortenTypes = properties2.getShortenTypes();
        properties2.getReceiver().kc = this.ctx = new KotlinContext();
        this.contextUpdater = new ContextUpdater(this.state, this.ctx.vars, this.ctx.functions);
        for (String line : properties2.getCodeOnLoad()) {
            this.eval(line);
        }
    }

    public List<KotlinVariableInfo> getVariables() {
        return this.ctx.getVars();
    }

    public List<KotlinFunctionInfo> getFunctions() {
        return this.ctx.getFunctions();
    }

    public KotlinContext getKotlinContext() {
        return this.ctx;
    }

    public InterpreterResult eval(String code) {
        ReplCompileResult compileResult = this.compiler.compile(this.state, new ReplCodeLine(this.counter.getAndIncrement(), 0, code));
        Optional<InterpreterResult> compileError = this.checkCompileError(compileResult);
        if (compileError.isPresent()) {
            return compileError.get();
        }
        ReplCompileResult.CompiledClasses classes2 = (ReplCompileResult.CompiledClasses)compileResult;
        this.writer.writeClasses(classes2);
        ReplEvalResult evalResult = this.evalInWrapper(classes2);
        Optional<InterpreterResult> evalError = this.checkEvalError(evalResult);
        if (evalError.isPresent()) {
            return evalError.get();
        }
        this.contextUpdater.update();
        if (evalResult instanceof ReplEvalResult.UnitResult) {
            return new InterpreterResult(InterpreterResult.Code.SUCCESS);
        }
        if (evalResult instanceof ReplEvalResult.ValueResult) {
            ReplEvalResult.ValueResult v = (ReplEvalResult.ValueResult)evalResult;
            String typeString = this.shortenTypes ? KotlinReflectUtil.shorten(v.getType()) : v.getType();
            String valueString = this.prepareValueString(v.getValue());
            return new InterpreterResult(InterpreterResult.Code.SUCCESS, v.getName() + ": " + typeString + " = " + valueString);
        }
        return new InterpreterResult(InterpreterResult.Code.ERROR, "unknown evaluation result: " + evalResult.toString());
    }

    private ReplEvalResult evalInWrapper(ReplCompileResult.CompiledClasses classes2) {
        Function0<ReplEvalResult> runEvaluator = () -> this.evaluator.eval(this.state, classes2, null, null);
        ReplEvalResult evalResult = this.wrapper != null ? this.wrapper.invoke(runEvaluator) : runEvaluator.invoke();
        return evalResult;
    }

    private Optional<InterpreterResult> checkCompileError(ReplCompileResult compileResult) {
        if (compileResult instanceof ReplCompileResult.Incomplete) {
            return Optional.of(new InterpreterResult(InterpreterResult.Code.INCOMPLETE));
        }
        if (compileResult instanceof ReplCompileResult.Error) {
            ReplCompileResult.Error e = (ReplCompileResult.Error)compileResult;
            return Optional.of(new InterpreterResult(InterpreterResult.Code.ERROR, e.getMessage()));
        }
        if (!(compileResult instanceof ReplCompileResult.CompiledClasses)) {
            return Optional.of(new InterpreterResult(InterpreterResult.Code.ERROR, "unknown compilation result:" + compileResult.toString()));
        }
        return Optional.empty();
    }

    private Optional<InterpreterResult> checkEvalError(ReplEvalResult evalResult) {
        if (evalResult instanceof ReplEvalResult.Error) {
            ReplEvalResult.Error e = (ReplEvalResult.Error)evalResult;
            return Optional.of(new InterpreterResult(InterpreterResult.Code.ERROR, e.getMessage()));
        }
        if (evalResult instanceof ReplEvalResult.Incomplete) {
            return Optional.of(new InterpreterResult(InterpreterResult.Code.INCOMPLETE));
        }
        if (evalResult instanceof ReplEvalResult.HistoryMismatch) {
            ReplEvalResult.HistoryMismatch e = (ReplEvalResult.HistoryMismatch)evalResult;
            return Optional.of(new InterpreterResult(InterpreterResult.Code.ERROR, "history mismatch at " + e.getLineNo()));
        }
        return Optional.empty();
    }

    private String prepareValueString(Object value) {
        if (value == null) {
            return "null";
        }
        if (!(value instanceof Collection)) {
            return value.toString();
        }
        Collection collection = (Collection)value;
        if (collection.size() <= this.maxResult) {
            return value.toString();
        }
        return "[" + collection.stream().limit(this.maxResult).map(Object::toString).collect(Collectors.joining(",")) + " ... " + (collection.size() - this.maxResult) + " more]";
    }

    public class KotlinContext {
        private Map<String, KotlinVariableInfo> vars = new HashMap<String, KotlinVariableInfo>();
        private Set<KotlinFunctionInfo> functions = new TreeSet<KotlinFunctionInfo>();

        public List<KotlinVariableInfo> getVars() {
            return new ArrayList<KotlinVariableInfo>(this.vars.values());
        }

        public void setWrapper(InvokeWrapper wrapper) {
            KotlinRepl.this.wrapper = wrapper;
        }

        public InvokeWrapper getWrapper() {
            return KotlinRepl.this.wrapper;
        }

        public List<KotlinFunctionInfo> getFunctions() {
            return new ArrayList<KotlinFunctionInfo>(this.functions);
        }

        public void showVars() {
            for (KotlinVariableInfo var : this.vars.values()) {
                System.out.println(var.toString(KotlinRepl.this.shortenTypes));
            }
        }

        public void showFunctions() {
            for (KotlinFunctionInfo fun : this.functions) {
                System.out.println(fun.toString(KotlinRepl.this.shortenTypes));
            }
        }
    }
}

