/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.kotlin.repl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import kotlin.script.experimental.jvm.impl.KJvmCompiledScript;
import org.jetbrains.kotlin.cli.common.repl.CompiledClassData;
import org.jetbrains.kotlin.cli.common.repl.ReplCompileResult;
import org.jetbrains.kotlin.scripting.compiler.plugin.impl.KJvmCompiledModuleInMemory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassWriter {
    private static Logger logger = LoggerFactory.getLogger(ClassWriter.class);
    private String outputDir;

    public ClassWriter(String outputDir2) {
        this.outputDir = outputDir2;
    }

    public void writeClasses(ReplCompileResult.CompiledClasses classes2) {
        if (this.outputDir == null) {
            return;
        }
        for (CompiledClassData compiledClass : classes2.getClasses()) {
            String filePath = compiledClass.getPath();
            if (filePath.contains(File.separator)) continue;
            String classWritePath = this.outputDir + File.separator + filePath;
            this.writeClass(compiledClass.getBytes(), classWritePath);
        }
        this.writeModuleInMemory(classes2);
    }

    private void writeModuleInMemory(ReplCompileResult.CompiledClasses classes2) {
        try {
            KJvmCompiledScript compiledScript2 = Objects.requireNonNull((KJvmCompiledScript)classes2.getData());
            KJvmCompiledModuleInMemory moduleInMemory = Objects.requireNonNull((KJvmCompiledModuleInMemory)compiledScript2.getCompiledModule());
            moduleInMemory.getCompilerOutputFiles().forEach((name2, bytes2) -> {
                if (name2.contains("class")) {
                    this.writeClass((byte[])bytes2, this.outputDir + File.separator + name2);
                }
            });
        }
        catch (ClassCastException | NullPointerException e) {
            logger.info("Compiled line #" + classes2.getLineId().getNo() + "has no in-memory modules");
        }
    }

    private void writeClass(byte[] classBytes, String path2) {
        try (FileOutputStream fos = new FileOutputStream(path2);
             BufferedOutputStream out = new BufferedOutputStream(fos);){
            ((OutputStream)out).write(classBytes);
            ((OutputStream)out).flush();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
    }
}

