/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.config;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.LogLog;

public class PropertyGetter {
    protected static final Object[] NULL_ARG = new Object[0];
    protected Object obj;
    protected PropertyDescriptor[] props;

    public PropertyGetter(Object obj) throws IntrospectionException {
        BeanInfo bi = Introspector.getBeanInfo(obj.getClass());
        this.props = bi.getPropertyDescriptors();
        this.obj = obj;
    }

    public static void getProperties(Object obj, PropertyCallback callback, String prefix) {
        try {
            new PropertyGetter(obj).getProperties(callback, prefix);
        }
        catch (IntrospectionException ex) {
            LogLog.error("Failed to introspect object " + obj, ex);
        }
    }

    public void getProperties(PropertyCallback callback, String prefix) {
        for (int i = 0; i < this.props.length; ++i) {
            Method getter2 = this.props[i].getReadMethod();
            if (getter2 == null || !this.isHandledType(getter2.getReturnType())) continue;
            String name2 = this.props[i].getName();
            try {
                Object result2 = getter2.invoke(this.obj, NULL_ARG);
                if (result2 == null) continue;
                callback.foundProperty(this.obj, prefix, name2, result2);
                continue;
            }
            catch (IllegalAccessException ex) {
                LogLog.warn("Failed to get value of property " + name2);
                continue;
            }
            catch (InvocationTargetException ex) {
                if (ex.getTargetException() instanceof InterruptedException || ex.getTargetException() instanceof InterruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                LogLog.warn("Failed to get value of property " + name2);
                continue;
            }
            catch (RuntimeException ex) {
                LogLog.warn("Failed to get value of property " + name2);
            }
        }
    }

    protected boolean isHandledType(Class type2) {
        return String.class.isAssignableFrom(type2) || Integer.TYPE.isAssignableFrom(type2) || Long.TYPE.isAssignableFrom(type2) || Boolean.TYPE.isAssignableFrom(type2) || Priority.class.isAssignableFrom(type2);
    }

    public static interface PropertyCallback {
        public void foundProperty(Object var1, String var2, String var3, Object var4);
    }
}

