/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class LogOutputStream
extends OutputStream {
    private static final int INTIAL_SIZE = 132;
    private static final int CR = 13;
    private static final int LF = 10;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream(132);
    private boolean skip = false;
    private final int level;

    public LogOutputStream() {
        this(999);
    }

    public LogOutputStream(int level) {
        this.level = level;
    }

    public void write(int cc) throws IOException {
        byte c = (byte)cc;
        if (c == 10 || c == 13) {
            if (!this.skip) {
                this.processBuffer();
            }
        } else {
            this.buffer.write(cc);
        }
        this.skip = c == 13;
    }

    public void flush() {
        if (this.buffer.size() > 0) {
            this.processBuffer();
        }
    }

    public void close() throws IOException {
        if (this.buffer.size() > 0) {
            this.processBuffer();
        }
        super.close();
    }

    public int getMessageLevel() {
        return this.level;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int offset2;
        int blockStartOffset = offset2 = off;
        int remaining = len;
        while (remaining > 0) {
            while (remaining > 0 && b[offset2] != 10 && b[offset2] != 13) {
                ++offset2;
                --remaining;
            }
            int blockLength = offset2 - blockStartOffset;
            if (blockLength > 0) {
                this.buffer.write(b, blockStartOffset, blockLength);
            }
            while (remaining > 0 && (b[offset2] == 10 || b[offset2] == 13)) {
                this.write(b[offset2]);
                ++offset2;
                --remaining;
            }
            blockStartOffset = offset2;
        }
    }

    protected void processBuffer() {
        this.processLine(this.buffer.toString());
        this.buffer.reset();
    }

    protected void processLine(String line) {
        this.processLine(line, this.level);
    }

    protected abstract void processLine(String var1, int var2);
}

