/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.metadata.deserialization;

import java.util.LinkedList;
import java.util.List;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolverImpl$WhenMappings;
import org.jetbrains.annotations.NotNull;

public final class NameResolverImpl
implements NameResolver {
    private final ProtoBuf.StringTable strings;
    private final ProtoBuf.QualifiedNameTable qualifiedNames;

    @Override
    @NotNull
    public String getString(int index2) {
        String string = this.strings.getString(index2);
        Intrinsics.checkExpressionValueIsNotNull(string, "strings.getString(index)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getQualifiedClassName(int index2) {
        void packageFqNameSegments;
        Triple<List<String>, List<String>, Boolean> triple = this.traverseIds(index2);
        List<String> list2 = triple.component1();
        List<String> relativeClassNameSegments = triple.component2();
        String className2 = CollectionsKt.joinToString$default(relativeClassNameSegments, ".", null, null, 0, null, null, 62, null);
        return packageFqNameSegments.isEmpty() ? className2 : CollectionsKt.joinToString$default((Iterable)packageFqNameSegments, "/", null, null, 0, null, null, 62, null) + '/' + className2;
    }

    @Override
    public boolean isLocalClassName(int index2) {
        return this.traverseIds(index2).getThird();
    }

    private final Triple<List<String>, List<String>, Boolean> traverseIds(int startingIndex) {
        int index2 = startingIndex;
        LinkedList<String> packageNameSegments = new LinkedList<String>();
        LinkedList<String> relativeClassNameSegments = new LinkedList<String>();
        boolean local2 = false;
        while (index2 != -1) {
            ProtoBuf.QualifiedNameTable.QualifiedName proto;
            ProtoBuf.QualifiedNameTable.QualifiedName qualifiedName2 = proto = this.qualifiedNames.getQualifiedName(index2);
            Intrinsics.checkExpressionValueIsNotNull(qualifiedName2, "proto");
            String shortName = this.strings.getString(qualifiedName2.getShortName());
            ProtoBuf.QualifiedNameTable.QualifiedName.Kind kind = proto.getKind();
            if (kind == null) {
                Intrinsics.throwNpe();
            }
            switch (NameResolverImpl$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: {
                    relativeClassNameSegments.addFirst(shortName);
                    break;
                }
                case 2: {
                    packageNameSegments.addFirst(shortName);
                    break;
                }
                case 3: {
                    relativeClassNameSegments.addFirst(shortName);
                    local2 = true;
                }
            }
            index2 = proto.getParentQualifiedName();
        }
        return new Triple<List<String>, List<String>, Boolean>(packageNameSegments, relativeClassNameSegments, local2);
    }

    public NameResolverImpl(@NotNull ProtoBuf.StringTable strings2, @NotNull ProtoBuf.QualifiedNameTable qualifiedNames) {
        Intrinsics.checkParameterIsNotNull(strings2, "strings");
        Intrinsics.checkParameterIsNotNull(qualifiedNames, "qualifiedNames");
        this.strings = strings2;
        this.qualifiedNames = qualifiedNames;
    }
}

