/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.dep;

import java.nio.file.Paths;
import org.apache.commons.lang3.Validate;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.dep.RepositoryListener;
import org.apache.zeppelin.dep.RepositorySystemFactory;
import org.apache.zeppelin.dep.TransferListener;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Booter {
    private static final Logger LOGGER = LoggerFactory.getLogger(Booter.class);

    private Booter() {
    }

    public static RepositorySystem newRepositorySystem() {
        return RepositorySystemFactory.newRepositorySystem();
    }

    public static RepositorySystemSession newRepositorySystemSession(RepositorySystem system, String localRepoPath) {
        Validate.notNull((Object)localRepoPath, (String)"localRepoPath should have a value", (Object[])new Object[0]);
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(Booter.resolveLocalRepoPath(localRepoPath));
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        if (LOGGER.isDebugEnabled()) {
            session.setTransferListener((org.eclipse.aether.transfer.TransferListener)new TransferListener());
            session.setRepositoryListener((org.eclipse.aether.RepositoryListener)new RepositoryListener());
        }
        return session;
    }

    static String resolveLocalRepoPath(String localRepoPath) {
        String home = System.getenv("ZEPPELIN_HOME");
        if (home == null) {
            home = System.getProperty("zeppelin.home");
        }
        if (home == null) {
            home = "..";
        }
        return Paths.get(home, new String[0]).resolve(localRepoPath).toAbsolutePath().toString();
    }

    public static RemoteRepository newCentralRepository(Proxy proxy) {
        String mvnRepo = System.getenv("ZEPPELIN_INTERPRETER_DEP_MVNREPO");
        if (mvnRepo == null) {
            mvnRepo = ZeppelinConfiguration.create().getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_DEP_MVNREPO);
        }
        if (mvnRepo == null) {
            mvnRepo = "https://repo1.maven.org/maven2/";
        }
        RemoteRepository.Builder centralBuilder = new RemoteRepository.Builder("central", "default", mvnRepo);
        if (proxy != null) {
            centralBuilder.setProxy(proxy);
        }
        return centralBuilder.build();
    }

    public static RemoteRepository newLocalRepository() {
        return new RemoteRepository.Builder("local", "default", "file://" + System.getProperty("user.home") + "/.m2/repository").build();
    }
}

