/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.cluster;

import com.google.common.collect.Maps;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.Node;
import io.atomix.cluster.messaging.MessagingService;
import io.atomix.cluster.messaging.impl.NettyMessagingService;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.operation.OperationId;
import io.atomix.primitive.operation.OperationType;
import io.atomix.primitive.operation.PrimitiveOperation;
import io.atomix.primitive.operation.impl.DefaultOperationId;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.primitive.session.SessionClient;
import io.atomix.primitive.session.SessionId;
import io.atomix.protocols.raft.RaftClient;
import io.atomix.protocols.raft.RaftError;
import io.atomix.protocols.raft.ReadConsistency;
import io.atomix.protocols.raft.cluster.RaftMember;
import io.atomix.protocols.raft.cluster.impl.DefaultRaftMember;
import io.atomix.protocols.raft.protocol.AppendRequest;
import io.atomix.protocols.raft.protocol.AppendResponse;
import io.atomix.protocols.raft.protocol.CloseSessionRequest;
import io.atomix.protocols.raft.protocol.CloseSessionResponse;
import io.atomix.protocols.raft.protocol.CommandRequest;
import io.atomix.protocols.raft.protocol.CommandResponse;
import io.atomix.protocols.raft.protocol.ConfigureRequest;
import io.atomix.protocols.raft.protocol.ConfigureResponse;
import io.atomix.protocols.raft.protocol.InstallRequest;
import io.atomix.protocols.raft.protocol.InstallResponse;
import io.atomix.protocols.raft.protocol.JoinRequest;
import io.atomix.protocols.raft.protocol.JoinResponse;
import io.atomix.protocols.raft.protocol.KeepAliveRequest;
import io.atomix.protocols.raft.protocol.KeepAliveResponse;
import io.atomix.protocols.raft.protocol.LeaveRequest;
import io.atomix.protocols.raft.protocol.LeaveResponse;
import io.atomix.protocols.raft.protocol.MetadataRequest;
import io.atomix.protocols.raft.protocol.MetadataResponse;
import io.atomix.protocols.raft.protocol.OpenSessionRequest;
import io.atomix.protocols.raft.protocol.OpenSessionResponse;
import io.atomix.protocols.raft.protocol.PollRequest;
import io.atomix.protocols.raft.protocol.PollResponse;
import io.atomix.protocols.raft.protocol.PublishRequest;
import io.atomix.protocols.raft.protocol.QueryRequest;
import io.atomix.protocols.raft.protocol.QueryResponse;
import io.atomix.protocols.raft.protocol.RaftClientProtocol;
import io.atomix.protocols.raft.protocol.RaftResponse;
import io.atomix.protocols.raft.protocol.ReconfigureRequest;
import io.atomix.protocols.raft.protocol.ReconfigureResponse;
import io.atomix.protocols.raft.protocol.ResetRequest;
import io.atomix.protocols.raft.protocol.VoteRequest;
import io.atomix.protocols.raft.protocol.VoteResponse;
import io.atomix.protocols.raft.session.CommunicationStrategy;
import io.atomix.protocols.raft.storage.log.entry.CloseSessionEntry;
import io.atomix.protocols.raft.storage.log.entry.CommandEntry;
import io.atomix.protocols.raft.storage.log.entry.ConfigurationEntry;
import io.atomix.protocols.raft.storage.log.entry.InitializeEntry;
import io.atomix.protocols.raft.storage.log.entry.KeepAliveEntry;
import io.atomix.protocols.raft.storage.log.entry.MetadataEntry;
import io.atomix.protocols.raft.storage.log.entry.OpenSessionEntry;
import io.atomix.protocols.raft.storage.log.entry.QueryEntry;
import io.atomix.protocols.raft.storage.system.Configuration;
import io.atomix.utils.net.Address;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.cluster.ClusterCallback;
import org.apache.zeppelin.cluster.ClusterMonitor;
import org.apache.zeppelin.cluster.ClusterPrimitiveType;
import org.apache.zeppelin.cluster.ClusterStateMachine;
import org.apache.zeppelin.cluster.meta.ClusterMeta;
import org.apache.zeppelin.cluster.meta.ClusterMetaEntity;
import org.apache.zeppelin.cluster.meta.ClusterMetaOperation;
import org.apache.zeppelin.cluster.meta.ClusterMetaType;
import org.apache.zeppelin.cluster.protocol.LocalRaftProtocolFactory;
import org.apache.zeppelin.cluster.protocol.RaftClientMessagingProtocol;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.launcher.InterpreterClient;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClusterManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterManager.class);
    public ZeppelinConfiguration zConf;
    protected Collection<Node> clusterNodes;
    protected int raftServerPort;
    protected RaftClient raftClient;
    protected SessionClient raftSessionClient;
    protected Map<MemberId, Address> raftAddressMap;
    protected LocalRaftProtocolFactory protocolFactory;
    protected List<MemberId> clusterMemberIds;
    protected AtomicBoolean running;
    private ConcurrentLinkedQueue<ClusterMetaEntity> clusterMetaQueue;
    protected String zeplServerHost;
    protected ClusterMonitor clusterMonitor;
    protected boolean isTest;
    protected static final Serializer protocolSerializer = Serializer.using((Namespace)Namespace.builder().register(new Class[]{OpenSessionRequest.class}).register(new Class[]{OpenSessionResponse.class}).register(new Class[]{CloseSessionRequest.class}).register(new Class[]{CloseSessionResponse.class}).register(new Class[]{KeepAliveRequest.class}).register(new Class[]{KeepAliveResponse.class}).register(new Class[]{QueryRequest.class}).register(new Class[]{QueryResponse.class}).register(new Class[]{CommandRequest.class}).register(new Class[]{CommandResponse.class}).register(new Class[]{MetadataRequest.class}).register(new Class[]{MetadataResponse.class}).register(new Class[]{JoinRequest.class}).register(new Class[]{JoinResponse.class}).register(new Class[]{LeaveRequest.class}).register(new Class[]{LeaveResponse.class}).register(new Class[]{ConfigureRequest.class}).register(new Class[]{ConfigureResponse.class}).register(new Class[]{ReconfigureRequest.class}).register(new Class[]{ReconfigureResponse.class}).register(new Class[]{InstallRequest.class}).register(new Class[]{InstallResponse.class}).register(new Class[]{PollRequest.class}).register(new Class[]{PollResponse.class}).register(new Class[]{VoteRequest.class}).register(new Class[]{VoteResponse.class}).register(new Class[]{AppendRequest.class}).register(new Class[]{AppendResponse.class}).register(new Class[]{PublishRequest.class}).register(new Class[]{ResetRequest.class}).register(new Class[]{RaftResponse.Status.class}).register(new Class[]{RaftError.class}).register(new Class[]{RaftError.Type.class}).register(new Class[]{PrimitiveOperation.class}).register(new Class[]{ReadConsistency.class}).register(new Class[]{byte[].class}).register(new Class[]{long[].class}).register(new Class[]{CloseSessionEntry.class}).register(new Class[]{CommandEntry.class}).register(new Class[]{ConfigurationEntry.class}).register(new Class[]{InitializeEntry.class}).register(new Class[]{KeepAliveEntry.class}).register(new Class[]{MetadataEntry.class}).register(new Class[]{OpenSessionEntry.class}).register(new Class[]{QueryEntry.class}).register(new Class[]{PrimitiveOperation.class}).register(new Class[]{DefaultOperationId.class}).register(new Class[]{OperationType.class}).register(new Class[]{ReadConsistency.class}).register(new Class[]{ArrayList.class}).register(new Class[]{HashMap.class}).register(new Class[]{ClusterMetaEntity.class}).register(new Class[]{LocalDateTime.class}).register(new Class[]{Collections.emptyList().getClass()}).register(new Class[]{HashSet.class}).register(new Class[]{DefaultRaftMember.class}).register(new Class[]{MemberId.class}).register(new Class[]{SessionId.class}).register(new Class[]{RaftMember.Type.class}).register(new Class[]{Instant.class}).register(new Class[]{Configuration.class}).build());
    protected static final Serializer storageSerializer = Serializer.using((Namespace)Namespace.builder().register(new Class[]{CloseSessionEntry.class}).register(new Class[]{CommandEntry.class}).register(new Class[]{ConfigurationEntry.class}).register(new Class[]{InitializeEntry.class}).register(new Class[]{KeepAliveEntry.class}).register(new Class[]{MetadataEntry.class}).register(new Class[]{OpenSessionEntry.class}).register(new Class[]{QueryEntry.class}).register(new Class[]{PrimitiveOperation.class}).register(new Class[]{DefaultOperationId.class}).register(new Class[]{OperationType.class}).register(new Class[]{ReadConsistency.class}).register(new Class[]{ArrayList.class}).register(new Class[]{ClusterMetaEntity.class}).register(new Class[]{HashMap.class}).register(new Class[]{HashSet.class}).register(new Class[]{LocalDateTime.class}).register(new Class[]{DefaultRaftMember.class}).register(new Class[]{MemberId.class}).register(new Class[]{RaftMember.Type.class}).register(new Class[]{Instant.class}).register(new Class[]{Configuration.class}).register(new Class[]{byte[].class}).register(new Class[]{long[].class}).build());
    protected static final Serializer clientSerializer = Serializer.using((Namespace)Namespace.builder().register(new Class[]{ReadConsistency.class}).register(new Class[]{ClusterMetaEntity.class}).register(new Class[]{ClusterMetaOperation.class}).register(new Class[]{ClusterMetaType.class}).register(new Class[]{HashMap.class}).register(new Class[]{LocalDateTime.class}).register(new Class[]{Maps.immutableEntry((Object)new String(), (Object)new Object()).getClass()}).build());

    public ClusterManager(ZeppelinConfiguration zConf) {
        block6: {
            this.clusterNodes = new ArrayList<Node>();
            this.raftServerPort = 0;
            this.raftClient = null;
            this.raftSessionClient = null;
            this.raftAddressMap = new ConcurrentHashMap<MemberId, Address>();
            this.protocolFactory = new LocalRaftProtocolFactory(protocolSerializer);
            this.clusterMemberIds = new ArrayList<MemberId>();
            this.running = new AtomicBoolean(true);
            this.clusterMetaQueue = new ConcurrentLinkedQueue();
            this.zeplServerHost = "";
            this.clusterMonitor = null;
            this.isTest = false;
            try {
                this.zConf = zConf;
                this.zeplServerHost = RemoteInterpreterUtils.findAvailableHostAddress();
                String clusterAddr = this.zConf.getClusterAddress();
                if (!StringUtils.isEmpty((CharSequence)clusterAddr)) {
                    String[] cluster = clusterAddr.split(",");
                    for (int i = 0; i < cluster.length; ++i) {
                        String[] parts = cluster[i].split(":");
                        String clusterHost = parts[0];
                        int clusterPort = Integer.valueOf(parts[1]);
                        if (this.zeplServerHost.equalsIgnoreCase(clusterHost)) {
                            this.raftServerPort = clusterPort;
                        }
                        String memberId = clusterHost + ":" + clusterPort;
                        Address address = Address.from((String)clusterHost, (int)clusterPort);
                        Node node = Node.builder().withId(memberId).withAddress(address).build();
                        this.clusterNodes.add(node);
                        this.raftAddressMap.put(MemberId.from((String)memberId), address);
                        this.clusterMemberIds.add(MemberId.from((String)memberId));
                    }
                    break block6;
                }
                throw new RuntimeException("No zeppelin.cluster.addr specified in zeppelin-site.xml");
            }
            catch (UnknownHostException e) {
                LOGGER.error(e.getMessage());
            }
            catch (SocketException e) {
                LOGGER.error(e.getMessage());
            }
        }
    }

    public abstract boolean raftInitialized();

    public abstract boolean isClusterLeader();

    public AtomicBoolean getRunning() {
        return this.running;
    }

    private SessionClient createProxy(RaftClient client) {
        return (SessionClient)((SessionClient)client.sessionBuilder("CLUSTER_PRIMITIVE", (PrimitiveType)ClusterPrimitiveType.INSTANCE, new ServiceConfig()).withReadConsistency(ReadConsistency.SEQUENTIAL).withCommunicationStrategy(CommunicationStrategy.LEADER).build()).connect().join();
    }

    public void start() {
        if (!this.zConf.isClusterMode()) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                LOGGER.info("RaftClientThread run() >>>");
                int raftClientPort = 0;
                try {
                    raftClientPort = RemoteInterpreterUtils.findRandomAvailablePortOnAllLocalInterfaces();
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage());
                }
                MemberId memberId = MemberId.from((String)(ClusterManager.this.zeplServerHost + ":" + raftClientPort));
                Address address = Address.from((String)ClusterManager.this.zeplServerHost, (int)raftClientPort);
                ClusterManager.this.raftAddressMap.put(memberId, address);
                MessagingService messagingManager = (MessagingService)NettyMessagingService.builder().withAddress(address).build().start().join();
                RaftClientMessagingProtocol protocol = new RaftClientMessagingProtocol(messagingManager, protocolSerializer, ClusterManager.this.raftAddressMap::get);
                ClusterManager.this.raftClient = (RaftClient)RaftClient.builder().withMemberId(memberId).withPartitionId(PartitionId.from((String)"partition", (int)1)).withProtocol((RaftClientProtocol)protocol).build();
                ClusterManager.this.raftClient.connect(ClusterManager.this.clusterMemberIds).join();
                ClusterManager.this.raftSessionClient = ClusterManager.this.createProxy(ClusterManager.this.raftClient);
                LOGGER.info("RaftClientThread run() <<<");
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (ClusterManager.this.getRunning().get()) {
                        ClusterMetaEntity metaEntity = (ClusterMetaEntity)ClusterManager.this.clusterMetaQueue.peek();
                        if (null != metaEntity) {
                            int retry = 0;
                            while (!ClusterManager.this.raftInitialized()) {
                                if (0 == ++retry % 30) {
                                    LOGGER.warn("Raft incomplete initialization! retry[{}]", (Object)retry);
                                }
                                Thread.sleep(100L);
                            }
                            boolean success = false;
                            switch (metaEntity.getOperation()) {
                                case DELETE_OPERATION: {
                                    success = ClusterManager.this.deleteClusterMeta(metaEntity);
                                    break;
                                }
                                case PUT_OPERATION: {
                                    success = ClusterManager.this.putClusterMeta(metaEntity);
                                }
                            }
                            if (success) {
                                ClusterManager.this.clusterMetaQueue.remove(metaEntity);
                                LOGGER.info("Cluster Meta Consume success! {}", (Object)metaEntity);
                                continue;
                            }
                            LOGGER.error("Cluster Meta Consume faild!");
                            continue;
                        }
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException e) {
                    LOGGER.error(e.getMessage());
                }
            }
        }).start();
    }

    public void shutdown() {
        if (!this.zConf.isClusterMode()) {
            return;
        }
        this.running.set(false);
        try {
            if (null != this.raftSessionClient) {
                this.raftSessionClient.close().get(3L, TimeUnit.SECONDS);
            }
            if (null != this.raftClient) {
                this.raftClient.close().get(3L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage());
        }
        catch (ExecutionException e) {
            LOGGER.error(e.getMessage());
        }
        catch (TimeoutException e) {
            LOGGER.error(e.getMessage());
        }
    }

    public String getClusterNodeName() {
        if (this.isTest) {
            return this.zeplServerHost + ":" + this.raftServerPort;
        }
        String hostName = "";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostName = addr.getHostName().toString();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return hostName;
    }

    private boolean putClusterMeta(ClusterMetaEntity entity) {
        if (!this.raftInitialized()) {
            LOGGER.error("Raft incomplete initialization!");
            return false;
        }
        ClusterMetaType metaType = entity.getMetaType();
        String metaKey = entity.getKey();
        HashMap<String, Object> newMetaValue = entity.getValues();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("putClusterMeta {} {}", (Object)metaType, (Object)metaKey);
        }
        newMetaValue.put(ClusterMeta.SERVER_HOST, this.zeplServerHost);
        newMetaValue.put(ClusterMeta.SERVER_PORT, this.raftServerPort);
        this.raftSessionClient.execute(PrimitiveOperation.operation((OperationId)ClusterStateMachine.PUT, (byte[])clientSerializer.encode((Object)entity))).thenApply(arg_0 -> ((Serializer)clientSerializer).decode(arg_0));
        return true;
    }

    public void putClusterMeta(ClusterMetaType type, String key, HashMap<String, Object> values) {
        ClusterMetaEntity metaEntity = new ClusterMetaEntity(ClusterMetaOperation.PUT_OPERATION, type, key, values);
        boolean result = this.putClusterMeta(metaEntity);
        if (!result) {
            LOGGER.warn("putClusterMeta failure, Cache metadata to queue.");
            this.clusterMetaQueue.add(metaEntity);
        }
    }

    private boolean deleteClusterMeta(ClusterMetaEntity entity) {
        ClusterMetaType metaType = entity.getMetaType();
        String metaKey = entity.getKey();
        LOGGER.info("deleteClusterMeta {} {}", (Object)metaType, (Object)metaKey);
        if (!this.raftInitialized()) {
            LOGGER.error("Raft incomplete initialization!");
            return false;
        }
        ((CompletableFuture)this.raftSessionClient.execute(PrimitiveOperation.operation((OperationId)ClusterStateMachine.REMOVE, (byte[])clientSerializer.encode((Object)entity))).thenApply(arg_0 -> ((Serializer)clientSerializer).decode(arg_0))).thenAccept(result -> LOGGER.info("deleteClusterMeta {}", result));
        return true;
    }

    public void deleteClusterMeta(ClusterMetaType type, String key) {
        ClusterMetaEntity metaEntity = new ClusterMetaEntity(ClusterMetaOperation.DELETE_OPERATION, type, key, null);
        boolean result = this.deleteClusterMeta(metaEntity);
        if (!result) {
            LOGGER.warn("deleteClusterMeta faild, Cache data to queue.");
            this.clusterMetaQueue.add(metaEntity);
        }
    }

    public HashMap<String, HashMap<String, Object>> getClusterMeta(ClusterMetaType metaType, String metaKey) {
        HashMap clusterMeta = new HashMap();
        if (!this.raftInitialized()) {
            LOGGER.error("Raft incomplete initialization!");
            return clusterMeta;
        }
        ClusterMetaEntity entity = new ClusterMetaEntity(ClusterMetaOperation.GET_OPERATION, metaType, metaKey, null);
        byte[] mateData = null;
        try {
            mateData = (byte[])this.raftSessionClient.execute(PrimitiveOperation.operation((OperationId)ClusterStateMachine.GET, (byte[])clientSerializer.encode((Object)entity))).get(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage());
        }
        catch (ExecutionException e) {
            LOGGER.error(e.getMessage());
        }
        catch (TimeoutException e) {
            LOGGER.error(e.getMessage());
        }
        if (null != mateData) {
            clusterMeta = (HashMap)clientSerializer.decode(mateData);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getClusterMeta >>> {}", (Object)clusterMeta.toString());
        }
        return clusterMeta;
    }

    public InterpreterClient getIntpProcessStatus(String intpName, int timeout, ClusterCallback<HashMap<String, Object>> callback) {
        int CHECK_META_INTERVAL = 1000;
        int MAX_RETRY_GET_META = timeout / 1000;
        int retryGetMeta = 0;
        while (retryGetMeta++ < MAX_RETRY_GET_META) {
            HashMap<String, Object> intpMeta = this.getClusterMeta(ClusterMetaType.INTP_PROCESS_META, intpName).get(intpName);
            if (this.interpreterMetaOnline(intpMeta)) {
                String intpTSrvHost = (String)intpMeta.get(ClusterMeta.INTP_TSERVER_HOST);
                int intpTSrvPort = (Integer)intpMeta.get(ClusterMeta.INTP_TSERVER_PORT);
                LOGGER.info("interpreter thrift {}:{} service is online!", (Object)intpTSrvHost, (Object)intpTSrvPort);
                boolean remoteIntpAccessible = RemoteInterpreterUtils.checkIfRemoteEndpointAccessible(intpTSrvHost, intpTSrvPort);
                if (remoteIntpAccessible) {
                    LOGGER.info("interpreter thrift {}:{} accessible!", (Object)intpTSrvHost, (Object)intpTSrvPort);
                    return callback.online(intpMeta);
                }
                LOGGER.error("interpreter thrift {}:{} service is not available!", (Object)intpTSrvHost, (Object)intpTSrvPort);
                try {
                    Thread.sleep(1000L);
                    LOGGER.warn("retry {} times to get {} meta!", (Object)retryGetMeta, (Object)intpName);
                }
                catch (InterruptedException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        LOGGER.error("retry {} times not get {} meta!", (Object)retryGetMeta, (Object)intpName);
        callback.offline();
        return null;
    }

    private boolean interpreterMetaOnline(HashMap<String, Object> intpProcMeta) {
        return null != intpProcMeta && intpProcMeta.containsKey(ClusterMeta.INTP_TSERVER_HOST) && intpProcMeta.containsKey(ClusterMeta.INTP_TSERVER_PORT) && intpProcMeta.containsKey(ClusterMeta.STATUS) && StringUtils.equals((CharSequence)((String)intpProcMeta.get(ClusterMeta.STATUS)), (CharSequence)ClusterMeta.ONLINE_STATUS);
    }
}

