/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.CopyObjectRequest;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.PutObjectRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteInfo;
import org.apache.zeppelin.notebook.repo.NotebookRepo;
import org.apache.zeppelin.notebook.repo.NotebookRepoSettingsInfo;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSSNotebookRepo
implements NotebookRepo {
    private static final Logger LOGGER = LoggerFactory.getLogger(OSSNotebookRepo.class);
    private OSS ossClient;
    private String bucketName;
    private String rootFolder;

    public void init(ZeppelinConfiguration conf) throws IOException {
        String endpoint = conf.getOSSEndpoint();
        this.bucketName = conf.getOSSBucketName();
        this.rootFolder = conf.getNotebookDir();
        if (this.rootFolder.startsWith("/")) {
            this.rootFolder = this.rootFolder.substring(1);
        }
        String accessKeyId = conf.getOSSAccessKeyId();
        String accessKeySecret = conf.getOSSAccessKeySecret();
        this.ossClient = new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);
    }

    public Map<String, NoteInfo> list(AuthenticationInfo subject) throws IOException {
        HashMap<String, NoteInfo> notesInfo = new HashMap<String, NoteInfo>();
        int maxKeys = 200;
        String nextMarker = null;
        ObjectListing objectListing = null;
        do {
            objectListing = this.ossClient.listObjects(new ListObjectsRequest(this.bucketName).withPrefix(this.rootFolder + "/").withMarker(nextMarker).withMaxKeys(Integer.valueOf(200)));
            List sums = objectListing.getObjectSummaries();
            for (OSSObjectSummary s : sums) {
                if (s.getKey().endsWith(".zpln")) {
                    try {
                        String noteId = this.getNoteId(s.getKey());
                        String notePath = this.getNotePath(this.rootFolder, s.getKey());
                        notesInfo.put(noteId, new NoteInfo(noteId, notePath));
                    }
                    catch (IOException e) {
                        LOGGER.warn(e.getMessage());
                    }
                    continue;
                }
                LOGGER.debug("Skip invalid note file: " + s.getKey());
            }
            nextMarker = objectListing.getNextMarker();
        } while (objectListing.isTruncated());
        return notesInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Note get(String noteId, String notePath, AuthenticationInfo subject) throws IOException {
        OSSObject ossObject = this.ossClient.getObject(this.bucketName, this.rootFolder + "/" + this.buildNoteFileName(noteId, notePath));
        try (InputStream in = null;){
            in = ossObject.getObjectContent();
            Note note = Note.fromJson((String)IOUtils.toString((InputStream)in));
            return note;
        }
    }

    public void save(Note note, AuthenticationInfo subject) throws IOException {
        String content = note.toJson();
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucketName, this.rootFolder + "/" + this.buildNoteFileName(note.getId(), note.getPath()), (InputStream)new ByteArrayInputStream(content.getBytes()));
        this.ossClient.putObject(putObjectRequest);
    }

    public void move(String noteId, String notePath, String newNotePath, AuthenticationInfo subject) throws IOException {
        String sourceKey = this.rootFolder + "/" + this.buildNoteFileName(noteId, notePath);
        String destKey = this.rootFolder + "/" + this.buildNoteFileName(noteId, newNotePath);
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(this.bucketName, sourceKey, this.bucketName, destKey);
        this.ossClient.copyObject(copyObjectRequest);
        this.ossClient.deleteObject(this.bucketName, sourceKey);
    }

    public void move(String folderPath, String newFolderPath, AuthenticationInfo subject) {
        int maxKeys = 200;
        String nextMarker = null;
        ObjectListing objectListing = null;
        do {
            objectListing = this.ossClient.listObjects(new ListObjectsRequest(this.bucketName).withPrefix(this.rootFolder + folderPath + "/").withMarker(nextMarker).withMaxKeys(Integer.valueOf(200)));
            List sums = objectListing.getObjectSummaries();
            for (OSSObjectSummary s : sums) {
                if (s.getKey().endsWith(".zpln")) {
                    try {
                        String noteId = this.getNoteId(s.getKey());
                        String notePath = this.getNotePath(this.rootFolder, s.getKey());
                        String newNotePath = newFolderPath + notePath.substring(folderPath.length());
                        this.move(noteId, notePath, newNotePath, subject);
                    }
                    catch (IOException e) {
                        LOGGER.warn(e.getMessage());
                    }
                    continue;
                }
                LOGGER.debug("Skip invalid note file: " + s.getKey());
            }
            nextMarker = objectListing.getNextMarker();
        } while (objectListing.isTruncated());
    }

    public void remove(String noteId, String notePath, AuthenticationInfo subject) throws IOException {
        this.ossClient.deleteObject(this.bucketName, this.rootFolder + "/" + this.buildNoteFileName(noteId, notePath));
    }

    public void remove(String folderPath, AuthenticationInfo subject) {
        String nextMarker = null;
        ObjectListing objectListing = null;
        do {
            ListObjectsRequest listObjectsRequest;
            if ((objectListing = this.ossClient.listObjects(listObjectsRequest = new ListObjectsRequest(this.bucketName).withPrefix(this.rootFolder + folderPath + "/").withMarker(nextMarker))).getObjectSummaries().size() > 0) {
                ArrayList<String> keys = new ArrayList<String>();
                for (OSSObjectSummary s : objectListing.getObjectSummaries()) {
                    keys.add(s.getKey());
                }
                DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(this.bucketName).withKeys(keys);
                this.ossClient.deleteObjects(deleteObjectsRequest);
            }
            nextMarker = objectListing.getNextMarker();
        } while (objectListing.isTruncated());
    }

    public void close() {
        this.ossClient.shutdown();
    }

    public List<NotebookRepoSettingsInfo> getSettings(AuthenticationInfo subject) {
        LOGGER.warn("Method not implemented");
        return Collections.emptyList();
    }

    public void updateSettings(Map<String, String> settings, AuthenticationInfo subject) {
        LOGGER.warn("Method not implemented");
    }
}

