/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.launcher;

import java.io.IOException;
import java.util.Map;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.launcher.DockerInterpreterProcess;
import org.apache.zeppelin.interpreter.launcher.FlinkInterpreterLauncher;
import org.apache.zeppelin.interpreter.launcher.InterpreterClient;
import org.apache.zeppelin.interpreter.launcher.InterpreterLaunchContext;
import org.apache.zeppelin.interpreter.launcher.InterpreterLauncher;
import org.apache.zeppelin.interpreter.launcher.SparkInterpreterLauncher;
import org.apache.zeppelin.interpreter.launcher.StandardInterpreterLauncher;
import org.apache.zeppelin.interpreter.recovery.RecoveryStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerInterpreterLauncher
extends InterpreterLauncher {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerInterpreterLauncher.class);
    private InterpreterLaunchContext context;

    public DockerInterpreterLauncher(ZeppelinConfiguration zConf, RecoveryStorage recoveryStorage) throws IOException {
        super(zConf, recoveryStorage);
    }

    public InterpreterClient launchDirectly(InterpreterLaunchContext context) throws IOException {
        LOGGER.info("Launching Interpreter: " + context.getInterpreterSettingGroup());
        this.context = context;
        this.properties = context.getProperties();
        int connectTimeout = this.getConnectTimeout();
        if (connectTimeout < 200000) {
            LOGGER.warn("DockerInterpreterLauncher needs to pull the image and create the container, it takes a long time, If the creation of the interpreter on docker fails, please increase the value of `zeppelin.interpreter.connect.timeout` in `zeppelin-site.xml`, recommend 200 seconds.");
        }
        Object interpreterLauncher = null;
        interpreterLauncher = this.isSpark() ? new SparkInterpreterLauncher(this.zConf, this.recoveryStorage) : (this.isFlink() ? new FlinkInterpreterLauncher(this.zConf, this.recoveryStorage) : new StandardInterpreterLauncher(this.zConf, this.recoveryStorage));
        interpreterLauncher.setProperties(context.getProperties());
        Map env = interpreterLauncher.buildEnvFromProperties(context);
        return new DockerInterpreterProcess(this.zConf, this.zConf.getDockerContainerImage(), context.getInterpreterGroupId(), context.getInterpreterSettingGroup(), context.getInterpreterSettingName(), this.properties, env, context.getIntpEventServerHost(), context.getIntpEventServerPort(), connectTimeout, 10);
    }

    boolean isSpark() {
        return "spark".equalsIgnoreCase(this.context.getInterpreterSettingName());
    }

    boolean isFlink() {
        return "flink".equalsIgnoreCase(this.context.getInterpreterSettingName());
    }
}

