/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkStageInfo;
import org.apache.spark.SparkStatusTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class JobProgressUtil$ {
    public static JobProgressUtil$ MODULE$;
    private Logger LOGGER;
    private volatile boolean bitmap$0;

    static {
        new JobProgressUtil$();
    }

    private Logger LOGGER$lzycompute() {
        JobProgressUtil$ jobProgressUtil$ = this;
        synchronized (jobProgressUtil$) {
            if (!this.bitmap$0) {
                this.LOGGER = LoggerFactory.getLogger(this.getClass());
                this.bitmap$0 = true;
            }
        }
        return this.LOGGER;
    }

    public Logger LOGGER() {
        return !this.bitmap$0 ? this.LOGGER$lzycompute() : this.LOGGER;
    }

    public int progress(SparkContext sc, String jobGroup) {
        int n;
        Option jobInfo2 = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(sc.statusTracker().getJobIdsForGroup(jobGroup))).headOption().flatMap((Function1 & Serializable & scala.Serializable)jobId -> JobProgressUtil$.$anonfun$progress$1(sc, BoxesRunTime.unboxToInt((Object)jobId)));
        Option stagesInfoOption = jobInfo2.flatMap((Function1 & Serializable & scala.Serializable)jobInfo -> {
            SparkStatusTracker sparkStatusTracker = sc.statusTracker();
            return new Some(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(jobInfo.stageIds())).flatMap((Function1 & Serializable & scala.Serializable)stageId -> Option$.MODULE$.option2Iterable(sparkStatusTracker.getStageInfo(BoxesRunTime.unboxToInt((Object)stageId))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SparkStageInfo.class))));
        });
        Option option = stagesInfoOption;
        if (None$.MODULE$.equals(option)) {
            n = 0;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            SparkStageInfo[] stagesInfo = (SparkStageInfo[])some.value();
            int taskCount = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stagesInfo)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.numTasks()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            int completedTaskCount = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stagesInfo)).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.numCompletedTasks()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            this.LOGGER().debug(new StringBuilder(17).append("Total TaskCount: ").append(taskCount).toString());
            this.LOGGER().debug(new StringBuilder(21).append("Completed TaskCount: ").append(completedTaskCount).toString());
            n = taskCount == 0 ? 0 : (int)((double)100 * (double)completedTaskCount / (double)taskCount);
        } else {
            throw new MatchError((Object)option);
        }
        return n;
    }

    public static final /* synthetic */ Option $anonfun$progress$1(SparkContext sc$1, int jobId) {
        return sc$1.statusTracker().getJobInfo(jobId);
    }

    private JobProgressUtil$() {
        MODULE$ = this;
    }
}

