/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava;

import com.hubspot.jinjava.interpret.Context;
import com.hubspot.jinjava.random.RandomNumberGeneratorStrategy;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class JinjavaConfig {
    private final Charset charset;
    private final Locale locale;
    private final ZoneId timeZone;
    private final int maxRenderDepth;
    private final long maxOutputSize;
    private final boolean trimBlocks;
    private final boolean lstripBlocks;
    private final boolean readOnlyResolver;
    private final boolean enableRecursiveMacroCalls;
    private Map<Context.Library, Set<String>> disabled;
    private final boolean failOnUnknownTokens;
    private final boolean nestedInterpretationEnabled;
    private final RandomNumberGeneratorStrategy randomNumberGenerator;

    public static Builder newBuilder() {
        return new Builder();
    }

    public JinjavaConfig() {
        this(StandardCharsets.UTF_8, Locale.ENGLISH, ZoneOffset.UTC, 10, new HashMap<Context.Library, Set<String>>(), false, false, true, false, false, 0L, true, RandomNumberGeneratorStrategy.THREAD_LOCAL);
    }

    public JinjavaConfig(Charset charset, Locale locale, ZoneId timeZone, int maxRenderDepth) {
        this(charset, locale, timeZone, maxRenderDepth, new HashMap<Context.Library, Set<String>>(), false, false, true, false, false, 0L, true, RandomNumberGeneratorStrategy.THREAD_LOCAL);
    }

    private JinjavaConfig(Charset charset, Locale locale, ZoneId timeZone, int maxRenderDepth, Map<Context.Library, Set<String>> disabled, boolean trimBlocks, boolean lstripBlocks, boolean readOnlyResolver, boolean enableRecursiveMacroCalls, boolean failOnUnknownTokens, long maxOutputSize, boolean nestedInterpretationEnabled, RandomNumberGeneratorStrategy randomNumberGenerator) {
        this.charset = charset;
        this.locale = locale;
        this.timeZone = timeZone;
        this.maxRenderDepth = maxRenderDepth;
        this.disabled = disabled;
        this.trimBlocks = trimBlocks;
        this.lstripBlocks = lstripBlocks;
        this.readOnlyResolver = readOnlyResolver;
        this.enableRecursiveMacroCalls = enableRecursiveMacroCalls;
        this.failOnUnknownTokens = failOnUnknownTokens;
        this.maxOutputSize = maxOutputSize;
        this.nestedInterpretationEnabled = nestedInterpretationEnabled;
        this.randomNumberGenerator = randomNumberGenerator;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public int getMaxRenderDepth() {
        return this.maxRenderDepth;
    }

    public long getMaxOutputSize() {
        return this.maxOutputSize;
    }

    public RandomNumberGeneratorStrategy getRandomNumberGeneratorStrategy() {
        return this.randomNumberGenerator;
    }

    public boolean isTrimBlocks() {
        return this.trimBlocks;
    }

    public boolean isLstripBlocks() {
        return this.lstripBlocks;
    }

    public boolean isReadOnlyResolver() {
        return this.readOnlyResolver;
    }

    public boolean isEnableRecursiveMacroCalls() {
        return this.enableRecursiveMacroCalls;
    }

    public Map<Context.Library, Set<String>> getDisabled() {
        return this.disabled;
    }

    public boolean isFailOnUnknownTokens() {
        return this.failOnUnknownTokens;
    }

    public boolean isNestedInterpretationEnabled() {
        return this.nestedInterpretationEnabled;
    }

    public static class Builder {
        private Charset charset = StandardCharsets.UTF_8;
        private Locale locale = Locale.ENGLISH;
        private ZoneId timeZone = ZoneOffset.UTC;
        private int maxRenderDepth = 10;
        private long maxOutputSize = 0L;
        private Map<Context.Library, Set<String>> disabled = new HashMap<Context.Library, Set<String>>();
        private boolean trimBlocks;
        private boolean lstripBlocks;
        private boolean readOnlyResolver = true;
        private boolean enableRecursiveMacroCalls;
        private boolean failOnUnknownTokens;
        private boolean nestedInterpretationEnabled = true;
        private RandomNumberGeneratorStrategy randomNumberGeneratorStrategy = RandomNumberGeneratorStrategy.THREAD_LOCAL;

        private Builder() {
        }

        public Builder withCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder withLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder withTimeZone(ZoneId timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public Builder withDisabled(Map<Context.Library, Set<String>> disabled) {
            this.disabled = disabled;
            return this;
        }

        public Builder withMaxRenderDepth(int maxRenderDepth) {
            this.maxRenderDepth = maxRenderDepth;
            return this;
        }

        public Builder withRandomNumberGeneratorStrategy(RandomNumberGeneratorStrategy randomNumberGeneratorStrategy) {
            this.randomNumberGeneratorStrategy = randomNumberGeneratorStrategy;
            return this;
        }

        public Builder withTrimBlocks(boolean trimBlocks) {
            this.trimBlocks = trimBlocks;
            return this;
        }

        public Builder withLstripBlocks(boolean lstripBlocks) {
            this.lstripBlocks = lstripBlocks;
            return this;
        }

        public Builder withEnableRecursiveMacroCalls(boolean enableRecursiveMacroCalls) {
            this.enableRecursiveMacroCalls = enableRecursiveMacroCalls;
            return this;
        }

        public Builder withReadOnlyResolver(boolean readOnlyResolver) {
            this.readOnlyResolver = readOnlyResolver;
            return this;
        }

        public Builder withFailOnUnknownTokens(boolean failOnUnknownTokens) {
            this.failOnUnknownTokens = failOnUnknownTokens;
            return this;
        }

        public Builder withMaxOutputSize(long maxOutputSize) {
            this.maxOutputSize = maxOutputSize;
            return this;
        }

        public Builder withNestedInterpretationEnabled(boolean nestedInterpretationEnabled) {
            this.nestedInterpretationEnabled = nestedInterpretationEnabled;
            return this;
        }

        public JinjavaConfig build() {
            return new JinjavaConfig(this.charset, this.locale, this.timeZone, this.maxRenderDepth, this.disabled, this.trimBlocks, this.lstripBlocks, this.readOnlyResolver, this.enableRecursiveMacroCalls, this.failOnUnknownTokens, this.maxOutputSize, this.nestedInterpretationEnabled, this.randomNumberGeneratorStrategy);
        }
    }
}

