/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.toc.internal;

import com.vladsch.flexmark.ext.toc.internal.TocLevelsOptionParser;
import com.vladsch.flexmark.ext.toc.internal.TocOptions;
import com.vladsch.flexmark.util.Pair;
import com.vladsch.flexmark.util.options.BooleanOptionParser;
import com.vladsch.flexmark.util.options.MessageProvider;
import com.vladsch.flexmark.util.options.OptionParser;
import com.vladsch.flexmark.util.options.ParsedOption;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.List;

public enum TocOptionTypes implements OptionParser<TocOptions>
{
    LEVELS(new TocLevelsOptionParser("levels")),
    BULLETS((OptionParser<TocOptions>)new BooleanOptionParser<TocOptions>("bullet"){

        @Override
        protected boolean isOptionSet(TocOptions options) {
            return !options.isNumbered;
        }

        @Override
        public TocOptions setOptions(TocOptions options) {
            return options.withIsNumbered(false);
        }
    }),
    NUMERIC((OptionParser<TocOptions>)new BooleanOptionParser<TocOptions>("numbered"){

        @Override
        protected boolean isOptionSet(TocOptions options) {
            return options.isNumbered;
        }

        @Override
        public TocOptions setOptions(TocOptions options) {
            return options.withIsNumbered(true);
        }
    }),
    TEXT((OptionParser<TocOptions>)new BooleanOptionParser<TocOptions>("text"){

        @Override
        protected boolean isOptionSet(TocOptions options) {
            return options.isTextOnly;
        }

        @Override
        public TocOptions setOptions(TocOptions options) {
            return options.withIsTextOnly(true);
        }
    }),
    FORMATTED((OptionParser<TocOptions>)new BooleanOptionParser<TocOptions>("formatted"){

        @Override
        protected boolean isOptionSet(TocOptions options) {
            return !options.isTextOnly;
        }

        @Override
        public TocOptions setOptions(TocOptions options) {
            return options.withIsTextOnly(false);
        }
    }),
    HIERARCHY((OptionParser<TocOptions>)new BooleanOptionParser<TocOptions>("hierarchy"){

        @Override
        protected boolean isOptionSet(TocOptions options) {
            return options.listType == TocOptions.ListType.HIERARCHY;
        }

        @Override
        public TocOptions setOptions(TocOptions options) {
            return options.withListType(TocOptions.ListType.HIERARCHY);
        }
    }),
    FLAT((OptionParser<TocOptions>)new BooleanOptionParser<TocOptions>("flat"){

        @Override
        protected boolean isOptionSet(TocOptions options) {
            return options.listType == TocOptions.ListType.FLAT;
        }

        @Override
        public TocOptions setOptions(TocOptions options) {
            return options.withListType(TocOptions.ListType.FLAT);
        }
    }),
    FLAT_REVERSED((OptionParser<TocOptions>)new BooleanOptionParser<TocOptions>("reversed"){

        @Override
        protected boolean isOptionSet(TocOptions options) {
            return options.listType == TocOptions.ListType.FLAT_REVERSED;
        }

        @Override
        public TocOptions setOptions(TocOptions options) {
            return options.withListType(TocOptions.ListType.FLAT_REVERSED);
        }
    }),
    SORTED((OptionParser<TocOptions>)new BooleanOptionParser<TocOptions>("increasing"){

        @Override
        protected boolean isOptionSet(TocOptions options) {
            return options.listType == TocOptions.ListType.SORTED;
        }

        @Override
        public TocOptions setOptions(TocOptions options) {
            return options.withListType(TocOptions.ListType.SORTED);
        }
    }),
    SORTED_REVERSED((OptionParser<TocOptions>)new BooleanOptionParser<TocOptions>("decreasing"){

        @Override
        protected boolean isOptionSet(TocOptions options) {
            return options.listType == TocOptions.ListType.SORTED_REVERSED;
        }

        @Override
        public TocOptions setOptions(TocOptions options) {
            return options.withListType(TocOptions.ListType.SORTED_REVERSED);
        }
    });

    public final OptionParser<TocOptions> parser;
    public static final OptionParser<TocOptions>[] OPTIONS;

    @Override
    public String getOptionName() {
        return this.parser.getOptionName();
    }

    @Override
    public Pair<TocOptions, List<ParsedOption<TocOptions>>> parseOption(BasedSequence optionText, TocOptions options, MessageProvider provider) {
        return this.parser.parseOption(optionText, options, provider);
    }

    @Override
    public String getOptionText(TocOptions options, TocOptions defaultOptions) {
        return this.parser.getOptionText(options, defaultOptions);
    }

    private TocOptionTypes(OptionParser<TocOptions> parser) {
        this.parser = parser;
    }

    static {
        OPTIONS = TocOptionTypes.values();
    }

    static class Constants {
        static final String OPTION_BULLET = "bullet";
        static final String OPTION_NUMBERED = "numbered";
        static final String OPTION_TEXT = "text";
        static final String OPTION_FORMATTED = "formatted";
        static final String OPTION_HIERARCHY = "hierarchy";
        static final String OPTION_FLAT = "flat";
        static final String OPTION_FLAT_REVERSED = "reversed";
        static final String OPTION_SORTED = "increasing";
        static final String OPTION_SORTED_REVERSED = "decreasing";
        static final String OPTION_LEVELS = "levels";

        Constants() {
        }
    }
}

