/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.enumerated.reference.internal;

import com.vladsch.flexmark.ext.attributes.internal.AttributesNodeFormatter;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceBlock;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceExtension;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceLink;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceRepository;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceText;
import com.vladsch.flexmark.ext.enumerated.reference.internal.EnumeratedReferenceFormatOptions;
import com.vladsch.flexmark.formatter.CustomNodeFormatter;
import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.NodeFormatter;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.formatter.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.NodeFormattingHandler;
import com.vladsch.flexmark.formatter.NodeRepositoryFormatter;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.format.options.ElementPlacement;
import com.vladsch.flexmark.util.format.options.ElementPlacementSort;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class EnumeratedReferenceNodeFormatter
extends NodeRepositoryFormatter<EnumeratedReferenceRepository, EnumeratedReferenceBlock, EnumeratedReferenceText> {
    private final EnumeratedReferenceFormatOptions options;

    public EnumeratedReferenceNodeFormatter(DataHolder options) {
        super(options, null, AttributesNodeFormatter.ATTRIBUTE_UNIQUIFICATION_CATEGORY_MAP);
        this.options = new EnumeratedReferenceFormatOptions(options);
    }

    @Override
    public EnumeratedReferenceRepository getRepository(DataHolder options) {
        return EnumeratedReferenceExtension.ENUMERATED_REFERENCES.getFrom(options);
    }

    @Override
    public ElementPlacement getReferencePlacement() {
        return this.options.enumeratedReferencePlacement;
    }

    @Override
    public ElementPlacementSort getReferenceSort() {
        return this.options.enumeratedReferenceSort;
    }

    @Override
    protected void renderReferenceBlock(EnumeratedReferenceBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        ((MarkdownWriter)((MarkdownWriter)markdown.blankLine()).append("[@")).appendNonTranslating(node.getText()).append("]: ");
        ((MarkdownWriter)markdown.pushPrefix()).addPrefix("    ", true);
        context.renderChildren(node);
        markdown.popPrefix();
        markdown.blankLine();
    }

    @Override
    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeFormattingHandler<EnumeratedReferenceText>(EnumeratedReferenceText.class, new CustomNodeFormatter<EnumeratedReferenceText>(){

            @Override
            public void render(EnumeratedReferenceText node, NodeFormatterContext context, MarkdownWriter markdown) {
                EnumeratedReferenceNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<EnumeratedReferenceLink>(EnumeratedReferenceLink.class, new CustomNodeFormatter<EnumeratedReferenceLink>(){

            @Override
            public void render(EnumeratedReferenceLink node, NodeFormatterContext context, MarkdownWriter markdown) {
                EnumeratedReferenceNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<EnumeratedReferenceBlock>(EnumeratedReferenceBlock.class, new CustomNodeFormatter<EnumeratedReferenceBlock>(){

            @Override
            public void render(EnumeratedReferenceBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
                EnumeratedReferenceNodeFormatter.this.render(node, context, markdown);
            }
        })));
    }

    @Override
    public Set<Class<?>> getNodeClasses() {
        if (this.options.enumeratedReferencePlacement != ElementPlacement.AS_IS && this.options.enumeratedReferenceSort != ElementPlacementSort.SORT_UNUSED_LAST) {
            return null;
        }
        return new HashSet(Arrays.asList(EnumeratedReferenceBlock.class));
    }

    private void render(EnumeratedReferenceBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.renderReference(node, context, markdown);
    }

    private static void renderReferenceText(BasedSequence text, NodeFormatterContext context, MarkdownWriter markdown) {
        if (!text.isEmpty()) {
            String category;
            BasedSequence valueChars = text;
            int pos = valueChars.indexOf(':');
            String id = null;
            if (pos == -1) {
                category = text.toString();
            } else {
                category = ((BasedSequence)valueChars.subSequence(0, pos)).toString();
                id = ((BasedSequence)valueChars.subSequence(pos + 1)).toString();
            }
            String encoded = AttributesNodeFormatter.getEncodedIdAttribute(category, id, context, markdown);
            markdown.append(encoded);
        }
    }

    private void render(EnumeratedReferenceText node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.append("[#");
        if (context.isTransformingText()) {
            EnumeratedReferenceNodeFormatter.renderReferenceText(node.getText(), context, markdown);
        } else {
            context.renderChildren(node);
        }
        markdown.append("]");
    }

    private void render(EnumeratedReferenceLink node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.append("[@");
        if (context.isTransformingText()) {
            if (context.isTransformingText()) {
                EnumeratedReferenceNodeFormatter.renderReferenceText(node.getText(), context, markdown);
            } else {
                context.renderChildren(node);
            }
        } else {
            context.renderChildren(node);
        }
        markdown.append("]");
    }

    public static class Factory
    implements NodeFormatterFactory {
        @Override
        public NodeFormatter create(DataHolder options) {
            return new EnumeratedReferenceNodeFormatter(options);
        }

        @Override
        public Set<? extends Class> getAfterDependents() {
            HashSet<Class<AttributesNodeFormatter.Factory>> aSet = new HashSet<Class<AttributesNodeFormatter.Factory>>();
            aSet.add(AttributesNodeFormatter.Factory.class);
            return aSet;
        }

        @Override
        public Set<? extends Class> getBeforeDependents() {
            return null;
        }
    }
}

