/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.launcher;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.launcher.InterpreterLaunchContext;
import org.apache.zeppelin.interpreter.launcher.StandardInterpreterLauncher;
import org.apache.zeppelin.interpreter.recovery.RecoveryStorage;

public class FlinkInterpreterLauncher
extends StandardInterpreterLauncher {
    public FlinkInterpreterLauncher(ZeppelinConfiguration zConf, RecoveryStorage recoveryStorage) {
        super(zConf, recoveryStorage);
    }

    public Map<String, String> buildEnvFromProperties(InterpreterLaunchContext context) throws IOException {
        Map envs = super.buildEnvFromProperties(context);
        String flinkHome = context.getProperties().getProperty("FLINK_HOME", (String)envs.get("FLINK_HOME"));
        if (StringUtils.isBlank((CharSequence)flinkHome)) {
            throw new IOException("FLINK_HOME is not specified");
        }
        File flinkHomeFile = new File(flinkHome);
        if (!flinkHomeFile.exists()) {
            throw new IOException(String.format("FLINK_HOME '%s' doesn't exist", flinkHome));
        }
        if (!flinkHomeFile.isDirectory()) {
            throw new IOException(String.format("FLINK_HOME '%s' is a file, but should be directory", flinkHome));
        }
        if (!envs.containsKey("FLINK_CONF_DIR")) {
            envs.put("FLINK_CONF_DIR", flinkHome + "/conf");
        }
        envs.put("FLINK_LIB_DIR", flinkHome + "/lib");
        envs.put("FLINK_PLUGINS_DIR", flinkHome + "/plugins");
        return envs;
    }
}

