/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkJobInfo;
import org.apache.spark.SparkStageInfo;
import org.apache.spark.SparkStatusTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class JobProgressUtil$ {
    public static final JobProgressUtil$ MODULE$;
    private Logger LOGGER;
    private volatile boolean bitmap$0;

    static {
        new JobProgressUtil$();
    }

    private Logger LOGGER$lzycompute() {
        JobProgressUtil$ jobProgressUtil$ = this;
        synchronized (jobProgressUtil$) {
            if (!this.bitmap$0) {
                this.LOGGER = LoggerFactory.getLogger(this.getClass());
                this.bitmap$0 = true;
            }
            return this.LOGGER;
        }
    }

    public Logger LOGGER() {
        return this.bitmap$0 ? this.LOGGER : this.LOGGER$lzycompute();
    }

    public int progress(SparkContext sc, String jobGroup) {
        Option option;
        block4: {
            int n;
            block3: {
                block2: {
                    Option stagesInfoOption;
                    Option jobInfo = Predef$.MODULE$.intArrayOps(sc.statusTracker().getJobIdsForGroup(jobGroup)).headOption().flatMap((Function1)new Serializable(sc){
                        public static final long serialVersionUID = 0L;
                        private final SparkContext sc$1;

                        public final Option<SparkJobInfo> apply(int jobId) {
                            return this.sc$1.statusTracker().getJobInfo(jobId);
                        }
                        {
                            this.sc$1 = sc$1;
                        }
                    });
                    option = stagesInfoOption = jobInfo.flatMap((Function1)new Serializable(sc){
                        public static final long serialVersionUID = 0L;
                        private final SparkContext sc$1;

                        public final Some<SparkStageInfo[]> apply(SparkJobInfo jobInfo) {
                            SparkStatusTracker sparkStatusTracker = this.sc$1.statusTracker();
                            return new Some(Predef$.MODULE$.intArrayOps(jobInfo.stageIds()).flatMap((Function1)new Serializable(this, sparkStatusTracker){
                                public static final long serialVersionUID = 0L;
                                private final SparkStatusTracker eta$0$1$1;

                                public final Iterable<SparkStageInfo> apply(int stageId) {
                                    return Option$.MODULE$.option2Iterable(this.eta$0$1$1.getStageInfo(stageId));
                                }
                                {
                                    this.eta$0$1$1 = eta$0$1$1;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SparkStageInfo.class))));
                        }
                        {
                            this.sc$1 = sc$1;
                        }
                    });
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                    n = 0;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                SparkStageInfo[] stagesInfo = (SparkStageInfo[])some.x();
                int taskCount = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])stagesInfo).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final int apply(SparkStageInfo x$1) {
                        return x$1.numTasks();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                int completedTaskCount = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])stagesInfo).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final int apply(SparkStageInfo x$2) {
                        return x$2.numCompletedTasks();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                this.LOGGER().debug(new StringBuilder().append((Object)"Total TaskCount: ").append((Object)BoxesRunTime.boxToInteger((int)taskCount)).toString());
                this.LOGGER().debug(new StringBuilder().append((Object)"Completed TaskCount: ").append((Object)BoxesRunTime.boxToInteger((int)completedTaskCount)).toString());
                n = taskCount == 0 ? 0 : (int)((double)100 * (double)completedTaskCount / (double)taskCount);
            }
            return n;
        }
        throw new MatchError((Object)option);
    }

    private JobProgressUtil$() {
        MODULE$ = this;
    }
}

