/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.media.tags.internal;

import com.vladsch.flexmark.ast.InlineLinkNode;
import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public abstract class AbstractMediaLink
extends InlineLinkNode {
    private static final String INVALID_SEQUENCE = "%s Link's CharSequence MUST start with an '%s'!";
    private final String PREFIX;
    private final String TYPE;

    public AbstractMediaLink(String prefix, String type) {
        this.PREFIX = prefix;
        this.TYPE = type;
    }

    public AbstractMediaLink(String prefix, String type, Link other) {
        super(other.getChars().baseSubSequence(other.getChars().getStartOffset() - prefix.length(), other.getChars().getEndOffset()), other.getChars().baseSubSequence(other.getChars().getStartOffset() - prefix.length(), other.getTextOpeningMarker().getEndOffset()), other.getText(), other.getTextClosingMarker(), other.getLinkOpeningMarker(), other.getUrl(), other.getTitleOpeningMarker(), other.getTitle(), other.getTitleClosingMarker(), other.getLinkClosingMarker());
        this.PREFIX = prefix;
        this.TYPE = type;
        this.verifyBasedSequence(other.getChars(), other.getChars().getStartOffset() - prefix.length());
    }

    public final String getPrefix() {
        return this.PREFIX;
    }

    public void setTextChars(BasedSequence textChars) {
        this.verifyBasedSequence(textChars, 0);
        int textCharsLength = textChars.length();
        this.textOpeningMarker = (BasedSequence)textChars.subSequence(0, this.PREFIX.length() + 1);
        this.text = (BasedSequence)((BasedSequence)textChars.subSequence(this.PREFIX.length() + 2, textCharsLength - 1)).trim();
        this.textClosingMarker = (BasedSequence)textChars.subSequence(textCharsLength - 1, textCharsLength);
    }

    protected final void verifyBasedSequence(BasedSequence chars, int startOffset) {
        if (!chars.baseSubSequence(startOffset, startOffset + this.PREFIX.length()).matches((CharSequence)this.PREFIX)) {
            throw new IllegalArgumentException(String.format(INVALID_SEQUENCE, this.TYPE, this.PREFIX));
        }
    }
}

