/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.socket;

import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.common.Message;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.display.GUI;
import org.apache.zeppelin.display.Input;
import org.apache.zeppelin.notebook.AuthorizationService;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteInfo;
import org.apache.zeppelin.notebook.NotebookImportDeserializer;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.notebook.socket.WatcherMessage;
import org.apache.zeppelin.socket.NotebookSocket;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.apache.zeppelin.util.WatcherSecurityKey;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionManager.class);
    private static Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").registerTypeAdapter(Date.class, (Object)new NotebookImportDeserializer()).setPrettyPrinting().registerTypeAdapterFactory((TypeAdapterFactory)Input.TypeAdapterFactory).create();
    final Queue<NotebookSocket> connectedSockets = new ConcurrentLinkedQueue<NotebookSocket>();
    final Map<String, List<NotebookSocket>> noteSocketMap = new HashMap<String, List<NotebookSocket>>();
    final Map<String, Queue<NotebookSocket>> userSocketMap = new HashMap<String, Queue<NotebookSocket>>();
    final Queue<NotebookSocket> watcherSockets = Queues.newConcurrentLinkedQueue();
    private HashSet<String> collaborativeModeList = new HashSet();
    private Boolean collaborativeModeEnable = ZeppelinConfiguration.create().isZeppelinNotebookCollaborativeModeEnable();
    private AuthorizationService authorizationService;

    @Inject
    public ConnectionManager(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public void addConnection(NotebookSocket conn) {
        this.connectedSockets.add(conn);
    }

    public void removeConnection(NotebookSocket conn) {
        this.connectedSockets.remove((Object)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNoteConnection(String noteId, NotebookSocket socket) {
        LOGGER.debug("Add connection {} to note: {}", (Object)socket, (Object)noteId);
        Map<String, List<NotebookSocket>> map = this.noteSocketMap;
        synchronized (map) {
            this.removeConnectionFromAllNote(socket);
            List<NotebookSocket> socketList = this.noteSocketMap.get(noteId);
            if (socketList == null) {
                socketList = new LinkedList<NotebookSocket>();
                this.noteSocketMap.put(noteId, socketList);
            }
            if (!socketList.contains((Object)socket)) {
                socketList.add(socket);
            }
            this.checkCollaborativeStatus(noteId, socketList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNoteConnection(String noteId) {
        Map<String, List<NotebookSocket>> map = this.noteSocketMap;
        synchronized (map) {
            this.noteSocketMap.remove(noteId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNoteConnection(String noteId, NotebookSocket socket) {
        LOGGER.debug("Remove connection {} from note: {}", (Object)socket, (Object)noteId);
        Map<String, List<NotebookSocket>> map = this.noteSocketMap;
        synchronized (map) {
            List<NotebookSocket> socketList = this.noteSocketMap.get(noteId);
            if (socketList != null) {
                socketList.remove((Object)socket);
            }
            this.checkCollaborativeStatus(noteId, socketList);
        }
    }

    public void addUserConnection(String user, NotebookSocket conn) {
        LOGGER.debug("Add user connection {} for user: {}", (Object)conn, (Object)user);
        conn.setUser(user);
        if (this.userSocketMap.containsKey(user)) {
            this.userSocketMap.get(user).add(conn);
        } else {
            ConcurrentLinkedQueue<NotebookSocket> socketQueue = new ConcurrentLinkedQueue<NotebookSocket>();
            socketQueue.add(conn);
            this.userSocketMap.put(user, socketQueue);
        }
    }

    public void removeUserConnection(String user, NotebookSocket conn) {
        LOGGER.debug("Remove user connection {} for user: {}", (Object)conn, (Object)user);
        if (this.userSocketMap.containsKey(user)) {
            this.userSocketMap.get(user).remove((Object)conn);
        } else {
            LOGGER.warn("Closing connection that is absent in user connections");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAssociatedNoteId(NotebookSocket socket) {
        String associatedNoteId = null;
        Map<String, List<NotebookSocket>> map = this.noteSocketMap;
        synchronized (map) {
            Set<String> noteIds = this.noteSocketMap.keySet();
            for (String noteId : noteIds) {
                List<NotebookSocket> sockets = this.noteSocketMap.get(noteId);
                if (!sockets.contains((Object)socket)) continue;
                associatedNoteId = noteId;
            }
        }
        return associatedNoteId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionFromAllNote(NotebookSocket socket) {
        Map<String, List<NotebookSocket>> map = this.noteSocketMap;
        synchronized (map) {
            Set<String> noteIds = this.noteSocketMap.keySet();
            for (String noteId : noteIds) {
                this.removeConnectionFromNote(noteId, socket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConnectionFromNote(String noteId, NotebookSocket socket) {
        LOGGER.debug("Remove connection {} from note: {}", (Object)socket, (Object)noteId);
        Map<String, List<NotebookSocket>> map = this.noteSocketMap;
        synchronized (map) {
            List<NotebookSocket> socketList = this.noteSocketMap.get(noteId);
            if (socketList != null) {
                socketList.remove((Object)socket);
            }
            this.checkCollaborativeStatus(noteId, socketList);
        }
    }

    private void checkCollaborativeStatus(String noteId, List<NotebookSocket> socketList) {
        boolean collaborativeStatusNew;
        if (!this.collaborativeModeEnable.booleanValue()) {
            return;
        }
        boolean bl = collaborativeStatusNew = socketList.size() > 1;
        if (collaborativeStatusNew) {
            this.collaborativeModeList.add(noteId);
        } else {
            this.collaborativeModeList.remove(noteId);
        }
        Message message = new Message(Message.OP.COLLABORATIVE_MODE_STATUS);
        message.put("status", (Object)collaborativeStatusNew);
        if (collaborativeStatusNew) {
            HashSet<String> userList = new HashSet<String>();
            for (NotebookSocket noteSocket : socketList) {
                userList.add(noteSocket.getUser());
            }
            message.put("users", userList);
        }
        this.broadcast(noteId, message);
    }

    protected String serializeMessage(Message m) {
        return gson.toJson((Object)m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(Message m) {
        Queue<NotebookSocket> queue = this.connectedSockets;
        synchronized (queue) {
            for (NotebookSocket ns : this.connectedSockets) {
                try {
                    ns.send(this.serializeMessage(m));
                }
                catch (IOException | WebSocketException e) {
                    LOGGER.error("Send error: " + m, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(String noteId, Message m) {
        List<NotebookSocket> socketsToBroadcast = Collections.emptyList();
        Map<String, List<NotebookSocket>> map = this.noteSocketMap;
        synchronized (map) {
            this.broadcastToWatchers(noteId, "", m);
            List<NotebookSocket> socketLists = this.noteSocketMap.get(noteId);
            if (socketLists == null || socketLists.size() == 0) {
                return;
            }
            socketsToBroadcast = new ArrayList<NotebookSocket>(socketLists);
        }
        LOGGER.debug("SEND >> " + m);
        for (NotebookSocket conn : socketsToBroadcast) {
            try {
                conn.send(this.serializeMessage(m));
            }
            catch (IOException | WebSocketException e) {
                LOGGER.error("socket error", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastToWatchers(String noteId, String subject, Message message) {
        Queue<NotebookSocket> queue = this.watcherSockets;
        synchronized (queue) {
            for (NotebookSocket watcher : this.watcherSockets) {
                try {
                    watcher.send(WatcherMessage.builder((String)noteId).subject(subject).message(this.serializeMessage(message)).build().toJson());
                }
                catch (IOException | WebSocketException e) {
                    LOGGER.error("Cannot broadcast message to watcher", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastExcept(String noteId, Message m, NotebookSocket exclude) {
        List<NotebookSocket> socketsToBroadcast = Collections.emptyList();
        Map<String, List<NotebookSocket>> map = this.noteSocketMap;
        synchronized (map) {
            this.broadcastToWatchers(noteId, "", m);
            List<NotebookSocket> socketLists = this.noteSocketMap.get(noteId);
            if (socketLists == null || socketLists.size() == 0) {
                return;
            }
            socketsToBroadcast = new ArrayList<NotebookSocket>(socketLists);
        }
        LOGGER.debug("SEND >> " + m);
        for (NotebookSocket conn : socketsToBroadcast) {
            if (((Object)((Object)exclude)).equals((Object)conn)) continue;
            try {
                conn.send(this.serializeMessage(m));
            }
            catch (IOException | WebSocketException e) {
                LOGGER.error("socket error", e);
            }
        }
    }

    public void broadcastToAllConnections(String serialized) {
        this.broadcastToAllConnectionsExcept(null, serialized);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastToAllConnectionsExcept(NotebookSocket exclude, String serializedMsg) {
        Queue<NotebookSocket> queue = this.connectedSockets;
        synchronized (queue) {
            for (NotebookSocket conn : this.connectedSockets) {
                if (exclude != null && ((Object)((Object)exclude)).equals((Object)conn)) continue;
                try {
                    conn.send(serializedMsg);
                }
                catch (IOException | WebSocketException e) {
                    LOGGER.error("Cannot broadcast message to conn", e);
                }
            }
        }
    }

    public Set<String> getConnectedUsers() {
        HashSet connectedUsers = Sets.newHashSet();
        for (NotebookSocket notebookSocket : this.connectedSockets) {
            connectedUsers.add(notebookSocket.getUser());
        }
        return connectedUsers;
    }

    public void multicastToUser(String user, Message m) {
        if (!this.userSocketMap.containsKey(user)) {
            LOGGER.warn("Multicasting to user {} that is not in connections map", (Object)user);
            return;
        }
        for (NotebookSocket conn : this.userSocketMap.get(user)) {
            this.unicast(m, conn);
        }
    }

    public void unicast(Message m, NotebookSocket conn) {
        try {
            conn.send(this.serializeMessage(m));
        }
        catch (IOException | WebSocketException e) {
            LOGGER.error("socket error", e);
        }
        this.broadcastToWatchers("", "", m);
    }

    public void unicastParagraph(Note note, Paragraph p, String user, String msgId) {
        if (!note.isPersonalizedMode() || p == null || user == null) {
            return;
        }
        if (!this.userSocketMap.containsKey(user)) {
            LOGGER.warn("Failed to send unicast. user {} that is not in connections map", (Object)user);
            return;
        }
        for (NotebookSocket conn : this.userSocketMap.get(user)) {
            Message m = new Message(Message.OP.PARAGRAPH).withMsgId(msgId).put("paragraph", (Object)p);
            this.unicast(m, conn);
        }
    }

    public void forAllUsers(UserIterator iterator) {
        for (String user : this.userSocketMap.keySet()) {
            Set userAndRoles = this.authorizationService.getRoles(user);
            userAndRoles.add(user);
            iterator.handleUser(user, userAndRoles);
        }
    }

    public void broadcastNoteListExcept(List<NoteInfo> notesInfo, AuthenticationInfo subject) {
        for (String user : this.userSocketMap.keySet()) {
            if (subject.getUser().equals(user)) continue;
            Set userAndRoles = this.authorizationService.getRoles(user);
            userAndRoles.add(user);
            this.multicastToUser(user, new Message(Message.OP.NOTES_INFO).put("notes", notesInfo));
        }
    }

    public void broadcastNote(Note note) {
        this.broadcast(note.getId(), new Message(Message.OP.NOTE).put("note", (Object)note));
    }

    public void broadcastParagraph(Note note, Paragraph p) {
        this.broadcastNoteForms(note);
        if (note.isPersonalizedMode()) {
            this.broadcastParagraphs(p.getUserParagraphMap(), p);
        } else {
            this.broadcast(note.getId(), new Message(Message.OP.PARAGRAPH).put("paragraph", (Object)p));
        }
    }

    public void broadcastParagraphs(Map<String, Paragraph> userParagraphMap, Paragraph defaultParagraph) {
        if (null != userParagraphMap) {
            for (String user : userParagraphMap.keySet()) {
                this.multicastToUser(user, new Message(Message.OP.PARAGRAPH).put("paragraph", (Object)userParagraphMap.get(user)));
            }
        }
    }

    private void broadcastNewParagraph(Note note, Paragraph para) {
        LOGGER.info("Broadcasting paragraph on run call instead of note.");
        int paraIndex = note.getParagraphs().indexOf(para);
        this.broadcast(note.getId(), new Message(Message.OP.PARAGRAPH_ADDED).put("paragraph", (Object)para).put("index", (Object)paraIndex));
    }

    private void broadcastNoteForms(Note note) {
        GUI formsSettings = new GUI();
        formsSettings.setForms(note.getNoteForms());
        formsSettings.setParams(note.getNoteParams());
        this.broadcast(note.getId(), new Message(Message.OP.SAVE_NOTE_FORMS).put("formsData", (Object)formsSettings));
    }

    public void switchConnectionToWatcher(NotebookSocket conn) {
        if (!this.isSessionAllowedToSwitchToWatcher(conn)) {
            LOGGER.error("Cannot switch this client to watcher, invalid security key");
            return;
        }
        LOGGER.info("Going to add {} to watcher socket", (Object)conn);
        if (this.watcherSockets.contains((Object)conn)) {
            LOGGER.info("connection alrerady present in the watcher");
            return;
        }
        this.watcherSockets.add(conn);
        this.removeConnection(conn);
        this.removeConnectionFromAllNote(conn);
        this.removeUserConnection(conn.getUser(), conn);
    }

    private boolean isSessionAllowedToSwitchToWatcher(NotebookSocket session) {
        String watcherSecurityKey = session.getRequest().getHeader("X-Watcher-Key");
        return !StringUtils.isBlank((CharSequence)watcherSecurityKey) && watcherSecurityKey.equals(WatcherSecurityKey.getKey());
    }

    public static interface UserIterator {
        public void handleUser(String var1, Set<String> var2);
    }
}

