/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.service;

import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.service.ServiceCallback;
import org.apache.zeppelin.service.ServiceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationService.class);
    private ZeppelinConfiguration zConf;

    @Inject
    public ConfigurationService(ZeppelinConfiguration zConf) {
        this.zConf = zConf;
    }

    public Map<String, String> getAllProperties(ServiceContext context, ServiceCallback<Map<String, String>> callback) throws IOException {
        Map properties = this.zConf.dumpConfigurations(key -> !key.contains("password") && !key.equals(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_AZURE_CONNECTION_STRING.getVarName()));
        callback.onSuccess(properties, context);
        return properties;
    }

    public Map<String, String> getPropertiesWithPrefix(String prefix, ServiceContext context, ServiceCallback<Map<String, String>> callback) throws IOException {
        Map properties = this.zConf.dumpConfigurations(key -> !key.contains("password") && !key.equals(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_AZURE_CONNECTION_STRING.getVarName()) && key.startsWith(prefix));
        callback.onSuccess(properties, context);
        return properties;
    }
}

