/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.server;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.zeppelin.server.JsonExclusionStrategy;

public class JsonResponse<T> {
    private Response.Status status;
    private String message;
    private T body;
    transient ArrayList<NewCookie> cookies;
    transient boolean pretty = false;

    public JsonResponse(Response.Status status) {
        this.status = status;
        this.message = null;
        this.body = null;
    }

    public JsonResponse(Response.Status status, String message) {
        this.status = status;
        this.message = message;
        this.body = null;
    }

    public JsonResponse(Response.Status status, T body) {
        this.status = status;
        this.message = null;
        this.body = body;
    }

    public JsonResponse(Response.Status status, String message, T body) {
        this.status = status;
        this.message = message;
        this.body = body;
    }

    public JsonResponse<T> setPretty(boolean pretty) {
        this.pretty = pretty;
        return this;
    }

    public JsonResponse<T> addCookie(NewCookie newCookie) {
        if (this.cookies == null) {
            this.cookies = new ArrayList();
        }
        this.cookies.add(newCookie);
        return this;
    }

    public JsonResponse<?> addCookie(String name, String value) {
        return this.addCookie(new NewCookie(name, value));
    }

    public String toString() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        if (this.pretty) {
            gsonBuilder.setPrettyPrinting();
        }
        gsonBuilder.setExclusionStrategies(new ExclusionStrategy[]{new JsonExclusionStrategy()});
        Gson gson = gsonBuilder.create();
        return gson.toJson((Object)this);
    }

    public Response.Status getCode() {
        return this.status;
    }

    public void setCode(Response.Status status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getBody() {
        return this.body;
    }

    public void setBody(T body) {
        this.body = body;
    }

    public Response build() {
        Response.ResponseBuilder r = Response.status((Response.Status)this.status).entity((Object)this.toString());
        if (this.cookies != null) {
            for (NewCookie nc : this.cookies) {
                r.cookie(new NewCookie[]{nc});
            }
        }
        return r.build();
    }
}

