/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest.message;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.rest.message.ParagraphJobStatus;

public class NoteJobStatus {
    private static final Gson GSON = new Gson();
    private String id;
    private boolean isRunning;
    @SerializedName(value="paragraphs")
    private List<ParagraphJobStatus> paragraphJobStatusList;

    public NoteJobStatus(Note note) {
        this.id = note.getId();
        this.isRunning = note.isRunning();
        this.paragraphJobStatusList = note.getParagraphs().stream().map(p -> new ParagraphJobStatus((Paragraph)p)).collect(Collectors.toList());
    }

    public List<ParagraphJobStatus> getParagraphJobStatusList() {
        return this.paragraphJobStatusList;
    }

    public static NoteJobStatus fromJson(String json) {
        return (NoteJobStatus)GSON.fromJson(json, NoteJobStatus.class);
    }
}

