/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.annotation.ZeppelinApi;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.server.JsonResponse;
import org.apache.zeppelin.service.AuthenticationService;
import org.apache.zeppelin.ticket.TicketContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/security")
@Produces(value={"application/json"})
@Singleton
public class SecurityRestApi {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityRestApi.class);
    private static final Gson gson = new Gson();
    private final AuthenticationService authenticationService;

    @Inject
    public SecurityRestApi(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    @GET
    @Path(value="ticket")
    @ZeppelinApi
    public Response ticket() {
        ZeppelinConfiguration conf = ZeppelinConfiguration.create();
        String principal = this.authenticationService.getPrincipal();
        Set<String> roles = this.authenticationService.getAssociatedRoles();
        String ticket = "anonymous".equals(principal) ? "anonymous" : TicketContainer.instance.getTicket(principal);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("principal", principal);
        data.put("roles", gson.toJson(roles));
        data.put("ticket", ticket);
        JsonResponse response = new JsonResponse(Response.Status.OK, "", data);
        LOG.warn(response.toString());
        return response.build();
    }

    @GET
    @Path(value="userlist/{searchText}")
    public Response getUserList(@PathParam(value="searchText") String searchText) {
        int numUsersToFetch = 5;
        List<String> usersList = this.authenticationService.getMatchedUsers(searchText, 5);
        List<String> rolesList = this.authenticationService.getMatchedRoles();
        ArrayList<String> autoSuggestUserList = new ArrayList<String>();
        ArrayList<String> autoSuggestRoleList = new ArrayList<String>();
        Collections.sort(usersList);
        Collections.sort(rolesList);
        Collections.sort(usersList, (o1, o2) -> {
            if (o1.matches(searchText + "(.*)") && o2.matches(searchText + "(.*)")) {
                return 0;
            }
            if (o1.matches(searchText + "(.*)")) {
                return -1;
            }
            return 0;
        });
        int maxLength = 0;
        for (String user : usersList) {
            if (StringUtils.containsIgnoreCase((CharSequence)user, (CharSequence)searchText)) {
                autoSuggestUserList.add(user);
                ++maxLength;
            }
            if (maxLength != 5) continue;
            break;
        }
        for (String role : rolesList) {
            if (!StringUtils.containsIgnoreCase((CharSequence)role, (CharSequence)searchText)) continue;
            autoSuggestRoleList.add(role);
        }
        HashMap<String, ArrayList<String>> returnListMap = new HashMap<String, ArrayList<String>>();
        returnListMap.put("users", autoSuggestUserList);
        returnListMap.put("roles", autoSuggestRoleList);
        return new JsonResponse(Response.Status.OK, "", returnListMap).build();
    }
}

