/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.zeppelin.helium.Helium;
import org.apache.zeppelin.helium.HeliumPackage;
import org.apache.zeppelin.helium.HeliumPackageSearchResult;
import org.apache.zeppelin.helium.HeliumPackageSuggestion;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.Notebook;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.server.JsonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/helium")
@Produces(value={"application/json"})
@Singleton
public class HeliumRestApi {
    Logger logger = LoggerFactory.getLogger(HeliumRestApi.class);
    private Helium helium;
    private Notebook notebook;
    private Gson gson = new Gson();

    @Inject
    public HeliumRestApi(Helium helium, Notebook notebook) {
        this.helium = helium;
        this.notebook = notebook;
    }

    @GET
    @Path(value="package")
    public Response getAllPackageInfo() {
        try {
            return new JsonResponse<Map>(Response.Status.OK, "", this.helium.getAllPackageInfo()).build();
        }
        catch (RuntimeException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return new JsonResponse<String>(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage()).build();
        }
    }

    @GET
    @Path(value="enabledPackage")
    public Response getAllEnabledPackageInfo() {
        try {
            return new JsonResponse<List>(Response.Status.OK, "", this.helium.getAllEnabledPackages()).build();
        }
        catch (RuntimeException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return new JsonResponse<String>(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage()).build();
        }
    }

    @GET
    @Path(value="package/{packageName}")
    public Response getSinglePackageInfo(@PathParam(value="packageName") String packageName) {
        if (StringUtils.isEmpty((CharSequence)packageName)) {
            return new JsonResponse<String>(Response.Status.BAD_REQUEST, "Can't get package info for empty name").build();
        }
        try {
            return new JsonResponse<List>(Response.Status.OK, "", this.helium.getSinglePackageInfo(packageName)).build();
        }
        catch (RuntimeException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return new JsonResponse<String>(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage()).build();
        }
    }

    @GET
    @Path(value="suggest/{noteId}/{paragraphId}")
    public Response suggest(@PathParam(value="noteId") String noteId, @PathParam(value="paragraphId") String paragraphId) {
        Note note = null;
        try {
            note = this.notebook.getNote(noteId);
        }
        catch (IOException e) {
            return new JsonResponse<String>(Response.Status.NOT_FOUND, "Fail to get note: " + noteId + "\n" + ExceptionUtils.getStackTrace((Throwable)e)).build();
        }
        if (note == null) {
            return new JsonResponse<String>(Response.Status.NOT_FOUND, "Note " + noteId + " not found").build();
        }
        Paragraph paragraph = note.getParagraph(paragraphId);
        if (paragraph == null) {
            return new JsonResponse<String>(Response.Status.NOT_FOUND, "Paragraph " + paragraphId + " not found").build();
        }
        try {
            return new JsonResponse<HeliumPackageSuggestion>(Response.Status.OK, "", this.helium.suggestApp(paragraph)).build();
        }
        catch (RuntimeException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return new JsonResponse<String>(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage()).build();
        }
    }

    @POST
    @Path(value="load/{noteId}/{paragraphId}")
    public Response load(@PathParam(value="noteId") String noteId, @PathParam(value="paragraphId") String paragraphId, String heliumPackage) {
        Note note = null;
        try {
            note = this.notebook.getNote(noteId);
        }
        catch (IOException e) {
            return new JsonResponse<String>(Response.Status.NOT_FOUND, "Fail to get note: " + noteId + "\n" + ExceptionUtils.getStackTrace((Throwable)e)).build();
        }
        if (note == null) {
            return new JsonResponse<String>(Response.Status.NOT_FOUND, "Note " + noteId + " not found").build();
        }
        Paragraph paragraph = note.getParagraph(paragraphId);
        if (paragraph == null) {
            return new JsonResponse<String>(Response.Status.NOT_FOUND, "Paragraph " + paragraphId + " not found").build();
        }
        HeliumPackage pkg = HeliumPackage.fromJson((String)heliumPackage);
        try {
            return new JsonResponse<String>(Response.Status.OK, "", this.helium.getApplicationFactory().loadAndRun(pkg, paragraph)).build();
        }
        catch (RuntimeException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return new JsonResponse<String>(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage()).build();
        }
    }

    @GET
    @Path(value="bundle/load/{packageName}")
    @Produces(value={"text/javascript"})
    public Response bundleLoad(@QueryParam(value="refresh") String refresh, @PathParam(value="packageName") String packageName) {
        if (StringUtils.isEmpty((CharSequence)packageName)) {
            return new JsonResponse<String>(Response.Status.BAD_REQUEST, "Can't get bundle due to empty package name").build();
        }
        HeliumPackageSearchResult psr = null;
        List enabledPackages = this.helium.getAllEnabledPackages();
        for (HeliumPackageSearchResult e : enabledPackages) {
            if (!e.getPkg().getName().equals(packageName)) continue;
            psr = e;
            break;
        }
        if (psr == null) {
            return Response.ok().build();
        }
        try {
            boolean rebuild = refresh != null && refresh.equals("true");
            File bundle = this.helium.getBundle(psr.getPkg(), rebuild);
            if (bundle == null) {
                return Response.ok().build();
            }
            String stringified = FileUtils.readFileToString((File)bundle);
            return Response.ok((Object)stringified).build();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return Response.ok((Object)("ERROR: " + e.getMessage())).build();
        }
    }

    @POST
    @Path(value="enable/{packageName}")
    public Response enablePackage(@PathParam(value="packageName") String packageName, String artifact) {
        try {
            if (this.helium.enable(packageName, artifact)) {
                return new JsonResponse(Response.Status.OK).build();
            }
            return new JsonResponse(Response.Status.NOT_FOUND).build();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return new JsonResponse<String>(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage()).build();
        }
    }

    @POST
    @Path(value="disable/{packageName}")
    public Response disablePackage(@PathParam(value="packageName") String packageName) {
        try {
            if (this.helium.disable(packageName)) {
                return new JsonResponse(Response.Status.OK).build();
            }
            return new JsonResponse(Response.Status.NOT_FOUND).build();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return new JsonResponse<String>(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage()).build();
        }
    }

    @GET
    @Path(value="spell/config/{packageName}")
    public Response getSpellConfigUsingMagic(@PathParam(value="packageName") String packageName) {
        if (StringUtils.isEmpty((CharSequence)packageName)) {
            return new JsonResponse<String>(Response.Status.BAD_REQUEST, "packageName is empty").build();
        }
        try {
            Map config = this.helium.getSpellConfig(packageName);
            if (config == null) {
                return new JsonResponse<String>(Response.Status.BAD_REQUEST, "Failed to find enabled package for " + packageName).build();
            }
            return new JsonResponse<Map>(Response.Status.OK, config).build();
        }
        catch (RuntimeException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return new JsonResponse<String>(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage()).build();
        }
    }

    @GET
    @Path(value="config")
    public Response getAllPackageConfigs() {
        try {
            Map config = this.helium.getAllPackageConfig();
            return new JsonResponse<Map>(Response.Status.OK, config).build();
        }
        catch (RuntimeException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return new JsonResponse<String>(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage()).build();
        }
    }

    @GET
    @Path(value="config/{packageName}/{artifact}")
    public Response getPackageConfig(@PathParam(value="packageName") String packageName, @PathParam(value="artifact") String artifact) {
        if (StringUtils.isEmpty((CharSequence)packageName) || StringUtils.isEmpty((CharSequence)artifact)) {
            return new JsonResponse<String>(Response.Status.BAD_REQUEST, "package name or artifact is empty").build();
        }
        try {
            Map config = this.helium.getPackageConfig(packageName, artifact);
            if (config == null) {
                return new JsonResponse<String>(Response.Status.BAD_REQUEST, "Failed to find package for " + artifact).build();
            }
            return new JsonResponse<Map>(Response.Status.OK, config).build();
        }
        catch (RuntimeException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return new JsonResponse<String>(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage()).build();
        }
    }

    @POST
    @Path(value="config/{packageName}/{artifact}")
    public Response updatePackageConfig(@PathParam(value="packageName") String packageName, @PathParam(value="artifact") String artifact, String rawConfig) {
        if (StringUtils.isEmpty((CharSequence)packageName) || StringUtils.isEmpty((CharSequence)artifact)) {
            return new JsonResponse<String>(Response.Status.BAD_REQUEST, "package name or artifact is empty").build();
        }
        try {
            Map packageConfig = (Map)this.gson.fromJson(rawConfig, new TypeToken<Map<String, Object>>(){}.getType());
            this.helium.updatePackageConfig(artifact, packageConfig);
            return new JsonResponse<Map>(Response.Status.OK, packageConfig).build();
        }
        catch (JsonParseException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return new JsonResponse<String>(Response.Status.BAD_REQUEST, e.getMessage()).build();
        }
        catch (IOException | RuntimeException e) {
            return new JsonResponse<String>(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage()).build();
        }
    }

    @GET
    @Path(value="order/visualization")
    public Response getVisualizationPackageOrder() {
        try {
            List order = this.helium.getVisualizationPackageOrder();
            return new JsonResponse<List>(Response.Status.OK, order).build();
        }
        catch (RuntimeException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return new JsonResponse<String>(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage()).build();
        }
    }

    @POST
    @Path(value="order/visualization")
    public Response setVisualizationPackageOrder(String orderedPackageNameList) {
        List orderedList = (List)this.gson.fromJson(orderedPackageNameList, new TypeToken<List<String>>(){}.getType());
        try {
            this.helium.setVisualizationPackageOrder(orderedList);
            return new JsonResponse(Response.Status.OK).build();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return new JsonResponse<String>(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage()).build();
        }
    }
}

