/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.jnr.posix;

import com.spotify.docker.client.shaded.jnr.constants.Constant;
import com.spotify.docker.client.shaded.jnr.ffi.Platform;
import com.spotify.docker.client.shaded.jnr.ffi.mapper.FromNativeContext;
import com.spotify.docker.client.shaded.jnr.ffi.mapper.FromNativeConverter;
import com.spotify.docker.client.shaded.jnr.ffi.mapper.ToNativeContext;
import com.spotify.docker.client.shaded.jnr.ffi.mapper.ToNativeConverter;
import com.spotify.docker.client.shaded.jnr.ffi.mapper.TypeMapper;
import com.spotify.docker.client.shaded.jnr.posix.AixPOSIX;
import com.spotify.docker.client.shaded.jnr.posix.BaseNativePOSIX;
import com.spotify.docker.client.shaded.jnr.posix.FileStat;
import com.spotify.docker.client.shaded.jnr.posix.FreeBSDPOSIX;
import com.spotify.docker.client.shaded.jnr.posix.Group;
import com.spotify.docker.client.shaded.jnr.posix.HANDLE;
import com.spotify.docker.client.shaded.jnr.posix.LinuxPOSIX;
import com.spotify.docker.client.shaded.jnr.posix.MacOSPOSIX;
import com.spotify.docker.client.shaded.jnr.posix.MsgHdr;
import com.spotify.docker.client.shaded.jnr.posix.NativeTimes;
import com.spotify.docker.client.shaded.jnr.posix.OpenBSDPOSIX;
import com.spotify.docker.client.shaded.jnr.posix.Passwd;
import com.spotify.docker.client.shaded.jnr.posix.SolarisPOSIX;
import com.spotify.docker.client.shaded.jnr.posix.WString;
import com.spotify.docker.client.shaded.jnr.posix.WindowsPOSIX;
import com.spotify.docker.client.shaded.jnr.posix.util.Platform;

final class POSIXTypeMapper
implements TypeMapper {
    public static final TypeMapper INSTANCE = new POSIXTypeMapper();

    private POSIXTypeMapper() {
    }

    @Override
    public FromNativeConverter getFromNativeConverter(Class klazz) {
        if (Passwd.class.isAssignableFrom(klazz)) {
            if (Platform.IS_MAC) {
                return MacOSPOSIX.PASSWD;
            }
            if (Platform.IS_LINUX) {
                return LinuxPOSIX.PASSWD;
            }
            if (Platform.IS_SOLARIS) {
                return SolarisPOSIX.PASSWD;
            }
            if (Platform.IS_FREEBSD) {
                return FreeBSDPOSIX.PASSWD;
            }
            if (Platform.IS_OPENBSD) {
                return OpenBSDPOSIX.PASSWD;
            }
            if (Platform.IS_WINDOWS) {
                return WindowsPOSIX.PASSWD;
            }
            if (com.spotify.docker.client.shaded.jnr.ffi.Platform.getNativePlatform().getOS().equals((Object)Platform.OS.AIX)) {
                return AixPOSIX.PASSWD;
            }
            return null;
        }
        if (Group.class.isAssignableFrom(klazz)) {
            return BaseNativePOSIX.GROUP;
        }
        if (HANDLE.class.isAssignableFrom(klazz)) {
            return HANDLE.Converter;
        }
        return null;
    }

    @Override
    public ToNativeConverter getToNativeConverter(Class klazz) {
        if (FileStat.class.isAssignableFrom(klazz)) {
            return BaseNativePOSIX.FileStatConverter;
        }
        if (NativeTimes.class.isAssignableFrom(klazz)) {
            return BaseNativePOSIX.TimesConverter;
        }
        if (Constant.class.isAssignableFrom(klazz)) {
            return BaseNativePOSIX.ConstantConverter;
        }
        if (WString.class.isAssignableFrom(klazz)) {
            return WString.Converter;
        }
        if (HANDLE.class.isAssignableFrom(klazz)) {
            return HANDLE.Converter;
        }
        if (MsgHdr.class.isAssignableFrom(klazz)) {
            return BaseNativePOSIX.MsgHdrConverter;
        }
        return null;
    }

    public final ToNativeConverter getToNativeConverter(Class klazz, ToNativeContext context) {
        return this.getToNativeConverter(klazz);
    }

    public final FromNativeConverter getFromNativeConverter(Class klazz, FromNativeContext context) {
        return this.getFromNativeConverter(klazz);
    }
}

