/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.launcher;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.hubspot.jinjava.Jinjava;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.LocalPortForward;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.interpreter.launcher.K8sSpecTemplate;
import org.apache.zeppelin.interpreter.launcher.K8sUtils;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8sRemoteInterpreterProcess
extends RemoteInterpreterProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(K8sRemoteInterpreterProcess.class);
    private static final int K8S_INTERPRETER_SERVICE_PORT = 12321;
    private final KubernetesClient client;
    private final String namespace;
    private final String interpreterGroupId;
    private final String interpreterGroupName;
    private final String interpreterSettingName;
    private final File specTemplates;
    private final String containerImage;
    private final Properties properties;
    private final Map<String, String> envs;
    private final String podName;
    private final boolean portForward;
    private final String sparkImage;
    private LocalPortForward localPortForward;
    private int podPort = 12321;
    private String errorMessage;
    private final boolean isUserImpersonatedForSpark;
    private final boolean timeoutDuringPending;
    private AtomicBoolean started = new AtomicBoolean(false);
    private Random rand = new Random();
    private static final String SPARK_DRIVER_MEMORY = "spark.driver.memory";
    private static final String SPARK_DRIVER_MEMORY_OVERHEAD = "spark.driver.memoryOverhead";
    private static final String SPARK_DRIVER_CORES = "spark.driver.cores";
    private static final String ENV_SERVICE_DOMAIN = "SERVICE_DOMAIN";
    private static final String ENV_ZEPPELIN_HOME = "ZEPPELIN_HOME";

    public K8sRemoteInterpreterProcess(KubernetesClient client, String namespace, File specTemplates, String containerImage, String interpreterGroupId, String interpreterGroupName, String interpreterSettingName, Properties properties, Map<String, String> envs, String intpEventServerHost, int intpEventServerPort, boolean portForward, String sparkImage, int connectTimeout, int connectionPoolSize, boolean isUserImpersonatedForSpark, boolean timeoutDuringPending) {
        super(connectTimeout, connectionPoolSize, intpEventServerHost, intpEventServerPort);
        this.client = client;
        this.namespace = namespace;
        this.specTemplates = specTemplates;
        this.containerImage = containerImage;
        this.interpreterGroupId = interpreterGroupId;
        this.interpreterGroupName = interpreterGroupName;
        this.interpreterSettingName = interpreterSettingName;
        this.properties = properties;
        this.envs = new HashMap<String, String>(envs);
        this.portForward = portForward;
        this.sparkImage = sparkImage;
        this.podName = interpreterGroupName.toLowerCase() + "-" + this.getRandomString(6);
        this.isUserImpersonatedForSpark = isUserImpersonatedForSpark;
        this.timeoutDuringPending = timeoutDuringPending;
    }

    public String getPodName() {
        return this.podName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getInterpreterGroupId() {
        return this.interpreterGroupId;
    }

    public String getInterpreterSettingName() {
        return this.interpreterSettingName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start(String userName) throws IOException {
        Properties templateProperties = this.getTemplateBindings(userName);
        this.apply(this.specTemplates, false, templateProperties);
        if (this.portForward) {
            this.podPort = RemoteInterpreterUtils.findRandomAvailablePortOnAllLocalInterfaces();
            this.localPortForward = (LocalPortForward)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.namespace)).withName(this.podName)).portForward(12321, this.podPort);
        }
        if (!this.timeoutDuringPending) {
            while ("pending".equalsIgnoreCase(this.getPodPhase()) && !Thread.currentThread().isInterrupted()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    LOGGER.error("Interrupt received during pending phase. Try to stop the interpreter and interrupt the current thread.", e);
                    this.errorMessage = "Start process was interrupted during the pending phase";
                    this.stop();
                    Thread.currentThread().interrupt();
                }
            }
        }
        long startTime = System.currentTimeMillis();
        long timeoutTime = startTime + (long)this.getConnectTimeout();
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            while (!this.started.get() && !Thread.currentThread().isInterrupted()) {
                long timetoTimeout = timeoutTime - System.currentTimeMillis();
                if (timetoTimeout <= 0L) {
                    this.errorMessage = "The start process was aborted while waiting for the interpreter to start. PodPhase before stop: " + this.getPodPhase();
                    this.stop();
                    throw new IOException("Launching zeppelin interpreter on kubernetes is time out, kill it now");
                }
                try {
                    this.started.wait(timetoTimeout);
                }
                catch (InterruptedException e) {
                    LOGGER.error("Interrupt received during started wait. Try to stop the interpreter and interrupt the current thread.", e);
                    this.errorMessage = "The start process was interrupted while waiting for the interpreter to start. PodPhase before stop: " + this.getPodPhase();
                    this.stop();
                    Thread.currentThread().interrupt();
                }
            }
        }
        while (!RemoteInterpreterUtils.checkIfRemoteEndpointAccessible((String)this.getHost(), (int)this.getPort()) && !Thread.currentThread().isInterrupted()) {
            if (System.currentTimeMillis() - timeoutTime > 0L) {
                this.errorMessage = "The start process was aborted while waiting for the accessibility check of the remote end point. PodPhase before stop: " + this.getPodPhase();
                this.stop();
                throw new IOException("Launching zeppelin interpreter on kubernetes is time out, kill it now");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupt received during remote endpoint accessible check. Try to stop the interpreter and interrupt the current thread.", e);
                this.errorMessage = "The start process was interrupted while waiting for the accessibility check of the remote end point. PodPhase before stop: " + this.getPodPhase();
                this.stop();
                Thread.currentThread().interrupt();
            }
        }
    }

    public void stop() {
        Properties templateProperties = this.getTemplateBindings(null);
        try {
            this.apply(this.specTemplates, true, templateProperties);
        }
        catch (IOException e) {
            LOGGER.info("Error on removing interpreter pod", e);
        }
        if (this.portForward) {
            try {
                this.localPortForward.close();
            }
            catch (IOException e) {
                LOGGER.info("Error on closing portforwarder", e);
            }
        }
        this.shutdown();
    }

    public String getHost() {
        if (this.portForward) {
            return "localhost";
        }
        return this.getInterpreterPodDnsName();
    }

    public int getPort() {
        return this.podPort;
    }

    public boolean isRunning() {
        try {
            PodStatus status;
            if (RemoteInterpreterUtils.checkIfRemoteEndpointAccessible((String)this.getHost(), (int)this.getPort())) {
                return true;
            }
            Pod pod = (Pod)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.namespace)).withName(this.podName)).get();
            if (pod != null && (status = pod.getStatus()) != null) {
                return "Running".equals(status.getPhase()) && this.started.get();
            }
        }
        catch (Exception e) {
            LOGGER.error("Can't get pod status", e);
        }
        return false;
    }

    public String getPodPhase() {
        Pod pod = (Pod)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.namespace)).withName(this.podName)).get();
        if (pod != null) {
            return pod.getStatus().getPhase();
        }
        return "Unknown";
    }

    void apply(File path, boolean delete, Properties templateProperties) throws IOException {
        if (path.getName().startsWith(".") || path.isHidden() || path.getName().endsWith("~")) {
            LOGGER.info("Skip {}", (Object)path.getAbsolutePath());
        }
        if (path.isDirectory()) {
            Object[] files = path.listFiles();
            Arrays.sort(files);
            if (delete) {
                ArrayUtils.reverse(files);
            }
            for (Object f : files) {
                this.apply((File)f, delete, templateProperties);
            }
        } else if (path.isFile()) {
            K8sSpecTemplate specTemplate = new K8sSpecTemplate();
            specTemplate.loadProperties(templateProperties);
            String template = specTemplate.render(path);
            ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> k8sObjects = this.client.load(IOUtils.toInputStream((String)template, (Charset)StandardCharsets.UTF_8));
            LOGGER.info("Apply {} with {} K8s Objects", (Object)path.getAbsolutePath(), (Object)((List)k8sObjects.get()).size());
            LOGGER.debug(template);
            if (delete) {
                ((ListVisitFromServerGetDeleteRecreateWaitApplicable)k8sObjects.inNamespace(this.namespace)).delete();
            } else {
                ((ListVisitFromServerGetDeleteRecreateWaitApplicable)k8sObjects.inNamespace(this.namespace)).createOrReplace();
            }
        } else {
            LOGGER.error("Can't apply {}", (Object)path.getAbsolutePath());
        }
    }

    @VisibleForTesting
    Properties getTemplateBindings(String userName) {
        Properties k8sProperties = new Properties();
        k8sProperties.put("zeppelin.k8s.namespace", this.getNamespace());
        k8sProperties.put("zeppelin.k8s.interpreter.pod.name", this.getPodName());
        k8sProperties.put("zeppelin.k8s.interpreter.container.name", this.interpreterGroupName.toLowerCase());
        k8sProperties.put("zeppelin.k8s.interpreter.container.image", this.containerImage);
        k8sProperties.put("zeppelin.k8s.interpreter.group.id", this.interpreterGroupId);
        k8sProperties.put("zeppelin.k8s.interpreter.group.name", this.interpreterGroupName);
        k8sProperties.put("zeppelin.k8s.interpreter.setting.name", this.interpreterSettingName);
        k8sProperties.put("zeppelin.k8s.interpreter.localRepo", "/tmp/local-repo");
        k8sProperties.put("zeppelin.k8s.interpreter.rpc.portRange", String.format("%d:%d", this.getPort(), this.getPort()));
        k8sProperties.put("zeppelin.k8s.server.rpc.service", this.intpEventServerHost);
        k8sProperties.put("zeppelin.k8s.server.rpc.portRange", (Object)this.intpEventServerPort);
        if (this.ownerUID() != null && this.ownerName() != null) {
            k8sProperties.put("zeppelin.k8s.server.uid", this.ownerUID());
            k8sProperties.put("zeppelin.k8s.server.pod.name", this.ownerName());
        }
        this.envs.put(ENV_SERVICE_DOMAIN, this.envs.getOrDefault(ENV_SERVICE_DOMAIN, System.getenv(ENV_SERVICE_DOMAIN)));
        this.envs.put(ENV_ZEPPELIN_HOME, this.envs.getOrDefault(ENV_ZEPPELIN_HOME, System.getenv(ENV_ZEPPELIN_HOME)));
        if (this.isSpark()) {
            int webUiPort = 4040;
            k8sProperties.put("zeppelin.k8s.spark.container.image", this.sparkImage);
            if (this.isSparkOnKubernetes(this.properties)) {
                this.envs.put("SPARK_SUBMIT_OPTIONS", this.envs.getOrDefault("SPARK_SUBMIT_OPTIONS", "") + this.buildSparkSubmitOptions(userName));
            }
            this.envs.put("SPARK_HOME", this.envs.getOrDefault("SPARK_HOME", "/spark"));
            String webUrl = (String)this.properties.get("zeppelin.spark.uiWebUrl");
            if (StringUtils.isBlank(webUrl)) {
                webUrl = "//{{PORT}}-{{SERVICE_NAME}}.{{SERVICE_DOMAIN}}";
            }
            this.properties.put("zeppelin.spark.uiWebUrl", this.sparkUiWebUrlFromTemplate(webUrl, webUiPort, this.getPodName(), this.envs.get(ENV_SERVICE_DOMAIN)));
            if (this.properties.containsKey(SPARK_DRIVER_MEMORY)) {
                String memory = this.properties.containsKey(SPARK_DRIVER_MEMORY_OVERHEAD) ? K8sUtils.calculateSparkMemory(this.properties.getProperty(SPARK_DRIVER_MEMORY), this.properties.getProperty(SPARK_DRIVER_MEMORY_OVERHEAD)) : K8sUtils.calculateMemoryWithDefaultOverhead(this.properties.getProperty(SPARK_DRIVER_MEMORY));
                k8sProperties.put("zeppelin.k8s.interpreter.memory", memory);
            }
            if (this.properties.containsKey(SPARK_DRIVER_CORES)) {
                k8sProperties.put("zeppelin.k8s.interpreter.cores", this.properties.getProperty(SPARK_DRIVER_CORES));
            }
        }
        k8sProperties.put("zeppelin.k8s.envs", this.envs);
        k8sProperties.putAll((Map<?, ?>)Maps.fromProperties(this.properties));
        return k8sProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    String sparkUiWebUrlFromTemplate(String templateString, int port, String serviceName, String serviceDomain) {
        ImmutableMap<String, String> binding = ImmutableMap.of("PORT", port, "SERVICE_NAME", serviceName, ENV_SERVICE_DOMAIN, serviceDomain);
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            Jinjava jinja = new Jinjava();
            String string = jinja.render(templateString, binding);
            return string;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    @VisibleForTesting
    boolean isSpark() {
        return "spark".equalsIgnoreCase(this.interpreterGroupName);
    }

    boolean isSparkOnKubernetes(Properties interpreteProperties) {
        String propertySparkMaster = (String)interpreteProperties.getOrDefault((Object)"spark.master", "");
        return propertySparkMaster.startsWith("k8s://");
    }

    @VisibleForTesting
    String buildSparkSubmitOptions(String userName) {
        StringBuilder options = new StringBuilder();
        options.append(" --master k8s://https://kubernetes.default.svc");
        options.append(" --deploy-mode client");
        if (this.properties.containsKey(SPARK_DRIVER_MEMORY)) {
            options.append(" --driver-memory " + this.properties.get(SPARK_DRIVER_MEMORY));
        }
        if (this.isUserImpersonatedForSpark && !StringUtils.containsIgnoreCase(userName, "anonymous") && this.isSpark()) {
            options.append(" --proxy-user " + userName);
        }
        options.append(" --conf spark.kubernetes.namespace=" + this.getNamespace());
        options.append(" --conf spark.executor.instances=1");
        options.append(" --conf spark.kubernetes.driver.pod.name=" + this.getPodName());
        options.append(" --conf spark.kubernetes.container.image=" + this.sparkImage);
        options.append(" --conf spark.driver.bindAddress=0.0.0.0");
        options.append(" --conf spark.driver.host=" + this.getInterpreterPodDnsName());
        options.append(" --conf spark.driver.port=" + String.format("%d", this.getSparkDriverPort()));
        options.append(" --conf spark.blockManager.port=" + String.format("%d", this.getSparkBlockmanagerPort()));
        return options.toString();
    }

    private String getInterpreterPodDnsName() {
        return String.format("%s.%s.svc", this.getPodName(), this.getNamespace());
    }

    @VisibleForTesting
    int getSparkDriverPort() {
        return 22321;
    }

    @VisibleForTesting
    int getSparkBlockmanagerPort() {
        return 22322;
    }

    private String ownerUID() {
        return System.getenv("POD_UID");
    }

    private String ownerName() {
        return System.getenv("POD_NAME");
    }

    private String getRandomString(int length) {
        char[] chars = "abcdefghijklmnopqrstuvwxyz".toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = chars[this.rand.nextInt(chars.length)];
            sb.append(c);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStarted(int port, String host) {
        LOGGER.info("Interpreter pod created {}:{}", (Object)host, (Object)port);
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            this.started.set(true);
            this.started.notifyAll();
        }
    }

    public String getErrorMessage() {
        return String.format("%s%ncurrent PodPhase: %s", this.errorMessage, this.getPodPhase());
    }
}

