/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.test.svg;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.batik.test.svg.ParametrizedRenderingAccuracyTest;

public class SVGReferenceRenderingAccuracyTest
extends ParametrizedRenderingAccuracyTest {
    protected String alias;

    @Override
    public void setId(String id) {
        String[] variationURLs;
        this.id = id;
        String svgFile = id;
        int n = svgFile.lastIndexOf(35);
        if (n == -1 || n + 1 >= svgFile.length()) {
            throw new IllegalArgumentException(id);
        }
        this.parameter = svgFile.substring(n + 1, svgFile.length());
        svgFile = svgFile.substring(0, n);
        n = this.parameter.lastIndexOf(45);
        if (n == -1 || n + 1 >= this.parameter.length()) {
            throw new IllegalArgumentException(id);
        }
        this.alias = this.parameter.substring(n + 1, this.parameter.length());
        this.parameter = this.parameter.substring(0, n);
        String[] dirNfile = this.breakSVGFile(svgFile);
        this.setConfig(this.buildSVGURL(dirNfile[0], dirNfile[1]), this.buildRefImgURL(dirNfile[0], dirNfile[1]));
        for (String variationURL : variationURLs = this.buildVariationURLs(dirNfile[0], dirNfile[1])) {
            this.addVariationURL(variationURL);
        }
        this.setSaveVariation(new File(this.buildSaveVariationFile(dirNfile[0], dirNfile[1])));
        this.setCandidateReference(new File(this.buildCandidateReferenceFile(dirNfile[0], dirNfile[1])));
    }

    @Override
    protected URL resolveURL(String url) {
        File f;
        String fragment = null;
        String file = url;
        int n = file.lastIndexOf(35);
        if (n != -1) {
            fragment = file.substring(n);
            file = file.substring(0, n);
        }
        if ((f = new File(file).getAbsoluteFile()).getParentFile().exists()) {
            try {
                if (fragment == null) {
                    return f.toURI().toURL();
                }
                return new URL(f.toURI().toURL(), fragment);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException();
            }
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(url);
        }
    }

    protected String buildSVGURL(String svgDir, String svgFile) {
        return this.getSVGURLPrefix() + svgDir + svgFile + ".svg" + "#" + this.parameter;
    }

    @Override
    protected String buildRefImgURL(String svgDir, String svgFile) {
        return this.getRefImagePrefix() + svgDir + this.getRefImageSuffix() + svgFile + this.alias + ".png";
    }

    @Override
    public String[] buildVariationURLs(String svgDir, String svgFile) {
        String[] platforms = this.getVariationPlatforms();
        String[] urls = new String[platforms.length + 1];
        urls[0] = this.getVariationPrefix() + svgDir + this.getVariationSuffix() + svgFile + this.alias + ".png";
        for (int i = 0; i < platforms.length; ++i) {
            urls[i + 1] = this.getVariationPrefix() + svgDir + this.getVariationSuffix() + svgFile + this.alias + '_' + platforms[i] + ".png";
        }
        return urls;
    }

    @Override
    public String buildSaveVariationFile(String svgDir, String svgFile) {
        return this.getSaveVariationPrefix() + svgDir + this.getSaveVariationSuffix() + svgFile + this.alias + ".png";
    }

    @Override
    public String buildCandidateReferenceFile(String svgDir, String svgFile) {
        return this.getCandidateReferencePrefix() + svgDir + this.getCandidateReferenceSuffix() + svgFile + this.alias + ".png";
    }
}

