/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.signature;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.u2f.SecurityKeyPublicKey;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.security.SecurityUtils;

public abstract class AbstractSecurityKeySignature
implements Signature {
    private static final int FLAG_USER_PRESENCE = 1;
    private final String keyType;
    private SecurityKeyPublicKey<?> publicKey;
    private MessageDigest challengeDigest;

    protected AbstractSecurityKeySignature(String keyType) {
        this.keyType = keyType;
    }

    @Override
    public void initVerifier(SessionContext session, PublicKey key) throws GeneralSecurityException {
        if (!(key instanceof SecurityKeyPublicKey)) {
            throw new IllegalArgumentException("Only instances of SecurityKeyPublicKey can be used");
        }
        this.publicKey = (SecurityKeyPublicKey)key;
        this.challengeDigest = SecurityUtils.getMessageDigest("SHA-256");
    }

    @Override
    public void update(SessionContext session, byte[] hash, int off, int len) {
        if (this.challengeDigest == null) {
            throw new IllegalStateException("initVerifier must be called before update");
        }
        this.challengeDigest.update(hash, off, len);
    }

    protected abstract String getSignatureKeyType();

    protected abstract Signature getDelegateSignature();

    @Override
    public boolean verify(SessionContext session, byte[] sig) throws Exception {
        if (this.challengeDigest == null) {
            throw new IllegalStateException("initVerifier must be called before verify");
        }
        ByteArrayBuffer data = new ByteArrayBuffer(sig);
        String keyType = data.getString();
        if (!this.keyType.equals(keyType)) {
            return false;
        }
        byte[] rawSig = data.getBytes();
        byte flags = data.getByte();
        long counter = data.getUInt();
        if ((flags & 0xFFFFFFFE) != 0) {
            return false;
        }
        if ((flags & 1) != 1 && !this.publicKey.isNoTouchRequired()) {
            return false;
        }
        ByteArrayBuffer encoded = new ByteArrayBuffer();
        encoded.putString(this.getSignatureKeyType());
        encoded.putBytes(rawSig);
        MessageDigest md = SecurityUtils.getMessageDigest("SHA-256");
        byte[] appNameDigest = md.digest(this.publicKey.getAppName().getBytes(StandardCharsets.UTF_8));
        byte[] challengeDigest = this.challengeDigest.digest();
        ByteArrayBuffer counterData = new ByteArrayBuffer(4, false);
        counterData.putInt(counter);
        Signature delegate = this.getDelegateSignature();
        delegate.initVerifier(session, (PublicKey)this.publicKey.getDelegatePublicKey());
        delegate.update(session, appNameDigest);
        delegate.update(session, new byte[]{flags});
        delegate.update(session, counterData.getCompactData());
        delegate.update(session, challengeDigest);
        return delegate.verify(session, encoded.getCompactData());
    }

    @Override
    public void initSigner(SessionContext session, PrivateKey key) {
        throw new UnsupportedOperationException("Security key private key signatures are unsupported.");
    }

    @Override
    public byte[] sign(SessionContext session) {
        throw new UnsupportedOperationException("Security key private key signatures are unsupported.");
    }
}

