/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.fulcrum.intake.IntakeException;
import org.apache.fulcrum.intake.IntakeRuntimeException;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.model.XmlField;
import org.apache.fulcrum.intake.validator.DateStringValidator;
import org.apache.fulcrum.intake.validator.Validator;

public class DateStringField
extends Field<Date> {
    private static final long serialVersionUID = 3659498567870484883L;
    private DateFormat df = null;

    public DateStringField(XmlField field, Group group) throws IntakeException {
        super(field, group);
        Validator validator = this.getValidator();
        if (validator == null || !(validator instanceof DateStringValidator)) {
            this.df = DateFormat.getInstance();
            this.df.setLenient(true);
        }
    }

    @Override
    public void setDefaultValue(String prop) {
        this.defaultValue = null;
        if (prop == null) {
            return;
        }
        try {
            this.defaultValue = this.getDate(prop);
        }
        catch (ParseException e) {
            throw new IntakeRuntimeException("Could not parse " + prop + " into a valid Date for the default value", e);
        }
    }

    @Override
    public void setEmptyValue(String prop) {
        this.emptyValue = null;
        if (prop == null) {
            return;
        }
        try {
            this.emptyValue = this.getDate(prop);
        }
        catch (ParseException e) {
            throw new IntakeRuntimeException("Could not parse " + prop + " into a valid Date for the empty value", e);
        }
    }

    @Override
    protected String getDefaultValidator() {
        return DateStringValidator.class.getName();
    }

    @Override
    protected void doSetValue() {
        if (this.isMultiValued()) {
            String[] inputs = this.parser.getStrings(this.getKey());
            Date[] values = new Date[inputs.length];
            for (int i = 0; i < inputs.length; ++i) {
                try {
                    values[i] = StringUtils.isNotEmpty((CharSequence)inputs[i]) ? this.getDate(inputs[i]) : (Date)this.getEmptyValue();
                    continue;
                }
                catch (ParseException e) {
                    values[i] = null;
                }
            }
            this.setTestValue(values);
        } else {
            String val = this.parser.getString(this.getKey());
            try {
                this.setTestValue(StringUtils.isNotEmpty((CharSequence)val) ? this.getDate(val) : this.getEmptyValue());
            }
            catch (ParseException e) {
                this.setTestValue(null);
            }
        }
    }

    private Date getDate(String dateString) throws ParseException {
        Date date = null;
        Validator validator = this.getValidator();
        date = validator != null && validator instanceof DateStringValidator ? ((DateStringValidator)validator).parse(dateString) : this.df.parse(dateString);
        return date;
    }

    @Override
    public String toString() {
        String s = null;
        Object value = this.getValue();
        Validator validator = this.getValidator();
        s = value == null ? "" : (value instanceof String ? (String)value : (validator != null && validator instanceof DateStringValidator ? ((DateStringValidator)validator).format((Date)value) : this.df.format((Date)value)));
        return s;
    }
}

