/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.apache.yoko.rmi.util.ByteString;

public class ByteBuffer {
    byte[] contents;
    int pos = 0;
    static final char[] integerData = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public ByteBuffer(int size) {
        this.contents = new byte[size];
    }

    public ByteBuffer() {
        this(48);
    }

    public void append(byte b) {
        this.ensure(1);
        this.contents[this.pos++] = b;
    }

    public void append(char c) {
        this.ensure(1);
        this.contents[this.pos++] = (byte)c;
    }

    public void append(int v, int radix) {
        if (v > radix) {
            this.append(v / radix, radix);
        }
        this.append(integerData[v % radix]);
    }

    public void append(int v) {
        this.append(v, 10);
    }

    public void append(String value) {
        int len = value.length();
        this.ensure(len);
        for (int i = 0; i < len; ++i) {
            this.contents[this.pos++] = (byte)value.charAt(i);
        }
    }

    public void append(byte[] b) {
        this.append(b, 0, b.length);
    }

    public void append(ByteString b) {
        this.append(b.getData(), b.getOffset(), b.length());
    }

    public void append(byte[] b, int off, int len) {
        if (b.length == 0 || len == 0) {
            return;
        }
        this.ensure(len);
        System.arraycopy(b, off, this.contents, this.pos, len);
        this.pos += len;
    }

    public byte[] toByteArray() {
        byte[] barr = new byte[this.pos];
        System.arraycopy(this.contents, 0, barr, 0, this.pos);
        return barr;
    }

    public ByteString toByteString() {
        return new ByteString(this.contents, 0, this.pos);
    }

    public String toString() {
        return this.toByteString().toString();
    }

    private void ensure(int size) {
        if (this.pos + size > this.contents.length) {
            this.grow(this.pos + size);
        }
    }

    private void grow(int minimumSize) {
        int newSize = minimumSize > this.contents.length * 2 ? minimumSize : this.contents.length * 2;
        byte[] barr = new byte[newSize];
        System.arraycopy(this.contents, 0, barr, 0, this.contents.length);
        this.contents = barr;
    }

    public void writeTo(OutputStream out) throws IOException {
        this.writeFully(out, this.contents, 0, this.pos);
    }

    private void writeFully(OutputStream os, byte[] data, int off, int len) throws IOException {
        while (len > 0) {
            int bytes = len;
            try {
                os.write(data, off, len);
            }
            catch (InterruptedIOException ex) {
                bytes = ex.bytesTransferred;
            }
            off += bytes;
            len -= bytes;
        }
    }

    public byte[] getContents() {
        return this.contents;
    }
}

