/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.IOException;
import java.io.Serializable;
import org.apache.yoko.rmi.impl.ObjectReader;
import org.apache.yoko.rmi.impl.ObjectWriter;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.apache.yoko.rmi.impl.ValueDescriptor;
import org.apache.yoko.rmi.util.stub.Stub;

public class RMIStubDescriptor
extends ValueDescriptor {
    String stub_repid = null;

    RMIStubDescriptor(Class type, TypeRepository repository) {
        super(type, repository);
    }

    public String getRepositoryID() {
        if (this.stub_repid == null) {
            this.init_repid();
        }
        return this.stub_repid;
    }

    void init_repid() {
        Class type = this.getJavaClass();
        Class<?>[] ifaces = type.getInterfaces();
        if (ifaces.length != 2 || ifaces[1] != Stub.class) {
            throw new RuntimeException("Unexpected RMIStub structure");
        }
        String ifname = ifaces[0].getName();
        String stubClassName = null;
        int idx = ifname.lastIndexOf(46);
        stubClassName = idx == -1 ? "_" + ifname + "_Stub" : ifname.substring(0, idx + 1) + "_" + ifname.substring(idx + 1) + "_Stub";
        this.stub_repid = "RMI:" + stubClassName + ":0";
    }

    protected void writeValue(ObjectWriter writer, Serializable val) throws IOException {
        this._super_descriptor.writeValue(writer, val);
    }

    protected void readValue(ObjectReader reader, Serializable value) throws IOException {
        this._super_descriptor.readValue(reader, value);
    }
}

