/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.IOException;
import java.lang.reflect.Field;
import java.rmi.Remote;
import java.util.Map;
import java.util.logging.Logger;
import javax.rmi.PortableRemoteObject;
import org.apache.yoko.rmi.impl.CopyRecursionException;
import org.apache.yoko.rmi.impl.CopyRecursionResolver;
import org.apache.yoko.rmi.impl.CopyState;
import org.apache.yoko.rmi.impl.FieldDescriptor;
import org.apache.yoko.rmi.impl.ObjectReader;
import org.apache.yoko.rmi.impl.ObjectWriter;
import org.omg.CORBA.Any;
import org.omg.CORBA.MARSHAL;

class AnyFieldDescriptor
extends FieldDescriptor {
    static final Logger logger = Logger.getLogger(AnyFieldDescriptor.class.getName());
    boolean narrowValue;

    AnyFieldDescriptor(Class owner, Class type, String name, Field f) {
        super(owner, type, name, f);
        this.narrowValue = Remote.class.isAssignableFrom(type);
    }

    public void read(ObjectReader reader, Object obj) throws IOException {
        try {
            Object val = reader.readAny();
            if (this.narrowValue && val != null && !this.type.isInstance(val)) {
                try {
                    val = PortableRemoteObject.narrow((Object)val, (Class)this.type);
                }
                catch (SecurityException ex) {
                    logger.finer("Narrow failed\n" + ex);
                    throw ex;
                }
            } else if (val != null && !this.type.isInstance(val)) {
                throw new MARSHAL("value is instance of " + val.getClass().getName() + " -- should be: " + this.type.getName());
            }
            this.field.set(obj, val);
        }
        catch (IllegalAccessException ex) {
            throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
        }
    }

    public void write(ObjectWriter writer, Object obj) throws IOException {
        try {
            writer.writeAny(this.field.get(obj));
        }
        catch (IllegalAccessException ex) {
            throw (IOException)new IOException(ex.getMessage()).initCause(ex);
        }
    }

    void copyState(Object orig, final Object copy, CopyState state) {
        try {
            this.field.set(copy, state.copy(this.field.get(orig)));
        }
        catch (CopyRecursionException e) {
            state.registerRecursion(new CopyRecursionResolver(orig){

                public void resolve(Object value) {
                    try {
                        AnyFieldDescriptor.this.field.set(copy, value);
                    }
                    catch (IllegalAccessException ex) {
                        throw (InternalError)new InternalError(ex.getMessage()).initCause(ex);
                    }
                }
            });
        }
        catch (IllegalAccessException ex) {
            throw (InternalError)new InternalError(ex.getMessage()).initCause(ex);
        }
    }

    void readFieldIntoMap(ObjectReader reader, Map map) throws IOException {
        Any value = (Any)reader.readAny();
        map.put(this.getJavaName(), value);
    }

    void writeFieldFromMap(ObjectWriter writer, Map map) throws IOException {
        Any value = (Any)map.get(this.getJavaName());
        writer.writeAny(value);
    }
}

