/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.common.annotation.Experimental;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.operators.multi.MultiDemandPacer;
import io.smallrye.mutiny.subscription.DemandPacer;
import java.util.concurrent.ScheduledExecutorService;

@Experimental(value="Demand pacing is a new experimental API introduced in Mutiny 1.5.0")
public class MultiDemandPacing<T> {
    private final AbstractMulti<T> upstream;
    private ScheduledExecutorService executor = Infrastructure.getDefaultWorkerPool();

    public MultiDemandPacing(AbstractMulti<T> upstream) {
        this.upstream = upstream;
    }

    @CheckReturnValue
    public MultiDemandPacing<T> on(ScheduledExecutorService executor) {
        this.executor = ParameterValidation.nonNull(executor, "executor");
        return this;
    }

    @CheckReturnValue
    public Multi<T> using(DemandPacer pacer) {
        return Infrastructure.onMultiCreation(new MultiDemandPacer<T>(this.upstream, this.executor, ParameterValidation.nonNull(pacer, "pacer")));
    }
}

