/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine.control;

import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.jcs.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheConfigurator;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheFactory;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs.engine.behavior.IElementAttributes;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.behavior.IRequireScheduler;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.control.CompositeCacheManager;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs.engine.match.KeyMatcherPatternImpl;
import org.apache.commons.jcs.engine.match.behavior.IKeyMatcher;
import org.apache.commons.jcs.utils.config.OptionConverter;
import org.apache.commons.jcs.utils.config.PropertySetter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompositeCacheConfigurator {
    private static final Log log = LogFactory.getLog(CompositeCacheConfigurator.class);
    protected static final String SYSTEM_PROPERTY_KEY_PREFIX = "jcs";
    protected static final String REGION_PREFIX = "jcs.region.";
    protected static final String SYSTEM_REGION_PREFIX = "jcs.system.";
    protected static final String AUXILIARY_PREFIX = "jcs.auxiliary.";
    protected static final String ATTRIBUTE_PREFIX = ".attributes";
    protected static final String CACHE_ATTRIBUTE_PREFIX = ".cacheattributes";
    protected static final String ELEMENT_ATTRIBUTE_PREFIX = ".elementattributes";
    public static final String KEY_MATCHER_PREFIX = ".keymatcher";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseSystemRegions(Properties props, CompositeCacheManager ccm) {
        for (String key : props.stringPropertyNames()) {
            CompositeCache cache;
            if (!key.startsWith(SYSTEM_REGION_PREFIX) || key.indexOf("attributes") != -1) continue;
            String regionName = key.substring(SYSTEM_REGION_PREFIX.length());
            String auxiliaries = OptionConverter.findAndSubst(key, props);
            String string = regionName;
            synchronized (string) {
                cache = this.parseRegion(props, ccm, regionName, auxiliaries, null, SYSTEM_REGION_PREFIX);
            }
            ccm.addCache(regionName, cache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseRegions(Properties props, CompositeCacheManager ccm) {
        ArrayList<String> regionNames = new ArrayList<String>();
        for (String key : props.stringPropertyNames()) {
            CompositeCache cache;
            if (!key.startsWith(REGION_PREFIX) || key.indexOf("attributes") != -1) continue;
            String regionName = key.substring(REGION_PREFIX.length());
            regionNames.add(regionName);
            String auxiliaries = OptionConverter.findAndSubst(key, props);
            String string = regionName;
            synchronized (string) {
                cache = this.parseRegion(props, ccm, regionName, auxiliaries);
            }
            ccm.addCache(regionName, cache);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Parsed regions " + regionNames));
        }
    }

    protected <K, V> CompositeCache<K, V> parseRegion(Properties props, CompositeCacheManager ccm, String regName, String auxiliaries) {
        return this.parseRegion(props, ccm, regName, auxiliaries, null, REGION_PREFIX);
    }

    protected <K, V> CompositeCache<K, V> parseRegion(Properties props, CompositeCacheManager ccm, String regName, String auxiliaries, ICompositeCacheAttributes cca) {
        return this.parseRegion(props, ccm, regName, auxiliaries, cca, REGION_PREFIX);
    }

    protected <K, V> CompositeCache<K, V> parseRegion(Properties props, CompositeCacheManager ccm, String regName, String auxiliaries, ICompositeCacheAttributes cca, String regionPrefix) {
        IElementAttributes ea = this.parseElementAttributes(props, regName, ccm.getDefaultElementAttributes(), regionPrefix);
        CompositeCache cache = cca == null ? new CompositeCache(this.parseCompositeCacheAttributes(props, regName, ccm.getDefaultCacheAttributes(), regionPrefix), ea) : new CompositeCache(cca, ea);
        cache.setScheduledExecutorService(ccm.getScheduledExecutorService());
        cache.setElementEventQueue(ccm.getElementEventQueue());
        if (cache.getMemoryCache() instanceof IRequireScheduler) {
            ((IRequireScheduler)((Object)cache.getMemoryCache())).setScheduledExecutorService(ccm.getScheduledExecutorService());
        }
        if (auxiliaries != null) {
            ArrayList<AuxiliaryCache<K, V>> auxList = new ArrayList<AuxiliaryCache<K, V>>();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsing region name '" + regName + "', value '" + auxiliaries + "'"));
            }
            StringTokenizer st = new StringTokenizer(auxiliaries, ",");
            if (!(auxiliaries.startsWith(",") || auxiliaries.equals("") || st.hasMoreTokens())) {
                return null;
            }
            while (st.hasMoreTokens()) {
                String auxName = st.nextToken().trim();
                if (auxName == null || auxName.equals(",")) continue;
                log.debug((Object)("Parsing auxiliary named \"" + auxName + "\"."));
                AuxiliaryCache<K, V> auxCache = this.parseAuxiliary(props, ccm, auxName, regName);
                if (auxCache == null) continue;
                if (auxCache instanceof IRequireScheduler) {
                    ((IRequireScheduler)((Object)auxCache)).setScheduledExecutorService(ccm.getScheduledExecutorService());
                }
                auxList.add(auxCache);
            }
            AuxiliaryCache[] auxArray = auxList.toArray(new AuxiliaryCache[0]);
            cache.setAuxCaches(auxArray);
        }
        return cache;
    }

    protected ICompositeCacheAttributes parseCompositeCacheAttributes(Properties props, String regName, ICompositeCacheAttributes defaultCCAttr) {
        return this.parseCompositeCacheAttributes(props, regName, defaultCCAttr, REGION_PREFIX);
    }

    protected ICompositeCacheAttributes parseCompositeCacheAttributes(Properties props, String regName, ICompositeCacheAttributes defaultCCAttr, String regionPrefix) {
        String attrName = regionPrefix + regName + CACHE_ATTRIBUTE_PREFIX;
        ICompositeCacheAttributes ccAttr = OptionConverter.instantiateByKey(props, attrName, null);
        if (ccAttr == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("No special CompositeCacheAttributes class defined for key [" + attrName + "], using default class."));
            }
            ccAttr = defaultCCAttr;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parsing options for '" + attrName + "'"));
        }
        PropertySetter.setProperties(ccAttr, props, attrName + ".");
        ccAttr.setCacheName(regName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("End of parsing for \"" + attrName + "\"."));
        }
        ccAttr.setCacheName(regName);
        return ccAttr;
    }

    protected IElementAttributes parseElementAttributes(Properties props, String regName, IElementAttributes defaultEAttr, String regionPrefix) {
        String attrName = regionPrefix + regName + ELEMENT_ATTRIBUTE_PREFIX;
        IElementAttributes eAttr = OptionConverter.instantiateByKey(props, attrName, null);
        if (eAttr == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("No special ElementAttribute class defined for key [" + attrName + "], using default class."));
            }
            eAttr = defaultEAttr;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parsing options for '" + attrName + "'"));
        }
        PropertySetter.setProperties(eAttr, props, attrName + ".");
        if (log.isDebugEnabled()) {
            log.debug((Object)("End of parsing for \"" + attrName + "\"."));
        }
        return eAttr;
    }

    protected <K, V> AuxiliaryCache<K, V> parseAuxiliary(Properties props, CompositeCacheManager ccm, String auxName, String regName) {
        AuxiliaryCache auxCache;
        if (log.isDebugEnabled()) {
            log.debug((Object)("parseAuxiliary " + auxName));
        }
        if ((auxCache = ccm.getAuxiliaryCache(auxName, regName)) == null) {
            AuxiliaryCacheFactory auxFac = ccm.registryFacGet(auxName);
            if (auxFac == null) {
                String prefix = AUXILIARY_PREFIX + auxName;
                auxFac = OptionConverter.instantiateByKey(props, prefix, null);
                if (auxFac == null) {
                    log.error((Object)("Could not instantiate auxFactory named \"" + auxName + "\"."));
                    return null;
                }
                auxFac.setName(auxName);
                if (auxFac instanceof IRequireScheduler) {
                    ((IRequireScheduler)((Object)auxFac)).setScheduledExecutorService(ccm.getScheduledExecutorService());
                }
                auxFac.initialize();
                ccm.registryFacPut(auxFac);
            }
            AuxiliaryCacheAttributes auxAttr = ccm.registryAttrGet(auxName);
            String attrName = AUXILIARY_PREFIX + auxName + ATTRIBUTE_PREFIX;
            if (auxAttr == null) {
                String prefix = AUXILIARY_PREFIX + auxName + ATTRIBUTE_PREFIX;
                auxAttr = OptionConverter.instantiateByKey(props, prefix, null);
                if (auxAttr == null) {
                    log.error((Object)("Could not instantiate auxAttr named '" + attrName + "'"));
                    return null;
                }
                auxAttr.setName(auxName);
                ccm.registryAttrPut(auxAttr);
            }
            auxAttr = auxAttr.clone();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsing options for '" + attrName + "'"));
            }
            PropertySetter.setProperties(auxAttr, props, attrName + ".");
            auxAttr.setCacheName(regName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("End of parsing for '" + attrName + "'"));
            }
            auxAttr.setCacheName(regName);
            String auxPrefix = AUXILIARY_PREFIX + auxName;
            ICacheEventLogger cacheEventLogger = AuxiliaryCacheConfigurator.parseCacheEventLogger(props, auxPrefix);
            IElementSerializer elementSerializer = AuxiliaryCacheConfigurator.parseElementSerializer(props, auxPrefix);
            try {
                auxCache = auxFac.createCache(auxAttr, ccm, cacheEventLogger, elementSerializer);
            }
            catch (Exception e) {
                log.error((Object)("Could not instantiate auxiliary cache named \"" + regName + "\"."));
                return null;
            }
            ccm.addAuxiliaryCache(auxName, regName, auxCache);
        }
        return auxCache;
    }

    protected static void overrideWithSystemProperties(Properties props) {
        Properties sysProps = System.getProperties();
        for (String key : sysProps.stringPropertyNames()) {
            if (!key.startsWith(SYSTEM_PROPERTY_KEY_PREFIX)) continue;
            if (log.isInfoEnabled()) {
                log.info((Object)("Using system property [[" + key + "] [" + sysProps.getProperty(key) + "]]"));
            }
            props.setProperty(key, sysProps.getProperty(key));
        }
    }

    protected <K> IKeyMatcher<K> parseKeyMatcher(Properties props, String auxPrefix) {
        String keyMatcherClassName = auxPrefix + KEY_MATCHER_PREFIX;
        KeyMatcherPatternImpl keyMatcher = OptionConverter.instantiateByKey(props, keyMatcherClassName, null);
        if (keyMatcher != null) {
            String attributePrefix = auxPrefix + KEY_MATCHER_PREFIX + ATTRIBUTE_PREFIX;
            PropertySetter.setProperties(keyMatcher, props, attributePrefix + ".");
            if (log.isInfoEnabled()) {
                log.info((Object)("Using custom key matcher [" + keyMatcher + "] for auxiliary [" + auxPrefix + "]"));
            }
        } else {
            keyMatcher = new KeyMatcherPatternImpl();
            if (log.isInfoEnabled()) {
                log.info((Object)("Using standard key matcher [" + keyMatcher + "] for auxiliary [" + auxPrefix + "]"));
            }
        }
        return keyMatcher;
    }
}

