/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.services.persistence;

import jakarta.batch.operations.NoSuchJobExecutionException;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.JobInstance;
import jakarta.batch.runtime.Metric;
import jakarta.batch.runtime.StepExecution;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.batchee.container.impl.JobExecutionImpl;
import org.apache.batchee.container.impl.JobInstanceImpl;
import org.apache.batchee.container.impl.StepContextImpl;
import org.apache.batchee.container.impl.StepExecutionImpl;
import org.apache.batchee.container.impl.controller.chunk.CheckpointData;
import org.apache.batchee.container.impl.controller.chunk.CheckpointDataKey;
import org.apache.batchee.container.impl.jobinstance.RuntimeFlowInSplitExecution;
import org.apache.batchee.container.impl.jobinstance.RuntimeJobExecution;
import org.apache.batchee.container.services.InternalJobExecution;
import org.apache.batchee.container.status.JobStatus;
import org.apache.batchee.container.status.StepStatus;
import org.apache.batchee.spi.PersistenceManagerService;

public class MemoryPersistenceManagerService
implements PersistenceManagerService {
    private static final Collection<BatchStatus> RUNNING_STATUSES = new CopyOnWriteArrayList<BatchStatus>(){
        {
            this.add(BatchStatus.STARTED);
            this.add(BatchStatus.STARTING);
            this.add(BatchStatus.STOPPING);
        }
    };
    private static final Data GLOBAL_DATA = new Data();
    private Data data;
    private int maxSize;

    protected Data newData() {
        return new Data();
    }

    @Override
    public void init(Properties batchConfig) {
        this.data = "true".equalsIgnoreCase(batchConfig.getProperty("persistence.memory.global", "false")) ? GLOBAL_DATA : this.newData();
        this.maxSize = Integer.parseInt(batchConfig.getProperty("persistence.memory.max-jobs-instances", "1000"));
    }

    @Override
    public int jobOperatorGetJobInstanceCount(String jobName) {
        int i = 0;
        for (Structures.JobInstanceData jobInstanceData : this.data.jobInstanceData.values()) {
            if (!jobInstanceData.instance.getJobName().equals(jobName)) continue;
            ++i;
        }
        return i;
    }

    @Override
    public Set<String> getJobNames() {
        HashSet<String> jobNames = new HashSet<String>();
        for (Structures.JobInstanceData jobInstanceData : this.data.jobInstanceData.values()) {
            if (jobInstanceData.instance.getJobName() == null || jobInstanceData.instance.getJobName().startsWith(":")) continue;
            jobNames.add(jobInstanceData.instance.getJobName());
        }
        return jobNames;
    }

    @Override
    public List<Long> jobOperatorGetJobInstanceIds(String jobName, int start, int count) {
        LinkedList<Long> out = new LinkedList<Long>();
        for (Structures.JobInstanceData jobInstanceData : this.data.jobInstanceData.values()) {
            if (jobInstanceData.instance.getJobName() == null || !jobInstanceData.instance.getJobName().equals(jobName)) continue;
            out.add(jobInstanceData.instance.getInstanceId());
        }
        Collections.sort(out);
        if (out.size() > 0) {
            try {
                return out.subList(start, start + count);
            }
            catch (IndexOutOfBoundsException oobEx) {
                return out.subList(start, out.size());
            }
        }
        return out;
    }

    @Override
    public Timestamp jobOperatorQueryJobExecutionTimestamp(long key, PersistenceManagerService.TimestampType timestampType) {
        return null;
    }

    @Override
    public String jobOperatorQueryJobExecutionBatchStatus(long key) {
        return null;
    }

    @Override
    public String jobOperatorQueryJobExecutionExitStatus(long key) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StepExecution> getStepExecutionsForJobExecution(long execid) {
        Structures.ExecutionInstanceData executionInstanceData = this.data.executionInstanceData.get(execid);
        if (executionInstanceData == null) {
            return Collections.emptyList();
        }
        List<StepExecution> list = executionInstanceData.stepExecutions;
        synchronized (list) {
            return executionInstanceData.stepExecutions;
        }
    }

    @Override
    public void updateBatchStatusOnly(long executionId, BatchStatus batchStatus, Timestamp timestamp) {
        Structures.ExecutionInstanceData toUpdate = this.data.executionInstanceData.get(executionId);
        toUpdate.execution.setBatchStatus(batchStatus.name());
        toUpdate.execution.setLastUpdateTime(timestamp);
    }

    @Override
    public void markJobStarted(long key, Timestamp startTS) {
        Structures.ExecutionInstanceData toUpdate = this.data.executionInstanceData.get(key);
        toUpdate.execution.setBatchStatus(BatchStatus.STARTED.name());
        toUpdate.execution.setLastUpdateTime(startTS);
        toUpdate.execution.setStartTime(startTS);
    }

    @Override
    public void updateWithFinalExecutionStatusesAndTimestamps(long key, BatchStatus batchStatus, String exitStatus, Timestamp updatets) {
        Structures.ExecutionInstanceData toUpdate = this.data.executionInstanceData.get(key);
        if (batchStatus != null) {
            toUpdate.execution.setBatchStatus(batchStatus.name());
        } else {
            toUpdate.execution.setBatchStatus(null);
        }
        toUpdate.execution.setExitStatus(exitStatus);
        toUpdate.execution.setLastUpdateTime(updatets);
        toUpdate.execution.setEndTime(updatets);
    }

    @Override
    public InternalJobExecution jobOperatorGetJobExecution(long jobExecutionId) {
        Structures.ExecutionInstanceData executionInstanceData = this.data.executionInstanceData.get(jobExecutionId);
        if (executionInstanceData == null) {
            return null;
        }
        return executionInstanceData.execution;
    }

    @Override
    public Properties getParameters(long executionId) throws NoSuchJobExecutionException {
        return this.data.executionInstanceData.get((Object)Long.valueOf((long)executionId)).execution.getJobParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InternalJobExecution> jobOperatorGetJobExecutions(long jobInstanceId) {
        LinkedList<InternalJobExecution> list = new LinkedList<InternalJobExecution>();
        Structures.JobInstanceData jobInstanceData = this.data.jobInstanceData.get(jobInstanceId);
        if (jobInstanceData == null) {
            return list;
        }
        List<Structures.ExecutionInstanceData> list2 = jobInstanceData.executions;
        synchronized (list2) {
            for (Structures.ExecutionInstanceData executionInstanceData : jobInstanceData.executions) {
                list.add(executionInstanceData.execution);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Long> jobOperatorGetRunningExecutions(String jobName) {
        HashSet<Long> set = new HashSet<Long>();
        for (Structures.JobInstanceData instanceData : this.data.jobInstanceData.values()) {
            if (!instanceData.instance.getJobName().equals(jobName)) continue;
            List<Structures.ExecutionInstanceData> list = instanceData.executions;
            synchronized (list) {
                for (Structures.ExecutionInstanceData executionInstanceData : instanceData.executions) {
                    if (!RUNNING_STATUSES.contains(executionInstanceData.execution.getBatchStatus())) continue;
                    set.add(executionInstanceData.execution.getExecutionId());
                }
            }
        }
        return set;
    }

    @Override
    public JobStatus getJobStatusFromExecution(long executionId) {
        Structures.ExecutionInstanceData executionInstanceData = this.data.executionInstanceData.get(executionId);
        if (executionInstanceData == null) {
            return null;
        }
        Structures.JobInstanceData jobInstanceData = this.data.jobInstanceData.get(executionInstanceData.execution.getInstanceId());
        if (jobInstanceData == null) {
            return null;
        }
        return jobInstanceData.status;
    }

    @Override
    public long getJobInstanceIdByExecutionId(long executionId) throws NoSuchJobExecutionException {
        Structures.ExecutionInstanceData executionInstanceData = this.data.executionInstanceData.get(executionId);
        if (executionInstanceData == null) {
            throw new NoSuchJobExecutionException("Execution #" + executionId);
        }
        return executionInstanceData.execution.getInstanceId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobInstance createJobInstance(String name, String jobXml) {
        JobInstanceImpl jobInstance = new JobInstanceImpl(this.data.jobInstanceIdGenerator.getAndIncrement(), jobXml);
        jobInstance.setJobName(name);
        Structures.JobInstanceData jobInstanceData = new Structures.JobInstanceData();
        jobInstanceData.instance = jobInstance;
        if (this.maxSize > 0 && this.data.jobInstanceData.size() >= this.maxSize) {
            MemoryPersistenceManagerService memoryPersistenceManagerService = this;
            synchronized (memoryPersistenceManagerService) {
                while (this.data.jobInstanceData.size() >= this.maxSize) {
                    this.cleanUp(this.data.lastCleanedJobInstanceId.getAndIncrement());
                }
            }
        }
        this.data.jobInstanceData.put(jobInstance.getInstanceId(), jobInstanceData);
        return jobInstance;
    }

    @Override
    public RuntimeJobExecution createJobExecution(JobInstance jobInstance, Properties jobParameters, BatchStatus batchStatus) {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        Structures.ExecutionInstanceData executionInstanceData = this.createRuntimeJobExecutionEntry(jobInstance, jobParameters, batchStatus, now);
        executionInstanceData.execution.setJobName(jobInstance.getJobName());
        RuntimeJobExecution jobExecution = new RuntimeJobExecution(jobInstance, executionInstanceData.execution.getExecutionId(), this);
        jobExecution.setBatchStatus(batchStatus.name());
        jobExecution.setCreateTime(now);
        jobExecution.setLastUpdateTime(now);
        return jobExecution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Structures.ExecutionInstanceData createRuntimeJobExecutionEntry(JobInstance jobInstance, Properties jobParameters, BatchStatus batchStatus, Timestamp now) {
        Structures.ExecutionInstanceData executionInstanceData = new Structures.ExecutionInstanceData();
        long id = this.data.executionInstanceIdGenerator.getAndIncrement();
        executionInstanceData.execution = new JobExecutionImpl(id, jobInstance.getInstanceId(), this);
        executionInstanceData.execution.setExecutionId(id);
        executionInstanceData.execution.setInstanceId(jobInstance.getInstanceId());
        executionInstanceData.execution.setBatchStatus(batchStatus.name());
        executionInstanceData.execution.setCreateTime(now);
        executionInstanceData.execution.setLastUpdateTime(now);
        executionInstanceData.execution.setJobParameters(jobParameters);
        this.data.executionInstanceData.put(id, executionInstanceData);
        Structures.JobInstanceData jobInstanceData = this.data.jobInstanceData.get(jobInstance.getInstanceId());
        List<Structures.ExecutionInstanceData> list = jobInstanceData.executions;
        synchronized (list) {
            jobInstanceData.executions.add(executionInstanceData);
        }
        return executionInstanceData;
    }

    @Override
    public StepExecutionImpl createStepExecution(long rootJobExecId, StepContextImpl stepContext) {
        Metric[] metrics;
        String batchStatus = stepContext.getBatchStatus() == null ? BatchStatus.STARTING.name() : stepContext.getBatchStatus().name();
        String exitStatus = stepContext.getExitStatus();
        String stepName = stepContext.getStepName();
        long readCount = 0L;
        long writeCount = 0L;
        long commitCount = 0L;
        long rollbackCount = 0L;
        long readSkipCount = 0L;
        long processSkipCount = 0L;
        long filterCount = 0L;
        long writeSkipCount = 0L;
        Timestamp startTime = stepContext.getStartTimeTS();
        Timestamp endTime = stepContext.getEndTimeTS();
        for (Metric metric : metrics = stepContext.getMetrics()) {
            if (metric.getType().equals((Object)Metric.MetricType.READ_COUNT)) {
                readCount = metric.getValue();
                continue;
            }
            if (metric.getType().equals((Object)Metric.MetricType.WRITE_COUNT)) {
                writeCount = metric.getValue();
                continue;
            }
            if (metric.getType().equals((Object)Metric.MetricType.PROCESS_SKIP_COUNT)) {
                processSkipCount = metric.getValue();
                continue;
            }
            if (metric.getType().equals((Object)Metric.MetricType.COMMIT_COUNT)) {
                commitCount = metric.getValue();
                continue;
            }
            if (metric.getType().equals((Object)Metric.MetricType.ROLLBACK_COUNT)) {
                rollbackCount = metric.getValue();
                continue;
            }
            if (metric.getType().equals((Object)Metric.MetricType.READ_SKIP_COUNT)) {
                readSkipCount = metric.getValue();
                continue;
            }
            if (metric.getType().equals((Object)Metric.MetricType.FILTER_COUNT)) {
                filterCount = metric.getValue();
                continue;
            }
            if (!metric.getType().equals((Object)Metric.MetricType.WRITE_SKIP_COUNT)) continue;
            writeSkipCount = metric.getValue();
        }
        Serializable persistentData = stepContext.getPersistentUserData();
        return this.createStepExecution(rootJobExecId, batchStatus, exitStatus, stepName, readCount, writeCount, commitCount, rollbackCount, readSkipCount, processSkipCount, filterCount, writeSkipCount, startTime, endTime, persistentData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StepExecutionImpl createStepExecution(long rootJobExecId, String batchStatus, String exitStatus, String stepName, long readCount, long writeCount, long commitCount, long rollbackCount, long readSkipCount, long processSkipCount, long filterCount, long writeSkipCount, Timestamp startTime, Timestamp endTime, Serializable persistentData) {
        StepExecutionImpl stepExecution = new StepExecutionImpl(rootJobExecId, this.data.stepExecutionIdGenerator.getAndIncrement());
        stepExecution.setStepName(stepName);
        Structures.ExecutionInstanceData executionInstanceData = this.data.executionInstanceData.get(rootJobExecId);
        if (executionInstanceData == null) {
            return null;
        }
        List<StepExecution> list = executionInstanceData.stepExecutions;
        synchronized (list) {
            executionInstanceData.stepExecutions.add(stepExecution);
        }
        Structures.StepExecutionInstanceData stepExecutionInstanceData = new Structures.StepExecutionInstanceData();
        stepExecutionInstanceData.execution = stepExecution;
        this.updateStepExecutionInstanceData(executionInstanceData, batchStatus, exitStatus, stepName, readCount, writeCount, commitCount, rollbackCount, readSkipCount, processSkipCount, filterCount, writeSkipCount, startTime, endTime, persistentData, stepExecutionInstanceData);
        this.data.stepExecutionInstanceData.put(stepExecution.getStepExecutionId(), stepExecutionInstanceData);
        return stepExecution;
    }

    private void updateStepExecutionInstanceData(Structures.ExecutionInstanceData exec, String batchStatus, String exitStatus, String stepName, long readCount, long writeCount, long commitCount, long rollbackCount, long readSkipCount, long processSkipCount, long filterCount, long writeSkipCount, Timestamp startTime, Timestamp endTime, Serializable persistentData, Structures.StepExecutionInstanceData stepExecutionInstanceData) {
        stepExecutionInstanceData.jobExec = exec;
        stepExecutionInstanceData.execution.setExitStatus(exitStatus);
        stepExecutionInstanceData.execution.setBatchStatus(BatchStatus.valueOf((String)batchStatus));
        stepExecutionInstanceData.execution.setRollbackCount(rollbackCount);
        stepExecutionInstanceData.execution.setStepName(stepName);
        stepExecutionInstanceData.execution.setReadCount(readCount);
        stepExecutionInstanceData.execution.setWriteCount(writeCount);
        stepExecutionInstanceData.execution.setCommitCount(commitCount);
        stepExecutionInstanceData.execution.setRollbackCount(rollbackCount);
        stepExecutionInstanceData.execution.setReadSkipCount(readSkipCount);
        stepExecutionInstanceData.execution.setProcessSkipCount(processSkipCount);
        stepExecutionInstanceData.execution.setWriteSkipCount(writeSkipCount);
        stepExecutionInstanceData.execution.setFilterCount(filterCount);
        stepExecutionInstanceData.execution.setWriteSkipCount(writeSkipCount);
        stepExecutionInstanceData.execution.setStartTime(startTime);
        stepExecutionInstanceData.execution.setEndTime(endTime);
        stepExecutionInstanceData.execution.setPersistentUserData(persistentData);
    }

    @Override
    public void updateStepExecution(long jobExecId, StepContextImpl stepContext) {
        Metric[] metrics;
        long stepExecutionId = stepContext.getStepInternalExecID();
        String batchStatus = stepContext.getBatchStatus() == null ? BatchStatus.STARTING.name() : stepContext.getBatchStatus().name();
        String exitStatus = stepContext.getExitStatus();
        String stepName = stepContext.getStepName();
        long readCount = 0L;
        long writeCount = 0L;
        long commitCount = 0L;
        long rollbackCount = 0L;
        long readSkipCount = 0L;
        long processSkipCount = 0L;
        long filterCount = 0L;
        long writeSkipCount = 0L;
        Timestamp startTime = stepContext.getStartTimeTS();
        Timestamp endTime = stepContext.getEndTimeTS();
        for (Metric metric : metrics = stepContext.getMetrics()) {
            if (metric.getType().equals((Object)Metric.MetricType.READ_COUNT)) {
                readCount = metric.getValue();
                continue;
            }
            if (metric.getType().equals((Object)Metric.MetricType.WRITE_COUNT)) {
                writeCount = metric.getValue();
                continue;
            }
            if (metric.getType().equals((Object)Metric.MetricType.PROCESS_SKIP_COUNT)) {
                processSkipCount = metric.getValue();
                continue;
            }
            if (metric.getType().equals((Object)Metric.MetricType.COMMIT_COUNT)) {
                commitCount = metric.getValue();
                continue;
            }
            if (metric.getType().equals((Object)Metric.MetricType.ROLLBACK_COUNT)) {
                rollbackCount = metric.getValue();
                continue;
            }
            if (metric.getType().equals((Object)Metric.MetricType.READ_SKIP_COUNT)) {
                readSkipCount = metric.getValue();
                continue;
            }
            if (metric.getType().equals((Object)Metric.MetricType.FILTER_COUNT)) {
                filterCount = metric.getValue();
                continue;
            }
            if (!metric.getType().equals((Object)Metric.MetricType.WRITE_SKIP_COUNT)) continue;
            writeSkipCount = metric.getValue();
        }
        Serializable persistentData = stepContext.getPersistentUserData();
        this.updateStepExecution(stepExecutionId, jobExecId, batchStatus, exitStatus, stepName, readCount, writeCount, commitCount, rollbackCount, readSkipCount, processSkipCount, filterCount, writeSkipCount, startTime, endTime, persistentData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStepExecution(long stepExecutionId, long jobExecId, String batchStatus, String exitStatus, String stepName, long readCount, long writeCount, long commitCount, long rollbackCount, long readSkipCount, long processSkipCount, long filterCount, long writeSkipCount, Timestamp startTime, Timestamp endTime, Serializable persistentData) {
        Structures.ExecutionInstanceData executionInstanceData = this.data.executionInstanceData.get(jobExecId);
        if (executionInstanceData == null) {
            return;
        }
        List<StepExecution> list = executionInstanceData.stepExecutions;
        synchronized (list) {
            for (StepExecution execution : executionInstanceData.stepExecutions) {
                if (execution.getStepExecutionId() != stepExecutionId) continue;
                this.updateStepExecutionInstanceData(executionInstanceData, batchStatus, exitStatus, stepName, readCount, writeCount, commitCount, rollbackCount, readSkipCount, processSkipCount, filterCount, writeSkipCount, startTime, endTime, persistentData, this.data.stepExecutionInstanceData.get(stepExecutionId));
                break;
            }
        }
    }

    @Override
    public JobStatus createJobStatus(long jobInstanceId) {
        Structures.JobInstanceData jobInstanceData = this.data.jobInstanceData.get(jobInstanceId);
        jobInstanceData.status = new JobStatus(jobInstanceId);
        return jobInstanceData.status;
    }

    @Override
    public JobStatus getJobStatus(long instanceId) {
        Structures.JobInstanceData jobInstanceData = this.data.jobInstanceData.get(instanceId);
        if (jobInstanceData == null) {
            return null;
        }
        return jobInstanceData.status;
    }

    @Override
    public void updateJobStatus(long instanceId, JobStatus jobStatus) {
        Structures.JobInstanceData jobInstanceData = this.data.jobInstanceData.get(instanceId);
        if (jobInstanceData != null) {
            jobInstanceData.status = jobStatus;
        }
    }

    @Override
    public StepStatus createStepStatus(long stepExecId) {
        StepStatus stepStatus;
        this.data.stepExecutionInstanceData.get((Object)Long.valueOf((long)stepExecId)).status = stepStatus = new StepStatus(stepExecId);
        return stepStatus;
    }

    @Override
    public StepStatus getStepStatus(long instanceId, String stepName) {
        TreeMap<Date, StepStatus> statusMap = new TreeMap<Date, StepStatus>(ReverseDateComparator.INSTANCE);
        for (Structures.StepExecutionInstanceData stepExecutionInstanceData : this.data.stepExecutionInstanceData.values()) {
            if (stepExecutionInstanceData.jobExec.execution.getInstanceId() != instanceId || !stepExecutionInstanceData.execution.getStepName().equals(stepName) || stepExecutionInstanceData.status == null) continue;
            statusMap.put(stepExecutionInstanceData.jobExec.execution.getCreateTime(), stepExecutionInstanceData.status);
        }
        if (statusMap.isEmpty()) {
            return null;
        }
        return (StepStatus)statusMap.values().iterator().next();
    }

    @Override
    public void updateStepStatus(long stepExecutionId, StepStatus stepStatus) {
        Structures.StepExecutionInstanceData stepExecutionInstanceData = this.data.stepExecutionInstanceData.get(stepExecutionId);
        if (stepExecutionInstanceData != null) {
            stepExecutionInstanceData.status = stepStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCheckpointData(CheckpointDataKey key, CheckpointData value) {
        this.data.checkpointData.put(key, value);
        Structures.JobInstanceData jobInstanceData = this.data.jobInstanceData.get(key.getJobInstanceId());
        Collection<CheckpointDataKey> collection = jobInstanceData.checkpoints;
        synchronized (collection) {
            jobInstanceData.checkpoints.add(key);
        }
    }

    @Override
    public CheckpointData getCheckpointData(CheckpointDataKey key) {
        return this.data.checkpointData.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMostRecentExecutionId(long jobInstanceId) {
        TreeMap<Date, Structures.ExecutionInstanceData> filter = new TreeMap<Date, Structures.ExecutionInstanceData>(ReverseDateComparator.INSTANCE);
        Structures.JobInstanceData jobInstanceData = this.data.jobInstanceData.get(jobInstanceId);
        List<Structures.ExecutionInstanceData> list = jobInstanceData.executions;
        synchronized (list) {
            for (Structures.ExecutionInstanceData exec : jobInstanceData.executions) {
                if (exec.execution.getInstanceId() != jobInstanceId) continue;
                filter.put(exec.execution.getCreateTime(), exec);
            }
        }
        if (filter.isEmpty()) {
            return -1L;
        }
        return ((Structures.ExecutionInstanceData)filter.values().iterator().next()).execution.getExecutionId();
    }

    @Override
    public JobInstance createSubJobInstance(String name) {
        return this.createJobInstance(name, null);
    }

    @Override
    public RuntimeFlowInSplitExecution createFlowInSplitExecution(JobInstance jobInstance, BatchStatus batchStatus) {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        Structures.ExecutionInstanceData executionInstanceData = this.createRuntimeJobExecutionEntry(jobInstance, null, batchStatus, now);
        RuntimeFlowInSplitExecution flowExecution = new RuntimeFlowInSplitExecution(jobInstance, executionInstanceData.execution.getExecutionId(), this);
        flowExecution.setBatchStatus(batchStatus.name());
        flowExecution.setCreateTime(now);
        flowExecution.setLastUpdateTime(now);
        return flowExecution;
    }

    @Override
    public StepExecution getStepExecutionByStepExecutionId(long stepExecId) {
        return this.data.stepExecutionInstanceData.get((Object)Long.valueOf((long)stepExecId)).execution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUp(long instanceId) {
        Structures.JobInstanceData jobInstanceData = this.data.jobInstanceData.remove(instanceId);
        if (jobInstanceData == null) {
            return;
        }
        Collection<Object> collection = jobInstanceData.executions;
        synchronized (collection) {
            for (Structures.ExecutionInstanceData executionInstanceData : jobInstanceData.executions) {
                this.data.executionInstanceData.remove(executionInstanceData.execution.getExecutionId());
                List<StepExecution> list = executionInstanceData.stepExecutions;
                synchronized (list) {
                    for (StepExecution stepExecution : executionInstanceData.stepExecutions) {
                        this.data.stepExecutionInstanceData.remove(stepExecution.getStepExecutionId());
                    }
                }
            }
        }
        collection = jobInstanceData.checkpoints;
        synchronized (collection) {
            for (CheckpointDataKey key : jobInstanceData.checkpoints) {
                this.data.checkpointData.remove(key);
            }
        }
    }

    @Override
    public void cleanUp(Date until) {
        ArrayList<Long> instanceIdToRemove = new ArrayList<Long>();
        for (Map.Entry<Long, Structures.JobInstanceData> entry : this.data.jobInstanceData.entrySet()) {
            boolean match = true;
            for (Structures.ExecutionInstanceData exec : entry.getValue().executions) {
                if (exec.execution.getEndTime() != null && !exec.execution.getEndTime().after(until)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            instanceIdToRemove.add(entry.getKey());
        }
        for (Long id : instanceIdToRemove) {
            this.cleanUp(id);
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    private static class ReverseDateComparator
    implements Comparator<Date> {
        public static final ReverseDateComparator INSTANCE = new ReverseDateComparator();

        private ReverseDateComparator() {
        }

        @Override
        public int compare(Date o1, Date o2) {
            return o2.compareTo(o1);
        }
    }

    static class Data {
        protected final AtomicLong lastCleanedJobInstanceId = new AtomicLong(0L);
        protected final AtomicLong jobInstanceIdGenerator = new AtomicLong();
        protected final AtomicLong executionInstanceIdGenerator = new AtomicLong();
        protected final AtomicLong stepExecutionIdGenerator = new AtomicLong();
        protected final Map<CheckpointDataKey, CheckpointData> checkpointData = new ConcurrentHashMap<CheckpointDataKey, CheckpointData>();
        protected final Map<Long, Structures.JobInstanceData> jobInstanceData = new ConcurrentHashMap<Long, Structures.JobInstanceData>();
        protected final Map<Long, Structures.ExecutionInstanceData> executionInstanceData = new ConcurrentHashMap<Long, Structures.ExecutionInstanceData>();
        protected final Map<Long, Structures.StepExecutionInstanceData> stepExecutionInstanceData = new ConcurrentHashMap<Long, Structures.StepExecutionInstanceData>();

        Data() {
        }
    }

    protected static interface Structures
    extends Serializable {

        public static class StepExecutionInstanceData
        implements Structures {
            protected ExecutionInstanceData jobExec;
            protected StepExecutionImpl execution;
            protected StepStatus status;
        }

        public static class ExecutionInstanceData
        implements Structures {
            protected final List<StepExecution> stepExecutions = new LinkedList<StepExecution>();
            protected JobExecutionImpl execution;
        }

        public static class JobInstanceData
        implements Structures {
            protected JobInstanceImpl instance;
            protected JobStatus status;
            protected final List<ExecutionInstanceData> executions = new LinkedList<ExecutionInstanceData>();
            protected final Collection<CheckpointDataKey> checkpoints = new LinkedList<CheckpointDataKey>();
        }
    }
}

