/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.submarine.server.submitter.yarnservice.tensorflow.component;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.submarine.client.cli.param.runjob.TensorFlowRunJobParameters;
import org.apache.submarine.commons.runtime.api.Role;
import org.apache.submarine.commons.runtime.fs.RemoteDirectoryManager;
import org.apache.submarine.server.submitter.yarnservice.AbstractComponent;
import org.apache.submarine.server.submitter.yarnservice.FileSystemOperations;
import org.apache.submarine.server.submitter.yarnservice.command.TensorFlowLaunchCommandFactory;

import java.io.IOException;

/**
 * Component implementation for TensorFlow's Worker process.
 */
public class TensorFlowWorkerComponent extends AbstractComponent {
  public TensorFlowWorkerComponent(FileSystemOperations fsOperations,
                                   RemoteDirectoryManager remoteDirectoryManager,
                                   TensorFlowRunJobParameters parameters, Role role,
                                   TensorFlowLaunchCommandFactory launchCommandFactory,
                                   Configuration yarnConfig) {
    super(fsOperations, remoteDirectoryManager, parameters, role,
        yarnConfig, launchCommandFactory);
  }

  @Override
  public Component createComponent() throws IOException {
    return createComponentInternal();
  }
}
