/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1alpha1 "github.com/apache/submarine/submarine-cloud/pkg/apis/submarine/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeSubmarineClusters implements SubmarineClusterInterface
type FakeSubmarineClusters struct {
	Fake *FakeSubmarineV1alpha1
	ns   string
}

var submarineclustersResource = schema.GroupVersionResource{Group: "submarine.apache.org", Version: "v1alpha1", Resource: "submarineclusters"}

var submarineclustersKind = schema.GroupVersionKind{Group: "submarine.apache.org", Version: "v1alpha1", Kind: "SubmarineCluster"}

// Get takes name of the submarineCluster, and returns the corresponding submarineCluster object, and an error if there is any.
func (c *FakeSubmarineClusters) Get(name string, options v1.GetOptions) (result *v1alpha1.SubmarineCluster, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(submarineclustersResource, c.ns, name), &v1alpha1.SubmarineCluster{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.SubmarineCluster), err
}

// List takes label and field selectors, and returns the list of SubmarineClusters that match those selectors.
func (c *FakeSubmarineClusters) List(opts v1.ListOptions) (result *v1alpha1.SubmarineClusterList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(submarineclustersResource, submarineclustersKind, c.ns, opts), &v1alpha1.SubmarineClusterList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.SubmarineClusterList{ListMeta: obj.(*v1alpha1.SubmarineClusterList).ListMeta}
	for _, item := range obj.(*v1alpha1.SubmarineClusterList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested submarineClusters.
func (c *FakeSubmarineClusters) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(submarineclustersResource, c.ns, opts))

}

// Create takes the representation of a submarineCluster and creates it.  Returns the server's representation of the submarineCluster, and an error, if there is any.
func (c *FakeSubmarineClusters) Create(submarineCluster *v1alpha1.SubmarineCluster) (result *v1alpha1.SubmarineCluster, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(submarineclustersResource, c.ns, submarineCluster), &v1alpha1.SubmarineCluster{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.SubmarineCluster), err
}

// Update takes the representation of a submarineCluster and updates it. Returns the server's representation of the submarineCluster, and an error, if there is any.
func (c *FakeSubmarineClusters) Update(submarineCluster *v1alpha1.SubmarineCluster) (result *v1alpha1.SubmarineCluster, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(submarineclustersResource, c.ns, submarineCluster), &v1alpha1.SubmarineCluster{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.SubmarineCluster), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeSubmarineClusters) UpdateStatus(submarineCluster *v1alpha1.SubmarineCluster) (*v1alpha1.SubmarineCluster, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(submarineclustersResource, "status", c.ns, submarineCluster), &v1alpha1.SubmarineCluster{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.SubmarineCluster), err
}

// Delete takes name of the submarineCluster and deletes it. Returns an error if one occurs.
func (c *FakeSubmarineClusters) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(submarineclustersResource, c.ns, name), &v1alpha1.SubmarineCluster{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeSubmarineClusters) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(submarineclustersResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &v1alpha1.SubmarineClusterList{})
	return err
}

// Patch applies the patch and returns the patched submarineCluster.
func (c *FakeSubmarineClusters) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.SubmarineCluster, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(submarineclustersResource, c.ns, name, pt, data, subresources...), &v1alpha1.SubmarineCluster{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.SubmarineCluster), err
}
