<!--
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->

## Apache Submarine Community

Welcome to the Apache Submarine Community! The main objective is to help members of the Submarine community who share similar interests to learn from and collaborate with each other.

Your journey of becoming a contributor and committer starts from here: improving docs, improving code, giving talks, organizing meetups, etc.

## Communicating

You can reach out to the community members via any one of the following ways:

+ Slack Developer: [https://the-asf.slack.com/submarine-dev/](https://the-asf.slack.com/submarine-dev/)

+ Slack User: [https://the-asf.slack.com/submarine-user/](https://the-asf.slack.com/submarine-user/)

+ Zoom: [https://cloudera.zoom.us/j/880548968](https://cloudera.zoom.us/j/880548968)

+ Sync Up: [https://docs.google.com/document/d/16pUO3TP4SxSeLduG817GhVAjtiph9HYpRHo_JgduDvw/edit](https://docs.google.com/document/d/16pUO3TP4SxSeLduG817GhVAjtiph9HYpRHo_JgduDvw/edit)

## Your First Contribution

You can start by finding an existing issue with the [https://issues.apache.org/jira/projects/SUBMARINE/issues/SUBMARINE?filter=allopenissues](https://issues.apache.org/jira/projects/SUBMARINE/issues/SUBMARINE?filter=allopenissues) label. These issues are well suited for new contributors.

If a PR (Pull Request) submitted to the [Submarine Github](https://github.com/apache/submarine) projects by you is approved and merged, then you become a Submarine Contributor.

If you want to work on a new idea of relatively small scope:

1. Submit an issue describing your proposed change to the repo in question.

2. The repo owners will respond to your issue promptly.

3. Submit a [pull request of Submarine](https://github.com/apache/submarine) containing a tested change.

Once you become a contributor of Apache Submarine, check your name here: [CONTRIBUTORS](contributors.md)

Contributions are welcomed and greatly appreciated. See [CONTRIBUTING.md](contributing.md) for details on submitting patches and the contribution workflow.

## How Do I Become a Committer?

First of all, you need to get involved and be a Contributor.

Based on your track-record as a contributor, Per Apache code, PMCs vote on committership, may invite you to be a committer (after we've called a vote). When that happens, if you accept, the following process kicks into place...

Note that becoming a committer is not just about submitting some patches; it‘s also about helping out on the development and user [Slack User](https://the-asf.slack.com/submarine-user/), helping with documentation and the issues.

See [Become a Committer.md](become-a-committer.md) for steps of becoming a committer and more details.

## How to commit

See [How to commit](HowToCommit.md) for helper doc for Submarine committers.

## Communication

Communication within the Submarine community abides by [Apache’s Code of Conduct](https://www.apache.org/foundation/policies/conduct.html).

## License

Submarine source code is under the Apache 2.0 license. See the [LICENSE](https://github.com/apache/submarine/blob/master/LICENSE) file for details.
