/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.submarine.client.cli.yarnservice;

import org.apache.submarine.commons.runtime.MockClientContext;
import org.apache.submarine.commons.runtime.RuntimeFactory;
import org.apache.submarine.commons.runtime.fs.MemorySubmarineStorage;
import org.apache.submarine.server.submitter.yarnservice.YarnServiceRuntimeFactory;

import java.io.IOException;

import static org.apache.submarine.client.cli.yarnservice.YarnServiceRunJobCliCommonsTest.DEFAULT_JOB_NAME;

public class YarnServiceCliTestUtils {
  public static MockClientContext getMockClientContext() throws IOException {
    MockClientContext mockClientContext = new MockClientContext(DEFAULT_JOB_NAME);
    RuntimeFactory runtimeFactory = new YarnServiceRuntimeFactory(
        mockClientContext);
    mockClientContext.setRuntimeFactory(runtimeFactory);
    runtimeFactory.setSubmarineStorage(new MemorySubmarineStorage());
    return mockClientContext;
  }
}
