/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/apache/submarine/submarine-cloud/pkg/apis/submarine/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// SubmarineClusterLister helps list SubmarineClusters.
type SubmarineClusterLister interface {
	// List lists all SubmarineClusters in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.SubmarineCluster, err error)
	// SubmarineClusters returns an object that can list and get SubmarineClusters.
	SubmarineClusters(namespace string) SubmarineClusterNamespaceLister
	SubmarineClusterListerExpansion
}

// submarineClusterLister implements the SubmarineClusterLister interface.
type submarineClusterLister struct {
	indexer cache.Indexer
}

// NewSubmarineClusterLister returns a new SubmarineClusterLister.
func NewSubmarineClusterLister(indexer cache.Indexer) SubmarineClusterLister {
	return &submarineClusterLister{indexer: indexer}
}

// List lists all SubmarineClusters in the indexer.
func (s *submarineClusterLister) List(selector labels.Selector) (ret []*v1alpha1.SubmarineCluster, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.SubmarineCluster))
	})
	return ret, err
}

// SubmarineClusters returns an object that can list and get SubmarineClusters.
func (s *submarineClusterLister) SubmarineClusters(namespace string) SubmarineClusterNamespaceLister {
	return submarineClusterNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// SubmarineClusterNamespaceLister helps list and get SubmarineClusters.
type SubmarineClusterNamespaceLister interface {
	// List lists all SubmarineClusters in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.SubmarineCluster, err error)
	// Get retrieves the SubmarineCluster from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.SubmarineCluster, error)
	SubmarineClusterNamespaceListerExpansion
}

// submarineClusterNamespaceLister implements the SubmarineClusterNamespaceLister
// interface.
type submarineClusterNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all SubmarineClusters in the indexer for a given namespace.
func (s submarineClusterNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.SubmarineCluster, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.SubmarineCluster))
	})
	return ret, err
}

// Get retrieves the SubmarineCluster from the indexer for a given namespace and name.
func (s submarineClusterNamespaceLister) Get(name string) (*v1alpha1.SubmarineCluster, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("submarinecluster"), name)
	}
	return obj.(*v1alpha1.SubmarineCluster), nil
}
