/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.tony.util.gpu;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.linkedin.tony.util.gpu.GpuDeviceInformation;
import com.linkedin.tony.util.gpu.GpuDeviceInformationParser;
import com.linkedin.tony.util.gpu.GpuInfoException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Shell;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class GpuDiscoverer {
    public static final Log LOG = LogFactory.getLog(GpuDiscoverer.class);
    @VisibleForTesting
    protected static final String DEFAULT_BINARY_NAME = "nvidia-smi";
    private static final Set<String> DEFAULT_BINARY_SEARCH_DIRS = ImmutableSet.of((Object)"/usr/bin", (Object)"/bin", (Object)"/usr/local/nvidia/bin");
    private static final int MAX_EXEC_TIMEOUT_MS = 10000;
    private static GpuDiscoverer instance = new GpuDiscoverer();
    private Configuration conf = null;
    private String pathOfGpuBinary = null;
    private Map<String, String> environment = new HashMap<String, String>();
    private GpuDeviceInformationParser parser = new GpuDeviceInformationParser();
    private int numOfErrorExecutionSinceLastSucceed = 0;
    GpuDeviceInformation lastDiscoveredGpuInformation = null;

    private void validateConfOrThrowException() throws GpuInfoException {
        if (this.conf == null) {
            throw new GpuInfoException("Please initialize (call initialize) before use " + GpuDiscoverer.class.getSimpleName());
        }
    }

    public synchronized GpuDeviceInformation getGpuDeviceInformation() throws GpuInfoException {
        this.validateConfOrThrowException();
        if (null == this.pathOfGpuBinary) {
            throw new GpuInfoException("Failed to find GPU discovery executable, please double check tony.gpu-exec-path setting.");
        }
        if (this.numOfErrorExecutionSinceLastSucceed == 10) {
            String msg = "Failed to execute GPU device information detection script for 10 times, skip following executions.";
            LOG.error((Object)msg);
            throw new GpuInfoException(msg);
        }
        try {
            String output = Shell.execCommand(this.environment, (String[])new String[]{this.pathOfGpuBinary, "-x", "-q"}, (long)10000L);
            GpuDeviceInformation info = this.parser.parseXml(output);
            this.numOfErrorExecutionSinceLastSucceed = 0;
            this.lastDiscoveredGpuInformation = info;
            return info;
        }
        catch (IOException e) {
            ++this.numOfErrorExecutionSinceLastSucceed;
            String msg = "Failed to execute " + this.pathOfGpuBinary + " exception message:" + e.getMessage() + ", continue ...";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)msg);
            }
            throw new GpuInfoException(e);
        }
        catch (GpuInfoException e) {
            ++this.numOfErrorExecutionSinceLastSucceed;
            String msg = "Failed to parse xml output" + e.getMessage();
            if (LOG.isDebugEnabled()) {
                LOG.warn((Object)msg, (Throwable)e);
            }
            throw e;
        }
    }

    public synchronized GpuDeviceInformation initialize(Configuration conf) {
        File binaryPath;
        GpuDeviceInformation info = null;
        this.conf = conf;
        this.numOfErrorExecutionSinceLastSucceed = 0;
        String pathToExecutable = conf.get("tony.gpu-exec-path", DEFAULT_BINARY_NAME);
        if (pathToExecutable.isEmpty()) {
            pathToExecutable = DEFAULT_BINARY_NAME;
        }
        if (!(binaryPath = new File(pathToExecutable)).exists()) {
            LOG.warn((Object)("Failed to locate binary at: " + binaryPath.getAbsolutePath()));
            boolean found = false;
            for (String dir : DEFAULT_BINARY_SEARCH_DIRS) {
                binaryPath = new File(dir, DEFAULT_BINARY_NAME);
                if (!binaryPath.exists()) continue;
                found = true;
                this.pathOfGpuBinary = binaryPath.getAbsolutePath();
                break;
            }
            if (!found) {
                LOG.warn((Object)("Failed to locate binary at:" + binaryPath.getAbsolutePath() + ", please double check [" + "tony.gpu-exec-path" + "] setting. Now use default binary:" + DEFAULT_BINARY_NAME));
            }
        } else {
            if (binaryPath.isDirectory()) {
                binaryPath = new File(binaryPath, DEFAULT_BINARY_NAME);
                LOG.warn((Object)("Specified path is a directory, use nvidia-smi under the directory, updated path-to-executable:" + binaryPath.getAbsolutePath()));
            }
            this.pathOfGpuBinary = binaryPath.getAbsolutePath();
        }
        try {
            LOG.info((Object)"Trying to discover GPU information ...");
            info = this.getGpuDeviceInformation();
            LOG.info((Object)info.toString());
        }
        catch (GpuInfoException e) {
            String msg = "Failed to discover GPU information from system, exception message:" + e.getMessage() + " continue...";
            LOG.warn((Object)msg);
        }
        return info;
    }

    public int getNumOfErrorExecutionSinceLastSucceed() {
        return this.numOfErrorExecutionSinceLastSucceed;
    }

    @VisibleForTesting
    protected Map<String, String> getEnvironmentToRunCommand() {
        return this.environment;
    }

    @VisibleForTesting
    protected String getPathOfGpuBinary() {
        return this.pathOfGpuBinary;
    }

    public static GpuDiscoverer getInstance() {
        return instance;
    }
}

