/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.tony.util.gpu;

import com.linkedin.tony.util.gpu.GpuDeviceInformation;
import com.linkedin.tony.util.gpu.GpuInfoException;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class GpuDeviceInformationParser {
    private static final Logger LOG = LoggerFactory.getLogger(GpuDeviceInformationParser.class);
    private Unmarshaller unmarshaller = null;
    private XMLReader xmlReader = null;

    private void init() throws SAXException, ParserConfigurationException, JAXBException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        spf.setFeature("http://xml.org/sax/features/validation", false);
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GpuDeviceInformation.class});
        this.xmlReader = spf.newSAXParser().getXMLReader();
        this.unmarshaller = jaxbContext.createUnmarshaller();
    }

    public synchronized GpuDeviceInformation parseXml(String xmlContent) throws GpuInfoException {
        if (this.unmarshaller == null) {
            try {
                this.init();
            }
            catch (JAXBException | ParserConfigurationException | SAXException e) {
                LOG.error("Exception while initialize parser", e);
                throw new GpuInfoException(e);
            }
        }
        InputSource inputSource = new InputSource(new StringReader(xmlContent));
        SAXSource source = new SAXSource(this.xmlReader, inputSource);
        try {
            return (GpuDeviceInformation)this.unmarshaller.unmarshal((Source)source);
        }
        catch (JAXBException e) {
            LOG.error("Exception while parsing xml", (Throwable)e);
            throw new GpuInfoException(e);
        }
    }
}

